/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>SplitShard</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SplitShardRequest extends KinesisRequest implements
        ToCopyableBuilder<SplitShardRequest.Builder, SplitShardRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SplitShardRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> SHARD_TO_SPLIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SplitShardRequest::shardToSplit)).setter(setter(Builder::shardToSplit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardToSplit").build()).build();

    private static final SdkField<String> NEW_STARTING_HASH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SplitShardRequest::newStartingHashKey)).setter(setter(Builder::newStartingHashKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewStartingHashKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            SHARD_TO_SPLIT_FIELD, NEW_STARTING_HASH_KEY_FIELD));

    private final String streamName;

    private final String shardToSplit;

    private final String newStartingHashKey;

    private SplitShardRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardToSplit = builder.shardToSplit;
        this.newStartingHashKey = builder.newStartingHashKey;
    }

    /**
     * <p>
     * The name of the stream for the shard split.
     * </p>
     * 
     * @return The name of the stream for the shard split.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The shard ID of the shard to split.
     * </p>
     * 
     * @return The shard ID of the shard to split.
     */
    public String shardToSplit() {
        return shardToSplit;
    }

    /**
     * <p>
     * A hash key value for the starting hash key of one of the child shards created by the split. The hash key range
     * for a given shard constitutes a set of ordered contiguous positive integers. The value for
     * <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
     * <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are distributed
     * to one of the child shards. All the lower hash key values in the range are distributed to the other child shard.
     * </p>
     * 
     * @return A hash key value for the starting hash key of one of the child shards created by the split. The hash key
     *         range for a given shard constitutes a set of ordered contiguous positive integers. The value for
     *         <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
     *         <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
     *         distributed to one of the child shards. All the lower hash key values in the range are distributed to the
     *         other child shard.
     */
    public String newStartingHashKey() {
        return newStartingHashKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(shardToSplit());
        hashCode = 31 * hashCode + Objects.hashCode(newStartingHashKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SplitShardRequest)) {
            return false;
        }
        SplitShardRequest other = (SplitShardRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(shardToSplit(), other.shardToSplit())
                && Objects.equals(newStartingHashKey(), other.newStartingHashKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SplitShardRequest").add("StreamName", streamName()).add("ShardToSplit", shardToSplit())
                .add("NewStartingHashKey", newStartingHashKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ShardToSplit":
            return Optional.ofNullable(clazz.cast(shardToSplit()));
        case "NewStartingHashKey":
            return Optional.ofNullable(clazz.cast(newStartingHashKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SplitShardRequest, T> g) {
        return obj -> g.apply((SplitShardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, SplitShardRequest> {
        /**
         * <p>
         * The name of the stream for the shard split.
         * </p>
         * 
         * @param streamName
         *        The name of the stream for the shard split.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The shard ID of the shard to split.
         * </p>
         * 
         * @param shardToSplit
         *        The shard ID of the shard to split.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardToSplit(String shardToSplit);

        /**
         * <p>
         * A hash key value for the starting hash key of one of the child shards created by the split. The hash key
         * range for a given shard constitutes a set of ordered contiguous positive integers. The value for
         * <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
         * <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
         * distributed to one of the child shards. All the lower hash key values in the range are distributed to the
         * other child shard.
         * </p>
         * 
         * @param newStartingHashKey
         *        A hash key value for the starting hash key of one of the child shards created by the split. The hash
         *        key range for a given shard constitutes a set of ordered contiguous positive integers. The value for
         *        <code>NewStartingHashKey</code> must be in the range of hash keys being mapped into the shard. The
         *        <code>NewStartingHashKey</code> hash key value and all higher hash key values in hash key range are
         *        distributed to one of the child shards. All the lower hash key values in the range are distributed to
         *        the other child shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newStartingHashKey(String newStartingHashKey);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String shardToSplit;

        private String newStartingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SplitShardRequest model) {
            super(model);
            streamName(model.streamName);
            shardToSplit(model.shardToSplit);
            newStartingHashKey(model.newStartingHashKey);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardToSplit() {
            return shardToSplit;
        }

        @Override
        public final Builder shardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
            return this;
        }

        public final void setShardToSplit(String shardToSplit) {
            this.shardToSplit = shardToSplit;
        }

        public final String getNewStartingHashKey() {
            return newStartingHashKey;
        }

        @Override
        public final Builder newStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
            return this;
        }

        public final void setNewStartingHashKey(String newStartingHashKey) {
            this.newStartingHashKey = newStartingHashKey;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SplitShardRequest build() {
            return new SplitShardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
