/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribeToShardRequest extends KinesisRequest implements
        ToCopyableBuilder<SubscribeToShardRequest.Builder, SubscribeToShardRequest> {
    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribeToShardRequest::consumerARN)).setter(setter(Builder::consumerARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()).build();

    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SubscribeToShardRequest::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<StartingPosition> STARTING_POSITION_FIELD = SdkField
            .<StartingPosition> builder(MarshallingType.SDK_POJO).getter(getter(SubscribeToShardRequest::startingPosition))
            .setter(setter(Builder::startingPosition)).constructor(StartingPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_ARN_FIELD,
            SHARD_ID_FIELD, STARTING_POSITION_FIELD));

    private final String consumerARN;

    private final String shardId;

    private final StartingPosition startingPosition;

    private SubscribeToShardRequest(BuilderImpl builder) {
        super(builder);
        this.consumerARN = builder.consumerARN;
        this.shardId = builder.shardId;
        this.startingPosition = builder.startingPosition;
    }

    /**
     * <p>
     * For this parameter, use the value you obtained when you called <a>RegisterStreamConsumer</a>.
     * </p>
     * 
     * @return For this parameter, use the value you obtained when you called <a>RegisterStreamConsumer</a>.
     */
    public String consumerARN() {
        return consumerARN;
    }

    /**
     * <p>
     * The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use
     * <a>ListShards</a>.
     * </p>
     * 
     * @return The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use
     *         <a>ListShards</a>.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * Returns the value of the StartingPosition property for this object.
     * 
     * @return The value of the StartingPosition property for this object.
     */
    public StartingPosition startingPosition() {
        return startingPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(consumerARN());
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(startingPosition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardRequest)) {
            return false;
        }
        SubscribeToShardRequest other = (SubscribeToShardRequest) obj;
        return Objects.equals(consumerARN(), other.consumerARN()) && Objects.equals(shardId(), other.shardId())
                && Objects.equals(startingPosition(), other.startingPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscribeToShardRequest").add("ConsumerARN", consumerARN()).add("ShardId", shardId())
                .add("StartingPosition", startingPosition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConsumerARN":
            return Optional.ofNullable(clazz.cast(consumerARN()));
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "StartingPosition":
            return Optional.ofNullable(clazz.cast(startingPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribeToShardRequest, T> g) {
        return obj -> g.apply((SubscribeToShardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, SubscribeToShardRequest> {
        /**
         * <p>
         * For this parameter, use the value you obtained when you called <a>RegisterStreamConsumer</a>.
         * </p>
         * 
         * @param consumerARN
         *        For this parameter, use the value you obtained when you called <a>RegisterStreamConsumer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerARN(String consumerARN);

        /**
         * <p>
         * The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use
         * <a>ListShards</a>.
         * </p>
         * 
         * @param shardId
         *        The ID of the shard you want to subscribe to. To see a list of all the shards for a given stream, use
         *        <a>ListShards</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * Sets the value of the StartingPosition property for this object.
         *
         * @param startingPosition
         *        The new value for the StartingPosition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingPosition(StartingPosition startingPosition);

        /**
         * Sets the value of the StartingPosition property for this object.
         *
         * This is a convenience that creates an instance of the {@link StartingPosition.Builder} avoiding the need to
         * create one manually via {@link StartingPosition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartingPosition.Builder#build()} is called immediately and its
         * result is passed to {@link #startingPosition(StartingPosition)}.
         * 
         * @param startingPosition
         *        a consumer that will call methods on {@link StartingPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startingPosition(StartingPosition)
         */
        default Builder startingPosition(Consumer<StartingPosition.Builder> startingPosition) {
            return startingPosition(StartingPosition.builder().applyMutation(startingPosition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String consumerARN;

        private String shardId;

        private StartingPosition startingPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeToShardRequest model) {
            super(model);
            consumerARN(model.consumerARN);
            shardId(model.shardId);
            startingPosition(model.startingPosition);
        }

        public final String getConsumerARN() {
            return consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final StartingPosition.Builder getStartingPosition() {
            return startingPosition != null ? startingPosition.toBuilder() : null;
        }

        @Override
        public final Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public final void setStartingPosition(StartingPosition.BuilderImpl startingPosition) {
            this.startingPosition = startingPosition != null ? startingPosition.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SubscribeToShardRequest build() {
            return new SubscribeToShardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
