/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListShardsRequest extends KinesisRequest implements
        ToCopyableBuilder<ListShardsRequest.Builder, ListShardsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListShardsRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListShardsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListShardsRequest::exclusiveStartShardId)).setter(setter(Builder::exclusiveStartShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListShardsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ListShardsRequest::streamCreationTimestamp)).setter(setter(Builder::streamCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            NEXT_TOKEN_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, MAX_RESULTS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD));

    private final String streamName;

    private final String nextToken;

    private final String exclusiveStartShardId;

    private final Integer maxResults;

    private final Instant streamCreationTimestamp;

    private ListShardsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.nextToken = builder.nextToken;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.maxResults = builder.maxResults;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
    }

    /**
     * <p>
     * The name of the data stream whose shards you want to list.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return The name of the data stream whose shards you want to list. </p>
     *         <p>
     *         You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * When the number of shards in the data stream is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * shards in the data stream, the response includes a pagination token named <code>NextToken</code>. You can specify
     * this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to list the next set of shards.
     * </p>
     * <p>
     * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     * <code>NextToken</code> because the latter unambiguously identifies the stream.
     * </p>
     * <p>
     * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of shards
     * that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new
     * <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the
     * <code>ListShards</code> operation.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call to
     * <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of shards in the data stream is greater than the default value for the
     *         <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
     *         is less than the number of shards in the data stream, the response includes a pagination token named
     *         <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
     *         <code>ListShards</code> to list the next set of shards.</p>
     *         <p>
     *         Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     *         <code>NextToken</code> because the latter unambiguously identifies the stream.
     *         </p>
     *         <p>
     *         You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     *         <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
     *         shards that the operation returns if you don't specify <code>MaxResults</code>, the response will contain
     *         a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call
     *         to the <code>ListShards</code> operation.
     *         </p>
     *         <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token
     *         in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID immediately
     * follows <code>ExclusiveStartShardId</code>.
     * </p>
     * <p>
     * If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the shards
     * starting with the first one in the stream.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify <code>NextToken</code>.
     * </p>
     * 
     * @return Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
     *         immediately follows <code>ExclusiveStartShardId</code>.</p>
     *         <p>
     *         If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the
     *         shards starting with the first one in the stream.
     *         </p>
     *         <p>
     *         You cannot specify this parameter if you specify <code>NextToken</code>.
     */
    public String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    /**
     * <p>
     * The maximum number of shards to return in a single call to <code>ListShards</code>. The minimum value you can
     * specify for this parameter is 1, and the maximum is 1,000, which is also the default.
     * </p>
     * <p>
     * When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
     * contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code> to list
     * the next set of shards.
     * </p>
     * 
     * @return The maximum number of shards to return in a single call to <code>ListShards</code>. The minimum value you
     *         can specify for this parameter is 1, and the maximum is 1,000, which is also the default.</p>
     *         <p>
     *         When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
     *         contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code>
     *         to list the next set of shards.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a
     * data stream and then delete it, and you later create another data stream with the same name, you can use this
     * input parameter to specify which of the two streams you want to list the shards for.
     * </p>
     * <p>
     * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     * </p>
     * 
     * @return Specify this input parameter to distinguish data streams that have the same name. For example, if you
     *         create a data stream and then delete it, and you later create another data stream with the same name, you
     *         can use this input parameter to specify which of the two streams you want to list the shards for.</p>
     *         <p>
     *         You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
     */
    public Instant streamCreationTimestamp() {
        return streamCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(streamCreationTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsRequest)) {
            return false;
        }
        ListShardsRequest other = (ListShardsRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(exclusiveStartShardId(), other.exclusiveStartShardId())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(streamCreationTimestamp(), other.streamCreationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListShardsRequest").add("StreamName", streamName()).add("NextToken", nextToken())
                .add("ExclusiveStartShardId", exclusiveStartShardId()).add("MaxResults", maxResults())
                .add("StreamCreationTimestamp", streamCreationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ExclusiveStartShardId":
            return Optional.ofNullable(clazz.cast(exclusiveStartShardId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StreamCreationTimestamp":
            return Optional.ofNullable(clazz.cast(streamCreationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShardsRequest, T> g) {
        return obj -> g.apply((ListShardsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListShardsRequest> {
        /**
         * <p>
         * The name of the data stream whose shards you want to list.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param streamName
         *        The name of the data stream whose shards you want to list. </p>
         *        <p>
         *        You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * When the number of shards in the data stream is greater than the default value for the
         * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is
         * less than the number of shards in the data stream, the response includes a pagination token named
         * <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         * <code>ListShards</code> to list the next set of shards.
         * </p>
         * <p>
         * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         * <code>NextToken</code> because the latter unambiguously identifies the stream.
         * </p>
         * <p>
         * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of shards
         * that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new
         * <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the
         * <code>ListShards</code> operation.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call
         * to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of shards in the data stream is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of shards in the data stream, the response includes a pagination token
         *        named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call
         *        to <code>ListShards</code> to list the next set of shards.</p>
         *        <p>
         *        Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         *        <code>NextToken</code> because the latter unambiguously identifies the stream.
         *        </p>
         *        <p>
         *        You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         *        <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
         *        shards that the operation returns if you don't specify <code>MaxResults</code>, the response will
         *        contain a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a
         *        subsequent call to the <code>ListShards</code> operation.
         *        </p>
         *        <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired
         *        token in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
         * immediately follows <code>ExclusiveStartShardId</code>.
         * </p>
         * <p>
         * If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the shards
         * starting with the first one in the stream.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify <code>NextToken</code>.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        Specify this parameter to indicate that you want to list the shards starting with the shard whose ID
         *        immediately follows <code>ExclusiveStartShardId</code>.</p>
         *        <p>
         *        If you don't specify this parameter, the default behavior is for <code>ListShards</code> to list the
         *        shards starting with the first one in the stream.
         *        </p>
         *        <p>
         *        You cannot specify this parameter if you specify <code>NextToken</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);

        /**
         * <p>
         * The maximum number of shards to return in a single call to <code>ListShards</code>. The minimum value you can
         * specify for this parameter is 1, and the maximum is 1,000, which is also the default.
         * </p>
         * <p>
         * When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the response
         * contains a <code>NextToken</code> value that you can use in a subsequent call to <code>ListShards</code> to
         * list the next set of shards.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of shards to return in a single call to <code>ListShards</code>. The minimum value
         *        you can specify for this parameter is 1, and the maximum is 1,000, which is also the default.</p>
         *        <p>
         *        When the number of shards to be listed is greater than the value of <code>MaxResults</code>, the
         *        response contains a <code>NextToken</code> value that you can use in a subsequent call to
         *        <code>ListShards</code> to list the next set of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify this input parameter to distinguish data streams that have the same name. For example, if you create
         * a data stream and then delete it, and you later create another data stream with the same name, you can use
         * this input parameter to specify which of the two streams you want to list the shards for.
         * </p>
         * <p>
         * You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * </p>
         * 
         * @param streamCreationTimestamp
         *        Specify this input parameter to distinguish data streams that have the same name. For example, if you
         *        create a data stream and then delete it, and you later create another data stream with the same name,
         *        you can use this input parameter to specify which of the two streams you want to list the shards
         *        for.</p>
         *        <p>
         *        You cannot specify this parameter if you specify the <code>NextToken</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreationTimestamp(Instant streamCreationTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String nextToken;

        private String exclusiveStartShardId;

        private Integer maxResults;

        private Instant streamCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsRequest model) {
            super(model);
            streamName(model.streamName);
            nextToken(model.nextToken);
            exclusiveStartShardId(model.exclusiveStartShardId);
            maxResults(model.maxResults);
            streamCreationTimestamp(model.streamCreationTimestamp);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getStreamCreationTimestamp() {
            return streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShardsRequest build() {
            return new ListShardsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
