/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>GetShardIterator</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetShardIteratorRequest extends KinesisRequest implements
        ToCopyableBuilder<GetShardIteratorRequest.Builder, GetShardIteratorRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetShardIteratorRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetShardIteratorRequest::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<String> SHARD_ITERATOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetShardIteratorRequest::shardIteratorTypeAsString)).setter(setter(Builder::shardIteratorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIteratorType").build()).build();

    private static final SdkField<String> STARTING_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetShardIteratorRequest::startingSequenceNumber)).setter(setter(Builder::startingSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingSequenceNumber").build())
            .build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetShardIteratorRequest::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            SHARD_ID_FIELD, SHARD_ITERATOR_TYPE_FIELD, STARTING_SEQUENCE_NUMBER_FIELD, TIMESTAMP_FIELD));

    private final String streamName;

    private final String shardId;

    private final String shardIteratorType;

    private final String startingSequenceNumber;

    private final Instant timestamp;

    private GetShardIteratorRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardId = builder.shardId;
        this.shardIteratorType = builder.shardIteratorType;
        this.startingSequenceNumber = builder.startingSequenceNumber;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The name of the Amazon Kinesis data stream.
     * </p>
     * 
     * @return The name of the Amazon Kinesis data stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The shard ID of the Kinesis Data Streams shard to get the iterator for.
     * </p>
     * 
     * @return The shard ID of the Kinesis Data Streams shard to get the iterator for.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * Determines how the shard iterator is used to start reading data records from the shard.
     * </p>
     * <p>
     * The following are the valid Amazon Kinesis shard iterator types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the value
     * <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number, provided in
     * the value <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
     * <code>Timestamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest data
     * record in the shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * LATEST - Start reading just after the most recent record in the shard, so that you always read the most recent
     * data in the shard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeAsString}.
     * </p>
     * 
     * @return Determines how the shard iterator is used to start reading data records from the shard.</p>
     *         <p>
     *         The following are the valid Amazon Kinesis shard iterator types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in
     *         the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
     *         provided in the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
     *         <code>Timestamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
     *         data record in the shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LATEST - Start reading just after the most recent record in the shard, so that you always read the most
     *         recent data in the shard.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public ShardIteratorType shardIteratorType() {
        return ShardIteratorType.fromValue(shardIteratorType);
    }

    /**
     * <p>
     * Determines how the shard iterator is used to start reading data records from the shard.
     * </p>
     * <p>
     * The following are the valid Amazon Kinesis shard iterator types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the value
     * <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number, provided in
     * the value <code>StartingSequenceNumber</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
     * <code>Timestamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest data
     * record in the shard.
     * </p>
     * </li>
     * <li>
     * <p>
     * LATEST - Start reading just after the most recent record in the shard, so that you always read the most recent
     * data in the shard.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shardIteratorType}
     * will return {@link ShardIteratorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #shardIteratorTypeAsString}.
     * </p>
     * 
     * @return Determines how the shard iterator is used to start reading data records from the shard.</p>
     *         <p>
     *         The following are the valid Amazon Kinesis shard iterator types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in
     *         the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
     *         provided in the value <code>StartingSequenceNumber</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
     *         <code>Timestamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
     *         data record in the shard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LATEST - Start reading just after the most recent record in the shard, so that you always read the most
     *         recent data in the shard.
     *         </p>
     *         </li>
     * @see ShardIteratorType
     */
    public String shardIteratorTypeAsString() {
        return shardIteratorType;
    }

    /**
     * <p>
     * The sequence number of the data record in the shard from which to start reading. Used with shard iterator type
     * AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
     * </p>
     * 
     * @return The sequence number of the data record in the shard from which to start reading. Used with shard iterator
     *         type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
     */
    public String startingSequenceNumber() {
        return startingSequenceNumber;
    }

    /**
     * <p>
     * The time stamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A time
     * stamp is the Unix epoch date with precision in milliseconds. For example,
     * <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp
     * does not exist, the iterator returned is for the next (later) record. If the time stamp is older than the current
     * trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
     * </p>
     * 
     * @return The time stamp of the data record from which to start reading. Used with shard iterator type
     *         AT_TIMESTAMP. A time stamp is the Unix epoch date with precision in milliseconds. For example,
     *         <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact
     *         time stamp does not exist, the iterator returned is for the next (later) record. If the time stamp is
     *         older than the current trim horizon, the iterator returned is for the oldest untrimmed data record
     *         (TRIM_HORIZON).
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(shardIteratorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startingSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetShardIteratorRequest)) {
            return false;
        }
        GetShardIteratorRequest other = (GetShardIteratorRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(shardId(), other.shardId())
                && Objects.equals(shardIteratorTypeAsString(), other.shardIteratorTypeAsString())
                && Objects.equals(startingSequenceNumber(), other.startingSequenceNumber())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetShardIteratorRequest").add("StreamName", streamName()).add("ShardId", shardId())
                .add("ShardIteratorType", shardIteratorTypeAsString()).add("StartingSequenceNumber", startingSequenceNumber())
                .add("Timestamp", timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "ShardIteratorType":
            return Optional.ofNullable(clazz.cast(shardIteratorTypeAsString()));
        case "StartingSequenceNumber":
            return Optional.ofNullable(clazz.cast(startingSequenceNumber()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetShardIteratorRequest, T> g) {
        return obj -> g.apply((GetShardIteratorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetShardIteratorRequest> {
        /**
         * <p>
         * The name of the Amazon Kinesis data stream.
         * </p>
         * 
         * @param streamName
         *        The name of the Amazon Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The shard ID of the Kinesis Data Streams shard to get the iterator for.
         * </p>
         * 
         * @param shardId
         *        The shard ID of the Kinesis Data Streams shard to get the iterator for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading data records from the shard.
         * </p>
         * <p>
         * The following are the valid Amazon Kinesis shard iterator types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the
         * value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         * provided in the value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
         * <code>Timestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
         * data record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * LATEST - Start reading just after the most recent record in the shard, so that you always read the most
         * recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading data records from the shard.</p>
         *        <p>
         *        The following are the valid Amazon Kinesis shard iterator types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided
         *        in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         *        provided in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
         *        <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LATEST - Start reading just after the most recent record in the shard, so that you always read the
         *        most recent data in the shard.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(String shardIteratorType);

        /**
         * <p>
         * Determines how the shard iterator is used to start reading data records from the shard.
         * </p>
         * <p>
         * The following are the valid Amazon Kinesis shard iterator types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided in the
         * value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         * provided in the value <code>StartingSequenceNumber</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
         * <code>Timestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the oldest
         * data record in the shard.
         * </p>
         * </li>
         * <li>
         * <p>
         * LATEST - Start reading just after the most recent record in the shard, so that you always read the most
         * recent data in the shard.
         * </p>
         * </li>
         * </ul>
         * 
         * @param shardIteratorType
         *        Determines how the shard iterator is used to start reading data records from the shard.</p>
         *        <p>
         *        The following are the valid Amazon Kinesis shard iterator types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific sequence number, provided
         *        in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a specific sequence number,
         *        provided in the value <code>StartingSequenceNumber</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        AT_TIMESTAMP - Start reading from the position denoted by a specific time stamp, provided in the value
         *        <code>Timestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TRIM_HORIZON - Start reading at the last untrimmed record in the shard in the system, which is the
         *        oldest data record in the shard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LATEST - Start reading just after the most recent record in the shard, so that you always read the
         *        most recent data in the shard.
         *        </p>
         *        </li>
         * @see ShardIteratorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShardIteratorType
         */
        Builder shardIteratorType(ShardIteratorType shardIteratorType);

        /**
         * <p>
         * The sequence number of the data record in the shard from which to start reading. Used with shard iterator
         * type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
         * </p>
         * 
         * @param startingSequenceNumber
         *        The sequence number of the data record in the shard from which to start reading. Used with shard
         *        iterator type AT_SEQUENCE_NUMBER and AFTER_SEQUENCE_NUMBER.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingSequenceNumber(String startingSequenceNumber);

        /**
         * <p>
         * The time stamp of the data record from which to start reading. Used with shard iterator type AT_TIMESTAMP. A
         * time stamp is the Unix epoch date with precision in milliseconds. For example,
         * <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time
         * stamp does not exist, the iterator returned is for the next (later) record. If the time stamp is older than
         * the current trim horizon, the iterator returned is for the oldest untrimmed data record (TRIM_HORIZON).
         * </p>
         * 
         * @param timestamp
         *        The time stamp of the data record from which to start reading. Used with shard iterator type
         *        AT_TIMESTAMP. A time stamp is the Unix epoch date with precision in milliseconds. For example,
         *        <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact
         *        time stamp does not exist, the iterator returned is for the next (later) record. If the time stamp is
         *        older than the current trim horizon, the iterator returned is for the oldest untrimmed data record
         *        (TRIM_HORIZON).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String shardId;

        private String shardIteratorType;

        private String startingSequenceNumber;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetShardIteratorRequest model) {
            super(model);
            streamName(model.streamName);
            shardId(model.shardId);
            shardIteratorType(model.shardIteratorType);
            startingSequenceNumber(model.startingSequenceNumber);
            timestamp(model.timestamp);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getShardIteratorType() {
            return shardIteratorType;
        }

        @Override
        public final Builder shardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
            return this;
        }

        @Override
        public final Builder shardIteratorType(ShardIteratorType shardIteratorType) {
            this.shardIteratorType(shardIteratorType == null ? null : shardIteratorType.toString());
            return this;
        }

        public final void setShardIteratorType(String shardIteratorType) {
            this.shardIteratorType = shardIteratorType;
        }

        public final String getStartingSequenceNumber() {
            return startingSequenceNumber;
        }

        @Override
        public final Builder startingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
            return this;
        }

        public final void setStartingSequenceNumber(String startingSequenceNumber) {
            this.startingSequenceNumber = startingSequenceNumber;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetShardIteratorRequest build() {
            return new GetShardIteratorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
