/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChildShard implements SdkPojo, Serializable, ToCopyableBuilder<ChildShard.Builder, ChildShard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ChildShard::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<List<String>> PARENT_SHARDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ChildShard::parentShards))
            .setter(setter(Builder::parentShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HashKeyRange> HASH_KEY_RANGE_FIELD = SdkField.<HashKeyRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(ChildShard::hashKeyRange)).setter(setter(Builder::hashKeyRange)).constructor(HashKeyRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashKeyRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD,
            PARENT_SHARDS_FIELD, HASH_KEY_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shardId;

    private final List<String> parentShards;

    private final HashKeyRange hashKeyRange;

    private ChildShard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShards = builder.parentShards;
        this.hashKeyRange = builder.hashKeyRange;
    }

    /**
     * Returns the value of the ShardId property for this object.
     * 
     * @return The value of the ShardId property for this object.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * Returns true if the ParentShards property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParentShards() {
        return parentShards != null && !(parentShards instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ParentShards property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParentShards()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the ParentShards property for this object.
     */
    public List<String> parentShards() {
        return parentShards;
    }

    /**
     * Returns the value of the HashKeyRange property for this object.
     * 
     * @return The value of the HashKeyRange property for this object.
     */
    public HashKeyRange hashKeyRange() {
        return hashKeyRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(parentShards());
        hashCode = 31 * hashCode + Objects.hashCode(hashKeyRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChildShard)) {
            return false;
        }
        ChildShard other = (ChildShard) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(parentShards(), other.parentShards())
                && Objects.equals(hashKeyRange(), other.hashKeyRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ChildShard").add("ShardId", shardId()).add("ParentShards", parentShards())
                .add("HashKeyRange", hashKeyRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "ParentShards":
            return Optional.ofNullable(clazz.cast(parentShards()));
        case "HashKeyRange":
            return Optional.ofNullable(clazz.cast(hashKeyRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChildShard, T> g) {
        return obj -> g.apply((ChildShard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChildShard> {
        /**
         * Sets the value of the ShardId property for this object.
         *
         * @param shardId
         *        The new value for the ShardId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * Sets the value of the ParentShards property for this object.
         *
         * @param parentShards
         *        The new value for the ParentShards property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShards(Collection<String> parentShards);

        /**
         * Sets the value of the ParentShards property for this object.
         *
         * @param parentShards
         *        The new value for the ParentShards property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShards(String... parentShards);

        /**
         * Sets the value of the HashKeyRange property for this object.
         *
         * @param hashKeyRange
         *        The new value for the HashKeyRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashKeyRange(HashKeyRange hashKeyRange);

        /**
         * Sets the value of the HashKeyRange property for this object.
         *
         * This is a convenience that creates an instance of the {@link HashKeyRange.Builder} avoiding the need to
         * create one manually via {@link HashKeyRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link HashKeyRange.Builder#build()} is called immediately and its
         * result is passed to {@link #hashKeyRange(HashKeyRange)}.
         * 
         * @param hashKeyRange
         *        a consumer that will call methods on {@link HashKeyRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hashKeyRange(HashKeyRange)
         */
        default Builder hashKeyRange(Consumer<HashKeyRange.Builder> hashKeyRange) {
            return hashKeyRange(HashKeyRange.builder().applyMutation(hashKeyRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String shardId;

        private List<String> parentShards = DefaultSdkAutoConstructList.getInstance();

        private HashKeyRange hashKeyRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ChildShard model) {
            shardId(model.shardId);
            parentShards(model.parentShards);
            hashKeyRange(model.hashKeyRange);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final Collection<String> getParentShards() {
            return parentShards;
        }

        @Override
        public final Builder parentShards(Collection<String> parentShards) {
            this.parentShards = ShardIdListCopier.copy(parentShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentShards(String... parentShards) {
            parentShards(Arrays.asList(parentShards));
            return this;
        }

        public final void setParentShards(Collection<String> parentShards) {
            this.parentShards = ShardIdListCopier.copy(parentShards);
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return hashKeyRange != null ? hashKeyRange.toBuilder() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        @Override
        public ChildShard build() {
            return new ChildShard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
