/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * After you call <a>SubscribeToShard</a>, Kinesis Data Streams sends events of this type over an HTTP/2 connection to
 * your consumer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubscribeToShardEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<SubscribeToShardEvent.Builder, SubscribeToShardEvent>, SubscribeToShardEventStream {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(SubscribeToShardEvent::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTINUATION_SEQUENCE_NUMBER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContinuationSequenceNumber")
            .getter(getter(SubscribeToShardEvent::continuationSequenceNumber))
            .setter(setter(Builder::continuationSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationSequenceNumber").build())
            .build();

    private static final SdkField<Long> MILLIS_BEHIND_LATEST_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MillisBehindLatest").getter(getter(SubscribeToShardEvent::millisBehindLatest))
            .setter(setter(Builder::millisBehindLatest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MillisBehindLatest").build())
            .build();

    private static final SdkField<List<ChildShard>> CHILD_SHARDS_FIELD = SdkField
            .<List<ChildShard>> builder(MarshallingType.LIST)
            .memberName("ChildShards")
            .getter(getter(SubscribeToShardEvent::childShards))
            .setter(setter(Builder::childShards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildShards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChildShard> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChildShard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            CONTINUATION_SEQUENCE_NUMBER_FIELD, MILLIS_BEHIND_LATEST_FIELD, CHILD_SHARDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Record> records;

    private final String continuationSequenceNumber;

    private final Long millisBehindLatest;

    private final List<ChildShard> childShards;

    private SubscribeToShardEvent(BuilderImpl builder) {
        this.records = builder.records;
        this.continuationSequenceNumber = builder.continuationSequenceNumber;
        this.millisBehindLatest = builder.millisBehindLatest;
        this.childShards = builder.childShards;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public List<Record> records() {
        return records;
    }

    /**
     * <p>
     * Use this as <code>SequenceNumber</code> in the next call to <a>SubscribeToShard</a>, with
     * <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>. Use
     * <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even when no
     * data is written to the shard.
     * </p>
     * 
     * @return Use this as <code>SequenceNumber</code> in the next call to <a>SubscribeToShard</a>, with
     *         <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or
     *         <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing because
     *         it captures your shard progress even when no data is written to the shard.
     */
    public String continuationSequenceNumber() {
        return continuationSequenceNumber;
    }

    /**
     * <p>
     * The number of milliseconds the read records are from the tip of the stream, indicating how far behind current
     * time the consumer is. A value of zero indicates that record processing is caught up, and there are no new records
     * to process at this moment.
     * </p>
     * 
     * @return The number of milliseconds the read records are from the tip of the stream, indicating how far behind
     *         current time the consumer is. A value of zero indicates that record processing is caught up, and there
     *         are no new records to process at this moment.
     */
    public Long millisBehindLatest() {
        return millisBehindLatest;
    }

    /**
     * Returns true if the ChildShards property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasChildShards() {
        return childShards != null && !(childShards instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the ChildShards property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasChildShards()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value of the ChildShards property for this object.
     */
    public List<ChildShard> childShards() {
        return childShards;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(continuationSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(millisBehindLatest());
        hashCode = 31 * hashCode + Objects.hashCode(childShards());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeToShardEvent)) {
            return false;
        }
        SubscribeToShardEvent other = (SubscribeToShardEvent) obj;
        return Objects.equals(records(), other.records())
                && Objects.equals(continuationSequenceNumber(), other.continuationSequenceNumber())
                && Objects.equals(millisBehindLatest(), other.millisBehindLatest())
                && Objects.equals(childShards(), other.childShards());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SubscribeToShardEvent").add("Records", records())
                .add("ContinuationSequenceNumber", continuationSequenceNumber()).add("MillisBehindLatest", millisBehindLatest())
                .add("ChildShards", childShards()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "ContinuationSequenceNumber":
            return Optional.ofNullable(clazz.cast(continuationSequenceNumber()));
        case "MillisBehindLatest":
            return Optional.ofNullable(clazz.cast(millisBehindLatest()));
        case "ChildShards":
            return Optional.ofNullable(clazz.cast(childShards()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribeToShardEvent, T> g) {
        return obj -> g.apply((SubscribeToShardEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link SubscribeToShardEvent}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(SubscribeToShardResponseHandler.Visitor visitor) {
        visitor.visit(this);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubscribeToShardEvent> {
        /**
         * <p/>
         * 
         * @param records
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p/>
         * 
         * @param records
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<Record>.Builder} avoiding the need to
         * create one manually via {@link List<Record>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Record>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<Record>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * <p>
         * Use this as <code>SequenceNumber</code> in the next call to <a>SubscribeToShard</a>, with
         * <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.
         * Use <code>ContinuationSequenceNumber</code> for checkpointing because it captures your shard progress even
         * when no data is written to the shard.
         * </p>
         * 
         * @param continuationSequenceNumber
         *        Use this as <code>SequenceNumber</code> in the next call to <a>SubscribeToShard</a>, with
         *        <code>StartingPosition</code> set to <code>AT_SEQUENCE_NUMBER</code> or
         *        <code>AFTER_SEQUENCE_NUMBER</code>. Use <code>ContinuationSequenceNumber</code> for checkpointing
         *        because it captures your shard progress even when no data is written to the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationSequenceNumber(String continuationSequenceNumber);

        /**
         * <p>
         * The number of milliseconds the read records are from the tip of the stream, indicating how far behind current
         * time the consumer is. A value of zero indicates that record processing is caught up, and there are no new
         * records to process at this moment.
         * </p>
         * 
         * @param millisBehindLatest
         *        The number of milliseconds the read records are from the tip of the stream, indicating how far behind
         *        current time the consumer is. A value of zero indicates that record processing is caught up, and there
         *        are no new records to process at this moment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder millisBehindLatest(Long millisBehindLatest);

        /**
         * Sets the value of the ChildShards property for this object.
         *
         * @param childShards
         *        The new value for the ChildShards property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childShards(Collection<ChildShard> childShards);

        /**
         * Sets the value of the ChildShards property for this object.
         *
         * @param childShards
         *        The new value for the ChildShards property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder childShards(ChildShard... childShards);

        /**
         * Sets the value of the ChildShards property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<ChildShard>.Builder} avoiding the need to
         * create one manually via {@link List<ChildShard>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ChildShard>.Builder#build()} is called immediately and its
         * result is passed to {@link #childShards(List<ChildShard>)}.
         * 
         * @param childShards
         *        a consumer that will call methods on {@link List<ChildShard>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #childShards(List<ChildShard>)
         */
        Builder childShards(Consumer<ChildShard.Builder>... childShards);
    }

    static final class BuilderImpl implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private String continuationSequenceNumber;

        private Long millisBehindLatest;

        private List<ChildShard> childShards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribeToShardEvent model) {
            records(model.records);
            continuationSequenceNumber(model.continuationSequenceNumber);
            millisBehindLatest(model.millisBehindLatest);
            childShards(model.childShards);
        }

        public final Collection<Record.Builder> getRecords() {
            return records != null ? records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getContinuationSequenceNumber() {
            return continuationSequenceNumber;
        }

        @Override
        public final Builder continuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
            return this;
        }

        public final void setContinuationSequenceNumber(String continuationSequenceNumber) {
            this.continuationSequenceNumber = continuationSequenceNumber;
        }

        public final Long getMillisBehindLatest() {
            return millisBehindLatest;
        }

        @Override
        public final Builder millisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
            return this;
        }

        public final void setMillisBehindLatest(Long millisBehindLatest) {
            this.millisBehindLatest = millisBehindLatest;
        }

        public final Collection<ChildShard.Builder> getChildShards() {
            return childShards != null ? childShards.stream().map(ChildShard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder childShards(Collection<ChildShard> childShards) {
            this.childShards = ChildShardListCopier.copy(childShards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(ChildShard... childShards) {
            childShards(Arrays.asList(childShards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder childShards(Consumer<ChildShard.Builder>... childShards) {
            childShards(Stream.of(childShards).map(c -> ChildShard.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setChildShards(Collection<ChildShard.BuilderImpl> childShards) {
            this.childShards = ChildShardListCopier.copyFromBuilder(childShards);
        }

        @Override
        public SubscribeToShardEvent build() {
            return new SubscribeToShardEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
