/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateShardCountResponse extends KinesisResponse implements
        ToCopyableBuilder<UpdateShardCountResponse.Builder, UpdateShardCountResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateShardCountResponse::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<Integer> CURRENT_SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentShardCount").getter(getter(UpdateShardCountResponse::currentShardCount))
            .setter(setter(Builder::currentShardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentShardCount").build()).build();

    private static final SdkField<Integer> TARGET_SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetShardCount").getter(getter(UpdateShardCountResponse::targetShardCount))
            .setter(setter(Builder::targetShardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetShardCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            CURRENT_SHARD_COUNT_FIELD, TARGET_SHARD_COUNT_FIELD));

    private final String streamName;

    private final Integer currentShardCount;

    private final Integer targetShardCount;

    private UpdateShardCountResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.currentShardCount = builder.currentShardCount;
        this.targetShardCount = builder.targetShardCount;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The current number of shards.
     * </p>
     * 
     * @return The current number of shards.
     */
    public final Integer currentShardCount() {
        return currentShardCount;
    }

    /**
     * <p>
     * The updated number of shards.
     * </p>
     * 
     * @return The updated number of shards.
     */
    public final Integer targetShardCount() {
        return targetShardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(currentShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(targetShardCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountResponse)) {
            return false;
        }
        UpdateShardCountResponse other = (UpdateShardCountResponse) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(currentShardCount(), other.currentShardCount())
                && Objects.equals(targetShardCount(), other.targetShardCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateShardCountResponse").add("StreamName", streamName())
                .add("CurrentShardCount", currentShardCount()).add("TargetShardCount", targetShardCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "CurrentShardCount":
            return Optional.ofNullable(clazz.cast(currentShardCount()));
        case "TargetShardCount":
            return Optional.ofNullable(clazz.cast(targetShardCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateShardCountResponse, T> g) {
        return obj -> g.apply((UpdateShardCountResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateShardCountResponse> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The current number of shards.
         * </p>
         * 
         * @param currentShardCount
         *        The current number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentShardCount(Integer currentShardCount);

        /**
         * <p>
         * The updated number of shards.
         * </p>
         * 
         * @param targetShardCount
         *        The updated number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetShardCount(Integer targetShardCount);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String streamName;

        private Integer currentShardCount;

        private Integer targetShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountResponse model) {
            super(model);
            streamName(model.streamName);
            currentShardCount(model.currentShardCount);
            targetShardCount(model.targetShardCount);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getCurrentShardCount() {
            return currentShardCount;
        }

        @Override
        public final Builder currentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
            return this;
        }

        public final void setCurrentShardCount(Integer currentShardCount) {
            this.currentShardCount = currentShardCount;
        }

        public final Integer getTargetShardCount() {
            return targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        @Override
        public UpdateShardCountResponse build() {
            return new UpdateShardCountResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
