/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>PutRecords</code> results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordsResponse extends KinesisResponse implements
        ToCopyableBuilder<PutRecordsResponse.Builder, PutRecordsResponse> {
    private static final SdkField<Integer> FAILED_RECORD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedRecordCount").getter(getter(PutRecordsResponse::failedRecordCount))
            .setter(setter(Builder::failedRecordCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecordCount").build()).build();

    private static final SdkField<List<PutRecordsResultEntry>> RECORDS_FIELD = SdkField
            .<List<PutRecordsResultEntry>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(PutRecordsResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PutRecordsResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PutRecordsResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(PutRecordsResponse::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_RECORD_COUNT_FIELD,
            RECORDS_FIELD, ENCRYPTION_TYPE_FIELD));

    private final Integer failedRecordCount;

    private final List<PutRecordsResultEntry> records;

    private final String encryptionType;

    private PutRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.failedRecordCount = builder.failedRecordCount;
        this.records = builder.records;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The number of unsuccessfully processed records in a <code>PutRecords</code> request.
     * </p>
     * 
     * @return The number of unsuccessfully processed records in a <code>PutRecords</code> request.
     */
    public final Integer failedRecordCount() {
        return failedRecordCount;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
     * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
     * <code>ShardId</code> in the result. A record that fails to be added to a stream includes <code>ErrorCode</code>
     * and <code>ErrorMessage</code> in the result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of successfully and unsuccessfully processed record results, correlated with the request by
     *         natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
     *         and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
     *         <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
     */
    public final List<PutRecordsResultEntry> records() {
        return records;
    }

    /**
     * <p>
     * The encryption type used on the records. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type used on the records. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type used on the records. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type used on the records. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(failedRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordsResponse)) {
            return false;
        }
        PutRecordsResponse other = (PutRecordsResponse) obj;
        return Objects.equals(failedRecordCount(), other.failedRecordCount()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordsResponse").add("FailedRecordCount", failedRecordCount())
                .add("Records", hasRecords() ? records() : null).add("EncryptionType", encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedRecordCount":
            return Optional.ofNullable(clazz.cast(failedRecordCount()));
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutRecordsResponse, T> g) {
        return obj -> g.apply((PutRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRecordsResponse> {
        /**
         * <p>
         * The number of unsuccessfully processed records in a <code>PutRecords</code> request.
         * </p>
         * 
         * @param failedRecordCount
         *        The number of unsuccessfully processed records in a <code>PutRecords</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecordCount(Integer failedRecordCount);

        /**
         * <p>
         * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
         * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
         * <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         * <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * </p>
         * 
         * @param records
         *        An array of successfully and unsuccessfully processed record results, correlated with the request by
         *        natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
         *        and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         *        <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<PutRecordsResultEntry> records);

        /**
         * <p>
         * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
         * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
         * <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         * <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * </p>
         * 
         * @param records
         *        An array of successfully and unsuccessfully processed record results, correlated with the request by
         *        natural ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code>
         *        and <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         *        <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(PutRecordsResultEntry... records);

        /**
         * <p>
         * An array of successfully and unsuccessfully processed record results, correlated with the request by natural
         * ordering. A record that is successfully added to a stream includes <code>SequenceNumber</code> and
         * <code>ShardId</code> in the result. A record that fails to be added to a stream includes
         * <code>ErrorCode</code> and <code>ErrorMessage</code> in the result.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PutRecordsResultEntry>.Builder} avoiding
         * the need to create one manually via {@link List<PutRecordsResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PutRecordsResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #records(List<PutRecordsResultEntry>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<PutRecordsResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<PutRecordsResultEntry>)
         */
        Builder records(Consumer<PutRecordsResultEntry.Builder>... records);

        /**
         * <p>
         * The encryption type used on the records. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type used on the records. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type used on the records. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type used on the records. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records using a customer-managed AWS KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private Integer failedRecordCount;

        private List<PutRecordsResultEntry> records = DefaultSdkAutoConstructList.getInstance();

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordsResponse model) {
            super(model);
            failedRecordCount(model.failedRecordCount);
            records(model.records);
            encryptionType(model.encryptionType);
        }

        public final Integer getFailedRecordCount() {
            return failedRecordCount;
        }

        @Override
        public final Builder failedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
            return this;
        }

        public final void setFailedRecordCount(Integer failedRecordCount) {
            this.failedRecordCount = failedRecordCount;
        }

        public final Collection<PutRecordsResultEntry.Builder> getRecords() {
            if (records instanceof SdkAutoConstructList) {
                return null;
            }
            return records != null ? records.stream().map(PutRecordsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<PutRecordsResultEntry> records) {
            this.records = PutRecordsResultEntryListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(PutRecordsResultEntry... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<PutRecordsResultEntry.Builder>... records) {
            records(Stream.of(records).map(c -> PutRecordsResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<PutRecordsResultEntry.BuilderImpl> records) {
            this.records = PutRecordsResultEntryListCopier.copyFromBuilder(records);
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public PutRecordsResponse build() {
            return new PutRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
