/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>ListTagsForStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForStreamResponse extends KinesisResponse implements
        ToCopyableBuilder<ListTagsForStreamResponse.Builder, ListTagsForStreamResponse> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ListTagsForStreamResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_MORE_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasMoreTags").getter(getter(ListTagsForStreamResponse::hasMoreTags))
            .setter(setter(Builder::hasMoreTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreTags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD,
            HAS_MORE_TAGS_FIELD));

    private final List<Tag> tags;

    private final Boolean hasMoreTags;

    private ListTagsForStreamResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.hasMoreTags = builder.hasMoreTags;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with <code>StreamName</code>, starting with the first tag after
     * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with <code>StreamName</code>, starting with the first tag after
     *         <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * If set to <code>true</code>, more tags are available. To request additional tags, set
     * <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
     * </p>
     * 
     * @return If set to <code>true</code>, more tags are available. To request additional tags, set
     *         <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
     */
    public final Boolean hasMoreTags() {
        return hasMoreTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamResponse)) {
            return false;
        }
        ListTagsForStreamResponse other = (ListTagsForStreamResponse) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(hasMoreTags(), other.hasMoreTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForStreamResponse").add("Tags", hasTags() ? tags() : null)
                .add("HasMoreTags", hasMoreTags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "HasMoreTags":
            return Optional.ofNullable(clazz.cast(hasMoreTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForStreamResponse, T> g) {
        return obj -> g.apply((ListTagsForStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForStreamResponse> {
        /**
         * <p>
         * A list of tags associated with <code>StreamName</code>, starting with the first tag after
         * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with <code>StreamName</code>, starting with the first tag after
         *        <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with <code>StreamName</code>, starting with the first tag after
         * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with <code>StreamName</code>, starting with the first tag after
         *        <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with <code>StreamName</code>, starting with the first tag after
         * <code>ExclusiveStartTagKey</code> and up to the specified <code>Limit</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * If set to <code>true</code>, more tags are available. To request additional tags, set
         * <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
         * </p>
         * 
         * @param hasMoreTags
         *        If set to <code>true</code>, more tags are available. To request additional tags, set
         *        <code>ExclusiveStartTagKey</code> to the key of the last tag returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreTags(Boolean hasMoreTags);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasMoreTags;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamResponse model) {
            super(model);
            tags(model.tags);
            hasMoreTags(model.hasMoreTags);
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getHasMoreTags() {
            return hasMoreTags;
        }

        @Override
        public final Builder hasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
            return this;
        }

        public final void setHasMoreTags(Boolean hasMoreTags) {
            this.hasMoreTags = hasMoreTags;
        }

        @Override
        public ListTagsForStreamResponse build() {
            return new ListTagsForStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
