/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>ListTagsForStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForStreamRequest extends KinesisRequest implements
        ToCopyableBuilder<ListTagsForStreamRequest.Builder, ListTagsForStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(ListTagsForStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartTagKey").getter(getter(ListTagsForStreamRequest::exclusiveStartTagKey))
            .setter(setter(Builder::exclusiveStartTagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartTagKey").build())
            .build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(ListTagsForStreamRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            EXCLUSIVE_START_TAG_KEY_FIELD, LIMIT_FIELD));

    private final String streamName;

    private final String exclusiveStartTagKey;

    private final Integer limit;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.exclusiveStartTagKey = builder.exclusiveStartTagKey;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The key to use as the starting point for the list of tags. If this parameter is set,
     * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     * </p>
     * 
     * @return The key to use as the starting point for the list of tags. If this parameter is set,
     *         <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
     */
    public final String exclusiveStartTagKey() {
        return exclusiveStartTagKey;
    }

    /**
     * <p>
     * The number of tags to return. If this number is less than the total number of tags associated with the stream,
     * <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     * <code>ExclusiveStartTagKey</code> to the last key in the response.
     * </p>
     * 
     * @return The number of tags to return. If this number is less than the total number of tags associated with the
     *         stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
     *         <code>ExclusiveStartTagKey</code> to the last key in the response.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartTagKey());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName())
                && Objects.equals(exclusiveStartTagKey(), other.exclusiveStartTagKey()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForStreamRequest").add("StreamName", streamName())
                .add("ExclusiveStartTagKey", exclusiveStartTagKey()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ExclusiveStartTagKey":
            return Optional.ofNullable(clazz.cast(exclusiveStartTagKey()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForStreamRequest, T> g) {
        return obj -> g.apply((ListTagsForStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForStreamRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The key to use as the starting point for the list of tags. If this parameter is set,
         * <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * </p>
         * 
         * @param exclusiveStartTagKey
         *        The key to use as the starting point for the list of tags. If this parameter is set,
         *        <code>ListTagsForStream</code> gets all tags that occur after <code>ExclusiveStartTagKey</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartTagKey(String exclusiveStartTagKey);

        /**
         * <p>
         * The number of tags to return. If this number is less than the total number of tags associated with the
         * stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         * <code>ExclusiveStartTagKey</code> to the last key in the response.
         * </p>
         * 
         * @param limit
         *        The number of tags to return. If this number is less than the total number of tags associated with the
         *        stream, <code>HasMoreTags</code> is set to <code>true</code>. To list additional tags, set
         *        <code>ExclusiveStartTagKey</code> to the last key in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private String exclusiveStartTagKey;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            super(model);
            streamName(model.streamName);
            exclusiveStartTagKey(model.exclusiveStartTagKey);
            limit(model.limit);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getExclusiveStartTagKey() {
            return exclusiveStartTagKey;
        }

        public final void setExclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
        }

        @Override
        @Transient
        public final Builder exclusiveStartTagKey(String exclusiveStartTagKey) {
            this.exclusiveStartTagKey = exclusiveStartTagKey;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
