/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HashKeyRange implements SdkPojo, Serializable, ToCopyableBuilder<HashKeyRange.Builder, HashKeyRange> {
    private static final SdkField<String> STARTING_HASH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartingHashKey").getter(getter(HashKeyRange::startingHashKey)).setter(setter(Builder::startingHashKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingHashKey").build()).build();

    private static final SdkField<String> ENDING_HASH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndingHashKey").getter(getter(HashKeyRange::endingHashKey)).setter(setter(Builder::endingHashKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndingHashKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTING_HASH_KEY_FIELD,
            ENDING_HASH_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startingHashKey;

    private final String endingHashKey;

    private HashKeyRange(BuilderImpl builder) {
        this.startingHashKey = builder.startingHashKey;
        this.endingHashKey = builder.endingHashKey;
    }

    /**
     * <p>
     * The starting hash key of the hash key range.
     * </p>
     * 
     * @return The starting hash key of the hash key range.
     */
    public final String startingHashKey() {
        return startingHashKey;
    }

    /**
     * <p>
     * The ending hash key of the hash key range.
     * </p>
     * 
     * @return The ending hash key of the hash key range.
     */
    public final String endingHashKey() {
        return endingHashKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startingHashKey());
        hashCode = 31 * hashCode + Objects.hashCode(endingHashKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HashKeyRange)) {
            return false;
        }
        HashKeyRange other = (HashKeyRange) obj;
        return Objects.equals(startingHashKey(), other.startingHashKey())
                && Objects.equals(endingHashKey(), other.endingHashKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HashKeyRange").add("StartingHashKey", startingHashKey()).add("EndingHashKey", endingHashKey())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartingHashKey":
            return Optional.ofNullable(clazz.cast(startingHashKey()));
        case "EndingHashKey":
            return Optional.ofNullable(clazz.cast(endingHashKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HashKeyRange, T> g) {
        return obj -> g.apply((HashKeyRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HashKeyRange> {
        /**
         * <p>
         * The starting hash key of the hash key range.
         * </p>
         * 
         * @param startingHashKey
         *        The starting hash key of the hash key range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingHashKey(String startingHashKey);

        /**
         * <p>
         * The ending hash key of the hash key range.
         * </p>
         * 
         * @param endingHashKey
         *        The ending hash key of the hash key range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endingHashKey(String endingHashKey);
    }

    static final class BuilderImpl implements Builder {
        private String startingHashKey;

        private String endingHashKey;

        private BuilderImpl() {
        }

        private BuilderImpl(HashKeyRange model) {
            startingHashKey(model.startingHashKey);
            endingHashKey(model.endingHashKey);
        }

        public final String getStartingHashKey() {
            return startingHashKey;
        }

        public final void setStartingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
        }

        @Override
        @Transient
        public final Builder startingHashKey(String startingHashKey) {
            this.startingHashKey = startingHashKey;
            return this;
        }

        public final String getEndingHashKey() {
            return endingHashKey;
        }

        public final void setEndingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
        }

        @Override
        @Transient
        public final Builder endingHashKey(String endingHashKey) {
            this.endingHashKey = endingHashKey;
            return this;
        }

        @Override
        public HashKeyRange build() {
            return new HashKeyRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
