/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterStreamConsumerRequest extends KinesisRequest implements
        ToCopyableBuilder<RegisterStreamConsumerRequest.Builder, RegisterStreamConsumerRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(RegisterStreamConsumerRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerName").getter(getter(RegisterStreamConsumerRequest::consumerName))
            .setter(setter(Builder::consumerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            CONSUMER_NAME_FIELD));

    private final String streamARN;

    private final String consumerName;

    private RegisterStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
    }

    /**
     * <p>
     * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
     *         href
     *         ="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to be
     * unique across data streams.
     * </p>
     * 
     * @return For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't
     *         have to be unique across data streams.
     */
    public final String consumerName() {
        return consumerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(consumerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterStreamConsumerRequest)) {
            return false;
        }
        RegisterStreamConsumerRequest other = (RegisterStreamConsumerRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(consumerName(), other.consumerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterStreamConsumerRequest").add("StreamARN", streamARN())
                .add("ConsumerName", consumerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ConsumerName":
            return Optional.ofNullable(clazz.cast(consumerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterStreamConsumerRequest, T> g) {
        return obj -> g.apply((RegisterStreamConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterStreamConsumerRequest> {
        /**
         * <p>
         * The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the Kinesis data stream that you want to register the consumer with. For more info, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't have to
         * be unique across data streams.
         * </p>
         * 
         * @param consumerName
         *        For a given Kinesis data stream, each consumer must have a unique name. However, consumer names don't
         *        have to be unique across data streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerName(String consumerName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String consumerName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterStreamConsumerRequest model) {
            super(model);
            streamARN(model.streamARN);
            consumerName(model.consumerName);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        @Transient
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getConsumerName() {
            return consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        @Transient
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterStreamConsumerRequest build() {
            return new RegisterStreamConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
