/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamConsumersResponse extends KinesisResponse implements
        ToCopyableBuilder<ListStreamConsumersResponse.Builder, ListStreamConsumersResponse> {
    private static final SdkField<List<Consumer>> CONSUMERS_FIELD = SdkField
            .<List<Consumer>> builder(MarshallingType.LIST)
            .memberName("Consumers")
            .getter(getter(ListStreamConsumersResponse::consumers))
            .setter(setter(Builder::consumers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consumers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Consumer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Consumer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamConsumersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Consumer> consumers;

    private final String nextToken;

    private ListStreamConsumersResponse(BuilderImpl builder) {
        super(builder);
        this.consumers = builder.consumers;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Consumers property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasConsumers() {
        return consumers != null && !(consumers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of JSON objects. Each object represents one registered consumer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConsumers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of JSON objects. Each object represents one registered consumer.
     */
    public final List<Consumer> consumers() {
        return consumers;
    }

    /**
     * <p>
     * When the number of consumers that are registered with the data stream is greater than the default value for the
     * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less
     * than the number of registered consumers, the response includes a pagination token named <code>NextToken</code>.
     * You can specify this <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to
     * list the next set of registered consumers. For more information about the use of this pagination token when
     * calling the <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token in a
     * call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of consumers that are registered with the data stream is greater than the default value
     *         for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
     *         <code>MaxResults</code> that is less than the number of registered consumers, the response includes a
     *         pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
     *         subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers. For
     *         more information about the use of this pagination token when calling the <code>ListStreamConsumers</code>
     *         operation, see <a>ListStreamConsumersInput$NextToken</a>.</p> <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
     *         expired token in a call to <code>ListStreamConsumers</code>, you get
     *         <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConsumers() ? consumers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamConsumersResponse)) {
            return false;
        }
        ListStreamConsumersResponse other = (ListStreamConsumersResponse) obj;
        return hasConsumers() == other.hasConsumers() && Objects.equals(consumers(), other.consumers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamConsumersResponse").add("Consumers", hasConsumers() ? consumers() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Consumers":
            return Optional.ofNullable(clazz.cast(consumers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamConsumersResponse, T> g) {
        return obj -> g.apply((ListStreamConsumersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamConsumersResponse> {
        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * 
         * @param consumers
         *        An array of JSON objects. Each object represents one registered consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumers(Collection<Consumer> consumers);

        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * 
         * @param consumers
         *        An array of JSON objects. Each object represents one registered consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumers(Consumer... consumers);

        /**
         * <p>
         * An array of JSON objects. Each object represents one registered consumer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Consumer>.Builder} avoiding the need to
         * create one manually via {@link List<Consumer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Consumer>.Builder#build()} is called immediately and its
         * result is passed to {@link #consumers(List<Consumer>)}.
         * 
         * @param consumers
         *        a consumer that will call methods on {@link List<Consumer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumers(List<Consumer>)
         */
        Builder consumers(java.util.function.Consumer<Consumer.Builder>... consumers);

        /**
         * <p>
         * When the number of consumers that are registered with the data stream is greater than the default value for
         * the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
         * is less than the number of registered consumers, the response includes a pagination token named
         * <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         * <code>ListStreamConsumers</code> to list the next set of registered consumers. For more information about the
         * use of this pagination token when calling the <code>ListStreamConsumers</code> operation, see
         * <a>ListStreamConsumersInput$NextToken</a>.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token
         * in a call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of consumers that are registered with the data stream is greater than the default
         *        value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
         *        <code>MaxResults</code> that is less than the number of registered consumers, the response includes a
         *        pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
         *        subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers. For
         *        more information about the use of this pagination token when calling the
         *        <code>ListStreamConsumers</code> operation, see <a>ListStreamConsumersInput$NextToken</a>.</p>
         *        <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
         *        expired token in a call to <code>ListStreamConsumers</code>, you get
         *        <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<Consumer> consumers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamConsumersResponse model) {
            super(model);
            consumers(model.consumers);
            nextToken(model.nextToken);
        }

        public final List<Consumer.Builder> getConsumers() {
            List<Consumer.Builder> result = ConsumerListCopier.copyToBuilder(this.consumers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConsumers(Collection<Consumer.BuilderImpl> consumers) {
            this.consumers = ConsumerListCopier.copyFromBuilder(consumers);
        }

        @Override
        @Transient
        public final Builder consumers(Collection<Consumer> consumers) {
            this.consumers = ConsumerListCopier.copy(consumers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumers(Consumer... consumers) {
            consumers(Arrays.asList(consumers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder consumers(java.util.function.Consumer<Consumer.Builder>... consumers) {
            consumers(Stream.of(consumers).map(c -> Consumer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamConsumersResponse build() {
            return new ListStreamConsumersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
