/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeregisterStreamConsumerRequest extends KinesisRequest implements
        ToCopyableBuilder<DeregisterStreamConsumerRequest.Builder, DeregisterStreamConsumerRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(DeregisterStreamConsumerRequest::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CONSUMER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerName").getter(getter(DeregisterStreamConsumerRequest::consumerName))
            .setter(setter(Builder::consumerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerName").build()).build();

    private static final SdkField<String> CONSUMER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConsumerARN").getter(getter(DeregisterStreamConsumerRequest::consumerARN))
            .setter(setter(Builder::consumerARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            CONSUMER_NAME_FIELD, CONSUMER_ARN_FIELD));

    private final String streamARN;

    private final String consumerName;

    private final String consumerARN;

    private DeregisterStreamConsumerRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.consumerName = builder.consumerName;
        this.consumerARN = builder.consumerARN;
    }

    /**
     * <p>
     * The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name that you gave to the consumer.
     * </p>
     * 
     * @return The name that you gave to the consumer.
     */
    public final String consumerName() {
        return consumerName;
    }

    /**
     * <p>
     * The ARN returned by Kinesis Data Streams when you registered the consumer. If you don't know the ARN of the
     * consumer that you want to deregister, you can use the ListStreamConsumers operation to get a list of the
     * descriptions of all the consumers that are currently registered with a given data stream. The description of a
     * consumer contains its ARN.
     * </p>
     * 
     * @return The ARN returned by Kinesis Data Streams when you registered the consumer. If you don't know the ARN of
     *         the consumer that you want to deregister, you can use the ListStreamConsumers operation to get a list of
     *         the descriptions of all the consumers that are currently registered with a given data stream. The
     *         description of a consumer contains its ARN.
     */
    public final String consumerARN() {
        return consumerARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(consumerName());
        hashCode = 31 * hashCode + Objects.hashCode(consumerARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterStreamConsumerRequest)) {
            return false;
        }
        DeregisterStreamConsumerRequest other = (DeregisterStreamConsumerRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(consumerName(), other.consumerName())
                && Objects.equals(consumerARN(), other.consumerARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeregisterStreamConsumerRequest").add("StreamARN", streamARN())
                .add("ConsumerName", consumerName()).add("ConsumerARN", consumerARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ConsumerName":
            return Optional.ofNullable(clazz.cast(consumerName()));
        case "ConsumerARN":
            return Optional.ofNullable(clazz.cast(consumerARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeregisterStreamConsumerRequest, T> g) {
        return obj -> g.apply((DeregisterStreamConsumerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeregisterStreamConsumerRequest> {
        /**
         * <p>
         * The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the Kinesis data stream that the consumer is registered with. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name that you gave to the consumer.
         * </p>
         * 
         * @param consumerName
         *        The name that you gave to the consumer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerName(String consumerName);

        /**
         * <p>
         * The ARN returned by Kinesis Data Streams when you registered the consumer. If you don't know the ARN of the
         * consumer that you want to deregister, you can use the ListStreamConsumers operation to get a list of the
         * descriptions of all the consumers that are currently registered with a given data stream. The description of
         * a consumer contains its ARN.
         * </p>
         * 
         * @param consumerARN
         *        The ARN returned by Kinesis Data Streams when you registered the consumer. If you don't know the ARN
         *        of the consumer that you want to deregister, you can use the ListStreamConsumers operation to get a
         *        list of the descriptions of all the consumers that are currently registered with a given data stream.
         *        The description of a consumer contains its ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumerARN(String consumerARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String consumerName;

        private String consumerARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterStreamConsumerRequest model) {
            super(model);
            streamARN(model.streamARN);
            consumerName(model.consumerName);
            consumerARN(model.consumerARN);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getConsumerName() {
            return consumerName;
        }

        public final void setConsumerName(String consumerName) {
            this.consumerName = consumerName;
        }

        @Override
        public final Builder consumerName(String consumerName) {
            this.consumerName = consumerName;
            return this;
        }

        public final String getConsumerARN() {
            return consumerARN;
        }

        public final void setConsumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
        }

        @Override
        public final Builder consumerARN(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeregisterStreamConsumerRequest build() {
            return new DeregisterStreamConsumerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
