/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamConsumersRequest extends KinesisRequest implements
        ToCopyableBuilder<ListStreamConsumersRequest.Builder, ListStreamConsumersRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(ListStreamConsumersRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamConsumersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStreamConsumersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StreamCreationTimestamp").getter(getter(ListStreamConsumersRequest::streamCreationTimestamp))
            .setter(setter(Builder::streamCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD));

    private final String streamARN;

    private final String nextToken;

    private final Integer maxResults;

    private final Instant streamCreationTimestamp;

    private ListStreamConsumersRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
    }

    /**
     * <p>
     * The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">
     * Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     * </p>
     * 
     * @return The ARN of the Kinesis data stream for which you want to list the registered consumers. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * When the number of consumers that are registered with the data stream is greater than the default value for the
     * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less
     * than the number of consumers that are registered with the data stream, the response includes a pagination token
     * named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
     * <code>ListStreamConsumers</code> to list the next set of registered consumers.
     * </p>
     * <p>
     * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     * <code>NextToken</code> because the latter unambiguously identifies the stream.
     * </p>
     * <p>
     * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of consumers
     * that the operation returns if you don't specify <code>MaxResults</code>, the response will contain a new
     * <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to the
     * <code>ListStreamConsumers</code> operation to list the next set of consumers.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token in a
     * call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of consumers that are registered with the data stream is greater than the default value
     *         for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
     *         <code>MaxResults</code> that is less than the number of consumers that are registered with the data
     *         stream, the response includes a pagination token named <code>NextToken</code>. You can specify this
     *         <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to list the next
     *         set of registered consumers.</p>
     *         <p>
     *         Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
     *         <code>NextToken</code> because the latter unambiguously identifies the stream.
     *         </p>
     *         <p>
     *         You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
     *         <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
     *         consumers that the operation returns if you don't specify <code>MaxResults</code>, the response will
     *         contain a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a
     *         subsequent call to the <code>ListStreamConsumers</code> operation to list the next set of consumers.
     *         </p>
     *         <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
     *         expired token in a call to <code>ListStreamConsumers</code>, you get
     *         <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of consumers that you want a single call of <code>ListStreamConsumers</code> to return. The
     * default value is 100. If you specify a value greater than 100, at most 100 results are returned.
     * </p>
     * 
     * @return The maximum number of consumers that you want a single call of <code>ListStreamConsumers</code> to
     *         return. The default value is 100. If you specify a value greater than 100, at most 100 results are
     *         returned.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify this input parameter to distinguish data streams that have the same name. For example, if you create a
     * data stream and then delete it, and you later create another data stream with the same name, you can use this
     * input parameter to specify which of the two streams you want to list the consumers for.
     * </p>
     * <p>
     * You can't specify this parameter if you specify the NextToken parameter.
     * </p>
     * 
     * @return Specify this input parameter to distinguish data streams that have the same name. For example, if you
     *         create a data stream and then delete it, and you later create another data stream with the same name, you
     *         can use this input parameter to specify which of the two streams you want to list the consumers for. </p>
     *         <p>
     *         You can't specify this parameter if you specify the NextToken parameter.
     */
    public final Instant streamCreationTimestamp() {
        return streamCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(streamCreationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamConsumersRequest)) {
            return false;
        }
        ListStreamConsumersRequest other = (ListStreamConsumersRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(streamCreationTimestamp(), other.streamCreationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamConsumersRequest").add("StreamARN", streamARN()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("StreamCreationTimestamp", streamCreationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StreamCreationTimestamp":
            return Optional.ofNullable(clazz.cast(streamCreationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamConsumersRequest, T> g) {
        return obj -> g.apply((ListStreamConsumersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamConsumersRequest> {
        /**
         * <p>
         * The ARN of the Kinesis data stream for which you want to list the registered consumers. For more information,
         * see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the Kinesis data stream for which you want to list the registered consumers. For more
         *        information, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * When the number of consumers that are registered with the data stream is greater than the default value for
         * the <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
         * is less than the number of consumers that are registered with the data stream, the response includes a
         * pagination token named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a
         * subsequent call to <code>ListStreamConsumers</code> to list the next set of registered consumers.
         * </p>
         * <p>
         * Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         * <code>NextToken</code> because the latter unambiguously identifies the stream.
         * </p>
         * <p>
         * You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         * <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
         * consumers that the operation returns if you don't specify <code>MaxResults</code>, the response will contain
         * a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a subsequent call to
         * the <code>ListStreamConsumers</code> operation to list the next set of consumers.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an expired token
         * in a call to <code>ListStreamConsumers</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of consumers that are registered with the data stream is greater than the default
         *        value for the <code>MaxResults</code> parameter, or if you explicitly specify a value for
         *        <code>MaxResults</code> that is less than the number of consumers that are registered with the data
         *        stream, the response includes a pagination token named <code>NextToken</code>. You can specify this
         *        <code>NextToken</code> value in a subsequent call to <code>ListStreamConsumers</code> to list the next
         *        set of registered consumers.</p>
         *        <p>
         *        Don't specify <code>StreamName</code> or <code>StreamCreationTimestamp</code> if you specify
         *        <code>NextToken</code> because the latter unambiguously identifies the stream.
         *        </p>
         *        <p>
         *        You can optionally specify a value for the <code>MaxResults</code> parameter when you specify
         *        <code>NextToken</code>. If you specify a <code>MaxResults</code> value that is less than the number of
         *        consumers that the operation returns if you don't specify <code>MaxResults</code>, the response will
         *        contain a new <code>NextToken</code> value. You can use the new <code>NextToken</code> value in a
         *        subsequent call to the <code>ListStreamConsumers</code> operation to list the next set of consumers.
         *        </p>
         *        <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListStreamConsumers</code>, you have 300 seconds to use that value. If you specify an
         *        expired token in a call to <code>ListStreamConsumers</code>, you get
         *        <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of consumers that you want a single call of <code>ListStreamConsumers</code> to return.
         * The default value is 100. If you specify a value greater than 100, at most 100 results are returned.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of consumers that you want a single call of <code>ListStreamConsumers</code> to
         *        return. The default value is 100. If you specify a value greater than 100, at most 100 results are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify this input parameter to distinguish data streams that have the same name. For example, if you create
         * a data stream and then delete it, and you later create another data stream with the same name, you can use
         * this input parameter to specify which of the two streams you want to list the consumers for.
         * </p>
         * <p>
         * You can't specify this parameter if you specify the NextToken parameter.
         * </p>
         * 
         * @param streamCreationTimestamp
         *        Specify this input parameter to distinguish data streams that have the same name. For example, if you
         *        create a data stream and then delete it, and you later create another data stream with the same name,
         *        you can use this input parameter to specify which of the two streams you want to list the consumers
         *        for. </p>
         *        <p>
         *        You can't specify this parameter if you specify the NextToken parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreationTimestamp(Instant streamCreationTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String nextToken;

        private Integer maxResults;

        private Instant streamCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamConsumersRequest model) {
            super(model);
            streamARN(model.streamARN);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            streamCreationTimestamp(model.streamCreationTimestamp);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStreamConsumersRequest build() {
            return new ListStreamConsumersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
