/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <a>GetRecords</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecordsRequest extends KinesisRequest implements
        ToCopyableBuilder<GetRecordsRequest.Builder, GetRecordsRequest> {
    private static final SdkField<String> SHARD_ITERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardIterator").getter(getter(GetRecordsRequest::shardIterator)).setter(setter(Builder::shardIterator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardIterator").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(GetRecordsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ITERATOR_FIELD,
            LIMIT_FIELD));

    private final String shardIterator;

    private final Integer limit;

    private GetRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.shardIterator = builder.shardIterator;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The position in the shard from which you want to start sequentially reading data records. A shard iterator
     * specifies this position using the sequence number of a data record in the shard.
     * </p>
     * 
     * @return The position in the shard from which you want to start sequentially reading data records. A shard
     *         iterator specifies this position using the sequence number of a data record in the shard.
     */
    public final String shardIterator() {
        return shardIterator;
    }

    /**
     * <p>
     * The maximum number of records to return. Specify a value of up to 10,000. If you specify a value that is greater
     * than 10,000, <a>GetRecords</a> throws <code>InvalidArgumentException</code>. The default value is 10,000.
     * </p>
     * 
     * @return The maximum number of records to return. Specify a value of up to 10,000. If you specify a value that is
     *         greater than 10,000, <a>GetRecords</a> throws <code>InvalidArgumentException</code>. The default value is
     *         10,000.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardIterator());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsRequest)) {
            return false;
        }
        GetRecordsRequest other = (GetRecordsRequest) obj;
        return Objects.equals(shardIterator(), other.shardIterator()) && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecordsRequest").add("ShardIterator", shardIterator()).add("Limit", limit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardIterator":
            return Optional.ofNullable(clazz.cast(shardIterator()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordsRequest, T> g) {
        return obj -> g.apply((GetRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetRecordsRequest> {
        /**
         * <p>
         * The position in the shard from which you want to start sequentially reading data records. A shard iterator
         * specifies this position using the sequence number of a data record in the shard.
         * </p>
         * 
         * @param shardIterator
         *        The position in the shard from which you want to start sequentially reading data records. A shard
         *        iterator specifies this position using the sequence number of a data record in the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardIterator(String shardIterator);

        /**
         * <p>
         * The maximum number of records to return. Specify a value of up to 10,000. If you specify a value that is
         * greater than 10,000, <a>GetRecords</a> throws <code>InvalidArgumentException</code>. The default value is
         * 10,000.
         * </p>
         * 
         * @param limit
         *        The maximum number of records to return. Specify a value of up to 10,000. If you specify a value that
         *        is greater than 10,000, <a>GetRecords</a> throws <code>InvalidArgumentException</code>. The default
         *        value is 10,000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String shardIterator;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsRequest model) {
            super(model);
            shardIterator(model.shardIterator);
            limit(model.limit);
        }

        public final String getShardIterator() {
            return shardIterator;
        }

        public final void setShardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
        }

        @Override
        public final Builder shardIterator(String shardIterator) {
            this.shardIterator = shardIterator;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecordsRequest build() {
            return new GetRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
