/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you can
 * choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamModeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamModeDetails.Builder, StreamModeDetails> {
    private static final SdkField<String> STREAM_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamMode").getter(getter(StreamModeDetails::streamModeAsString)).setter(setter(Builder::streamMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamMode;

    private StreamModeDetails(BuilderImpl builder) {
        this.streamMode = builder.streamMode;
    }

    /**
     * <p>
     * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you
     * can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data
     * streams.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamMode} will
     * return {@link StreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamModeAsString}.
     * </p>
     * 
     * @return Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data
     *         Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode
     *         for your data streams.
     * @see StreamMode
     */
    public final StreamMode streamMode() {
        return StreamMode.fromValue(streamMode);
    }

    /**
     * <p>
     * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams, you
     * can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data
     * streams.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamMode} will
     * return {@link StreamMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamModeAsString}.
     * </p>
     * 
     * @return Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data
     *         Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode
     *         for your data streams.
     * @see StreamMode
     */
    public final String streamModeAsString() {
        return streamMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamModeDetails)) {
            return false;
        }
        StreamModeDetails other = (StreamModeDetails) obj;
        return Objects.equals(streamModeAsString(), other.streamModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamModeDetails").add("StreamMode", streamModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamMode":
            return Optional.ofNullable(clazz.cast(streamModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamModeDetails, T> g) {
        return obj -> g.apply((StreamModeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamModeDetails> {
        /**
         * <p>
         * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams,
         * you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data
         * streams.
         * </p>
         * 
         * @param streamMode
         *        Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data
         *        Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity
         *        mode for your data streams.
         * @see StreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamMode
         */
        Builder streamMode(String streamMode);

        /**
         * <p>
         * Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data Streams,
         * you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data
         * streams.
         * </p>
         * 
         * @param streamMode
         *        Specifies the capacity mode to which you want to set your data stream. Currently, in Kinesis Data
         *        Streams, you can choose between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity
         *        mode for your data streams.
         * @see StreamMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamMode
         */
        Builder streamMode(StreamMode streamMode);
    }

    static final class BuilderImpl implements Builder {
        private String streamMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamModeDetails model) {
            streamMode(model.streamMode);
        }

        public final String getStreamMode() {
            return streamMode;
        }

        public final void setStreamMode(String streamMode) {
            this.streamMode = streamMode;
        }

        @Override
        public final Builder streamMode(String streamMode) {
            this.streamMode = streamMode;
            return this;
        }

        @Override
        public final Builder streamMode(StreamMode streamMode) {
            this.streamMode(streamMode == null ? null : streamMode.toString());
            return this;
        }

        @Override
        public StreamModeDetails build() {
            return new StreamModeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
