/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve an endpoint for the Kinesis service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class KinesisEndpointParams implements ToCopyableBuilder<KinesisEndpointParams.Builder, KinesisEndpointParams> {
    private final Region region;

    private final Boolean useDualStack;

    private final Boolean useFIPS;

    private final String endpoint;

    private final String streamARN;

    private final String operationType;

    private final String consumerARN;

    private final String resourceARN;

    private KinesisEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useDualStack = builder.useDualStack;
        this.useFIPS = builder.useFIPS;
        this.endpoint = builder.endpoint;
        this.streamARN = builder.streamARN;
        this.operationType = builder.operationType;
        this.consumerARN = builder.consumerARN;
        this.resourceARN = builder.resourceARN;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return region;
    }

    public Boolean useDualStack() {
        return useDualStack;
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public String endpoint() {
        return endpoint;
    }

    public String streamArn() {
        return streamARN;
    }

    public String operationType() {
        return operationType;
    }

    public String consumerArn() {
        return consumerARN;
    }

    public String resourceArn() {
        return resourceARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public interface Builder extends CopyableBuilder<Builder, KinesisEndpointParams> {
        Builder region(Region region);

        Builder useDualStack(Boolean useDualStack);

        Builder useFips(Boolean useFIPS);

        Builder endpoint(String endpoint);

        Builder streamArn(String streamARN);

        Builder operationType(String operationType);

        Builder consumerArn(String consumerARN);

        Builder resourceArn(String resourceARN);

        KinesisEndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private Region region;

        private Boolean useDualStack = false;

        private Boolean useFIPS = false;

        private String endpoint;

        private String streamARN;

        private String operationType;

        private String consumerARN;

        private String resourceARN;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisEndpointParams builder) {
            this.region = builder.region;
            this.useDualStack = builder.useDualStack;
            this.useFIPS = builder.useFIPS;
            this.endpoint = builder.endpoint;
            this.streamARN = builder.streamARN;
            this.operationType = builder.operationType;
            this.consumerARN = builder.consumerARN;
            this.resourceARN = builder.resourceARN;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder streamArn(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public Builder consumerArn(String consumerARN) {
            this.consumerARN = consumerARN;
            return this;
        }

        @Override
        public Builder resourceArn(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        @Override
        public KinesisEndpointParams build() {
            return new KinesisEndpointParams(this);
        }
    }
}
