/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>DescribeStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamRequest extends KinesisRequest implements
        ToCopyableBuilder<DescribeStreamRequest.Builder, DescribeStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(DescribeStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeStreamRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExclusiveStartShardId").getter(getter(DescribeStreamRequest::exclusiveStartShardId))
            .setter(setter(Builder::exclusiveStartShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build())
            .build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(DescribeStreamRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            LIMIT_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, STREAM_ARN_FIELD));

    private final String streamName;

    private final Integer limit;

    private final String exclusiveStartShardId;

    private final String streamARN;

    private DescribeStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.limit = builder.limit;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.streamARN = builder.streamARN;
    }

    /**
     * <p>
     * The name of the stream to describe.
     * </p>
     * 
     * @return The name of the stream to describe.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The maximum number of shards to return in a single call. The default value is 100. If you specify a value greater
     * than 100, at most 100 results are returned.
     * </p>
     * 
     * @return The maximum number of shards to return in a single call. The default value is 100. If you specify a value
     *         greater than 100, at most 100 results are returned.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The shard ID of the shard to start with.
     * </p>
     * <p>
     * Specify this parameter to indicate that you want to describe the stream starting with the shard whose ID
     * immediately follows <code>ExclusiveStartShardId</code>.
     * </p>
     * <p>
     * If you don't specify this parameter, the default behavior for <code>DescribeStream</code> is to describe the
     * stream starting with the first shard in the stream.
     * </p>
     * 
     * @return The shard ID of the shard to start with.</p>
     *         <p>
     *         Specify this parameter to indicate that you want to describe the stream starting with the shard whose ID
     *         immediately follows <code>ExclusiveStartShardId</code>.
     *         </p>
     *         <p>
     *         If you don't specify this parameter, the default behavior for <code>DescribeStream</code> is to describe
     *         the stream starting with the first shard in the stream.
     */
    public final String exclusiveStartShardId() {
        return exclusiveStartShardId;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamRequest)) {
            return false;
        }
        DescribeStreamRequest other = (DescribeStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(limit(), other.limit())
                && Objects.equals(exclusiveStartShardId(), other.exclusiveStartShardId())
                && Objects.equals(streamARN(), other.streamARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamRequest").add("StreamName", streamName()).add("Limit", limit())
                .add("ExclusiveStartShardId", exclusiveStartShardId()).add("StreamARN", streamARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "ExclusiveStartShardId":
            return Optional.ofNullable(clazz.cast(exclusiveStartShardId()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamRequest, T> g) {
        return obj -> g.apply((DescribeStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamRequest> {
        /**
         * <p>
         * The name of the stream to describe.
         * </p>
         * 
         * @param streamName
         *        The name of the stream to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The maximum number of shards to return in a single call. The default value is 100. If you specify a value
         * greater than 100, at most 100 results are returned.
         * </p>
         * 
         * @param limit
         *        The maximum number of shards to return in a single call. The default value is 100. If you specify a
         *        value greater than 100, at most 100 results are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The shard ID of the shard to start with.
         * </p>
         * <p>
         * Specify this parameter to indicate that you want to describe the stream starting with the shard whose ID
         * immediately follows <code>ExclusiveStartShardId</code>.
         * </p>
         * <p>
         * If you don't specify this parameter, the default behavior for <code>DescribeStream</code> is to describe the
         * stream starting with the first shard in the stream.
         * </p>
         * 
         * @param exclusiveStartShardId
         *        The shard ID of the shard to start with.</p>
         *        <p>
         *        Specify this parameter to indicate that you want to describe the stream starting with the shard whose
         *        ID immediately follows <code>ExclusiveStartShardId</code>.
         *        </p>
         *        <p>
         *        If you don't specify this parameter, the default behavior for <code>DescribeStream</code> is to
         *        describe the stream starting with the first shard in the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveStartShardId(String exclusiveStartShardId);

        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private Integer limit;

        private String exclusiveStartShardId;

        private String streamARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamRequest model) {
            super(model);
            streamName(model.streamName);
            limit(model.limit);
            exclusiveStartShardId(model.exclusiveStartShardId);
            streamARN(model.streamARN);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getExclusiveStartShardId() {
            return exclusiveStartShardId;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamRequest build() {
            return new DescribeStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
