/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents enhanced metrics types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnhancedMetrics implements SdkPojo, Serializable, ToCopyableBuilder<EnhancedMetrics.Builder, EnhancedMetrics> {
    private static final SdkField<List<String>> SHARD_LEVEL_METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ShardLevelMetrics")
            .getter(getter(EnhancedMetrics::shardLevelMetricsAsStrings))
            .setter(setter(Builder::shardLevelMetricsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLevelMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_LEVEL_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ShardLevelMetrics", SHARD_LEVEL_METRICS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final List<String> shardLevelMetrics;

    private EnhancedMetrics(BuilderImpl builder) {
        this.shardLevelMetrics = builder.shardLevelMetrics;
    }

    /**
     * <p>
     * List of shard-level metrics.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShardLevelMetrics} method.
     * </p>
     * 
     * @return List of shard-level metrics.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
     *         Developer Guide</i>.
     */
    public final List<MetricsName> shardLevelMetrics() {
        return MetricsNameListCopier.copyStringToEnum(shardLevelMetrics);
    }

    /**
     * For responses, this returns true if the service returned a value for the ShardLevelMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShardLevelMetrics() {
        return shardLevelMetrics != null && !(shardLevelMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of shard-level metrics.
     * </p>
     * <p>
     * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IncomingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IncomingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingBytes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OutgoingRecords</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WriteProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReadProvisionedThroughputExceeded</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IteratorAgeMilliseconds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALL</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
     * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
     * Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShardLevelMetrics} method.
     * </p>
     * 
     * @return List of shard-level metrics.</p>
     *         <p>
     *         The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IncomingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IncomingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingBytes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OutgoingRecords</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WriteProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReadProvisionedThroughputExceeded</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IteratorAgeMilliseconds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALL</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
     *         Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
     *         Developer Guide</i>.
     */
    public final List<String> shardLevelMetricsAsStrings() {
        return shardLevelMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasShardLevelMetrics() ? shardLevelMetricsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnhancedMetrics)) {
            return false;
        }
        EnhancedMetrics other = (EnhancedMetrics) obj;
        return hasShardLevelMetrics() == other.hasShardLevelMetrics()
                && Objects.equals(shardLevelMetricsAsStrings(), other.shardLevelMetricsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnhancedMetrics")
                .add("ShardLevelMetrics", hasShardLevelMetrics() ? shardLevelMetricsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardLevelMetrics":
            return Optional.ofNullable(clazz.cast(shardLevelMetricsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnhancedMetrics, T> g) {
        return obj -> g.apply((EnhancedMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnhancedMetrics> {
        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetricsWithStrings(String... shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics);

        /**
         * <p>
         * List of shard-level metrics.
         * </p>
         * <p>
         * The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IncomingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IncomingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingBytes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OutgoingRecords</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WriteProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReadProvisionedThroughputExceeded</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IteratorAgeMilliseconds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALL</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the Amazon
         * Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams Developer
         * Guide</i>.
         * </p>
         * 
         * @param shardLevelMetrics
         *        List of shard-level metrics.</p>
         *        <p>
         *        The following are the valid shard-level metrics. The value "<code>ALL</code>" enhances every metric.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IncomingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IncomingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingBytes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OutgoingRecords</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WriteProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReadProvisionedThroughputExceeded</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IteratorAgeMilliseconds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALL</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring-with-cloudwatch.html">Monitoring the
         *        Amazon Kinesis Data Streams Service with Amazon CloudWatch</a> in the <i>Amazon Kinesis Data Streams
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLevelMetrics(MetricsName... shardLevelMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<String> shardLevelMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnhancedMetrics model) {
            shardLevelMetricsWithStrings(model.shardLevelMetrics);
        }

        public final Collection<String> getShardLevelMetrics() {
            if (shardLevelMetrics instanceof SdkAutoConstructList) {
                return null;
            }
            return shardLevelMetrics;
        }

        public final void setShardLevelMetrics(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
        }

        @Override
        public final Builder shardLevelMetricsWithStrings(Collection<String> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copy(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetricsWithStrings(String... shardLevelMetrics) {
            shardLevelMetricsWithStrings(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public final Builder shardLevelMetrics(Collection<MetricsName> shardLevelMetrics) {
            this.shardLevelMetrics = MetricsNameListCopier.copyEnumToString(shardLevelMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shardLevelMetrics(MetricsName... shardLevelMetrics) {
            shardLevelMetrics(Arrays.asList(shardLevelMetrics));
            return this;
        }

        @Override
        public EnhancedMetrics build() {
            return new EnhancedMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
