/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListShardsResponse extends KinesisResponse implements
        ToCopyableBuilder<ListShardsResponse.Builder, ListShardsResponse> {
    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField
            .<List<Shard>> builder(MarshallingType.LIST)
            .memberName("Shards")
            .getter(getter(ListShardsResponse::shards))
            .setter(setter(Builder::shards))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shards").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Shard> builder(MarshallingType.SDK_POJO)
                                            .constructor(Shard::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListShardsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SHARDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Shards", SHARDS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<Shard> shards;

    private final String nextToken;

    private ListShardsResponse(BuilderImpl builder) {
        super(builder);
        this.shards = builder.shards;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Shards property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasShards() {
        return shards != null && !(shards instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the shard's
     * parent, and the shard that's adjacent to the shard's parent. Each object also contains the starting and ending
     * hash keys and the starting and ending sequence numbers for the shard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShards} method.
     * </p>
     * 
     * @return An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the
     *         shard's parent, and the shard that's adjacent to the shard's parent. Each object also contains the
     *         starting and ending hash keys and the starting and ending sequence numbers for the shard.
     */
    public final List<Shard> shards() {
        return shards;
    }

    /**
     * <p>
     * When the number of shards in the data stream is greater than the default value for the <code>MaxResults</code>
     * parameter, or if you explicitly specify a value for <code>MaxResults</code> that is less than the number of
     * shards in the data stream, the response includes a pagination token named <code>NextToken</code>. You can specify
     * this <code>NextToken</code> value in a subsequent call to <code>ListShards</code> to list the next set of shards.
     * For more information about the use of this pagination token when calling the <code>ListShards</code> operation,
     * see <a>ListShardsInput$NextToken</a>.
     * </p>
     * <important>
     * <p>
     * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call to
     * <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call to
     * <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     * </p>
     * </important>
     * 
     * @return When the number of shards in the data stream is greater than the default value for the
     *         <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that
     *         is less than the number of shards in the data stream, the response includes a pagination token named
     *         <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
     *         <code>ListShards</code> to list the next set of shards. For more information about the use of this
     *         pagination token when calling the <code>ListShards</code> operation, see
     *         <a>ListShardsInput$NextToken</a>.</p> <important>
     *         <p>
     *         Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a
     *         call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token
     *         in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasShards() ? shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsResponse)) {
            return false;
        }
        ListShardsResponse other = (ListShardsResponse) obj;
        return hasShards() == other.hasShards() && Objects.equals(shards(), other.shards())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListShardsResponse").add("Shards", hasShards() ? shards() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Shards":
            return Optional.ofNullable(clazz.cast(shards()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListShardsResponse, T> g) {
        return obj -> g.apply((ListShardsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListShardsResponse> {
        /**
         * <p>
         * An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the shard's
         * parent, and the shard that's adjacent to the shard's parent. Each object also contains the starting and
         * ending hash keys and the starting and ending sequence numbers for the shard.
         * </p>
         * 
         * @param shards
         *        An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the
         *        shard's parent, and the shard that's adjacent to the shard's parent. Each object also contains the
         *        starting and ending hash keys and the starting and ending sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Collection<Shard> shards);

        /**
         * <p>
         * An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the shard's
         * parent, and the shard that's adjacent to the shard's parent. Each object also contains the starting and
         * ending hash keys and the starting and ending sequence numbers for the shard.
         * </p>
         * 
         * @param shards
         *        An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the
         *        shard's parent, and the shard that's adjacent to the shard's parent. Each object also contains the
         *        starting and ending hash keys and the starting and ending sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shards(Shard... shards);

        /**
         * <p>
         * An array of JSON objects. Each object represents one shard and specifies the IDs of the shard, the shard's
         * parent, and the shard that's adjacent to the shard's parent. Each object also contains the starting and
         * ending hash keys and the starting and ending sequence numbers for the shard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesis.model.Shard.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.kinesis.model.Shard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesis.model.Shard.Builder#build()} is called immediately and its
         * result is passed to {@link #shards(List<Shard>)}.
         * 
         * @param shards
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesis.model.Shard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shards(java.util.Collection<Shard>)
         */
        Builder shards(Consumer<Shard.Builder>... shards);

        /**
         * <p>
         * When the number of shards in the data stream is greater than the default value for the
         * <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code> that is
         * less than the number of shards in the data stream, the response includes a pagination token named
         * <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call to
         * <code>ListShards</code> to list the next set of shards. For more information about the use of this pagination
         * token when calling the <code>ListShards</code> operation, see <a>ListShardsInput$NextToken</a>.
         * </p>
         * <important>
         * <p>
         * Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to a call
         * to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired token in a call
         * to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         * </p>
         * </important>
         * 
         * @param nextToken
         *        When the number of shards in the data stream is greater than the default value for the
         *        <code>MaxResults</code> parameter, or if you explicitly specify a value for <code>MaxResults</code>
         *        that is less than the number of shards in the data stream, the response includes a pagination token
         *        named <code>NextToken</code>. You can specify this <code>NextToken</code> value in a subsequent call
         *        to <code>ListShards</code> to list the next set of shards. For more information about the use of this
         *        pagination token when calling the <code>ListShards</code> operation, see
         *        <a>ListShardsInput$NextToken</a>.</p> <important>
         *        <p>
         *        Tokens expire after 300 seconds. When you obtain a value for <code>NextToken</code> in the response to
         *        a call to <code>ListShards</code>, you have 300 seconds to use that value. If you specify an expired
         *        token in a call to <code>ListShards</code>, you get <code>ExpiredNextTokenException</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsResponse model) {
            super(model);
            shards(model.shards);
            nextToken(model.nextToken);
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard... shards) {
            shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder>... shards) {
            shards(Stream.of(shards).map(c -> Shard.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListShardsResponse build() {
            return new ListShardsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
