/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>ListStreams</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStreamsResponse extends KinesisResponse implements
        ToCopyableBuilder<ListStreamsResponse.Builder, ListStreamsResponse> {
    private static final SdkField<List<String>> STREAM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StreamNames")
            .getter(getter(ListStreamsResponse::streamNames))
            .setter(setter(Builder::streamNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_MORE_STREAMS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasMoreStreams").getter(getter(ListStreamsResponse::hasMoreStreams))
            .setter(setter(Builder::hasMoreStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreStreams").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStreamsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<StreamSummary>> STREAM_SUMMARIES_FIELD = SdkField
            .<List<StreamSummary>> builder(MarshallingType.LIST)
            .memberName("StreamSummaries")
            .getter(getter(ListStreamsResponse::streamSummaries))
            .setter(setter(Builder::streamSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StreamSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StreamSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAMES_FIELD,
            HAS_MORE_STREAMS_FIELD, NEXT_TOKEN_FIELD, STREAM_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamNames", STREAM_NAMES_FIELD);
                    put("HasMoreStreams", HAS_MORE_STREAMS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("StreamSummaries", STREAM_SUMMARIES_FIELD);
                }
            });

    private final List<String> streamNames;

    private final Boolean hasMoreStreams;

    private final String nextToken;

    private final List<StreamSummary> streamSummaries;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streamNames = builder.streamNames;
        this.hasMoreStreams = builder.hasMoreStreams;
        this.nextToken = builder.nextToken;
        this.streamSummaries = builder.streamSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the StreamNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStreamNames() {
        return streamNames != null && !(streamNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of the streams that are associated with the Amazon Web Services account making the
     * <code>ListStreams</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreamNames} method.
     * </p>
     * 
     * @return The names of the streams that are associated with the Amazon Web Services account making the
     *         <code>ListStreams</code> request.
     */
    public final List<String> streamNames() {
        return streamNames;
    }

    /**
     * <p>
     * If set to <code>true</code>, there are more streams available to list.
     * </p>
     * 
     * @return If set to <code>true</code>, there are more streams available to list.
     */
    public final Boolean hasMoreStreams() {
        return hasMoreStreams;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StreamSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStreamSummaries() {
        return streamSummaries != null && !(streamSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStreamSummaries} method.
     * </p>
     * 
     * @return
     */
    public final List<StreamSummary> streamSummaries() {
        return streamSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamNames() ? streamNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreStreams());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasStreamSummaries() ? streamSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse) obj;
        return hasStreamNames() == other.hasStreamNames() && Objects.equals(streamNames(), other.streamNames())
                && Objects.equals(hasMoreStreams(), other.hasMoreStreams()) && Objects.equals(nextToken(), other.nextToken())
                && hasStreamSummaries() == other.hasStreamSummaries()
                && Objects.equals(streamSummaries(), other.streamSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStreamsResponse").add("StreamNames", hasStreamNames() ? streamNames() : null)
                .add("HasMoreStreams", hasMoreStreams()).add("NextToken", nextToken())
                .add("StreamSummaries", hasStreamSummaries() ? streamSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamNames":
            return Optional.ofNullable(clazz.cast(streamNames()));
        case "HasMoreStreams":
            return Optional.ofNullable(clazz.cast(hasMoreStreams()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StreamSummaries":
            return Optional.ofNullable(clazz.cast(streamSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamsResponse, T> g) {
        return obj -> g.apply((ListStreamsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListStreamsResponse> {
        /**
         * <p>
         * The names of the streams that are associated with the Amazon Web Services account making the
         * <code>ListStreams</code> request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the Amazon Web Services account making the
         *        <code>ListStreams</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(Collection<String> streamNames);

        /**
         * <p>
         * The names of the streams that are associated with the Amazon Web Services account making the
         * <code>ListStreams</code> request.
         * </p>
         * 
         * @param streamNames
         *        The names of the streams that are associated with the Amazon Web Services account making the
         *        <code>ListStreams</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamNames(String... streamNames);

        /**
         * <p>
         * If set to <code>true</code>, there are more streams available to list.
         * </p>
         * 
         * @param hasMoreStreams
         *        If set to <code>true</code>, there are more streams available to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreStreams(Boolean hasMoreStreams);

        /**
         * <p/>
         * 
         * @param nextToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p/>
         * 
         * @param streamSummaries
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSummaries(Collection<StreamSummary> streamSummaries);

        /**
         * <p/>
         * 
         * @param streamSummaries
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSummaries(StreamSummary... streamSummaries);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesis.model.StreamSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.kinesis.model.StreamSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesis.model.StreamSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #streamSummaries(List<StreamSummary>)}.
         * 
         * @param streamSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesis.model.StreamSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSummaries(java.util.Collection<StreamSummary>)
         */
        Builder streamSummaries(Consumer<StreamSummary.Builder>... streamSummaries);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private List<String> streamNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasMoreStreams;

        private String nextToken;

        private List<StreamSummary> streamSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            super(model);
            streamNames(model.streamNames);
            hasMoreStreams(model.hasMoreStreams);
            nextToken(model.nextToken);
            streamSummaries(model.streamSummaries);
        }

        public final Collection<String> getStreamNames() {
            if (streamNames instanceof SdkAutoConstructList) {
                return null;
            }
            return streamNames;
        }

        public final void setStreamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
        }

        @Override
        public final Builder streamNames(Collection<String> streamNames) {
            this.streamNames = StreamNameListCopier.copy(streamNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamNames(String... streamNames) {
            streamNames(Arrays.asList(streamNames));
            return this;
        }

        public final Boolean getHasMoreStreams() {
            return hasMoreStreams;
        }

        public final void setHasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
        }

        @Override
        public final Builder hasMoreStreams(Boolean hasMoreStreams) {
            this.hasMoreStreams = hasMoreStreams;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<StreamSummary.Builder> getStreamSummaries() {
            List<StreamSummary.Builder> result = StreamSummaryListCopier.copyToBuilder(this.streamSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamSummaries(Collection<StreamSummary.BuilderImpl> streamSummaries) {
            this.streamSummaries = StreamSummaryListCopier.copyFromBuilder(streamSummaries);
        }

        @Override
        public final Builder streamSummaries(Collection<StreamSummary> streamSummaries) {
            this.streamSummaries = StreamSummaryListCopier.copy(streamSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSummaries(StreamSummary... streamSummaries) {
            streamSummaries(Arrays.asList(streamSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streamSummaries(Consumer<StreamSummary.Builder>... streamSummaries) {
            streamSummaries(Stream.of(streamSummaries).map(c -> StreamSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
