/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStreamSummaryResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeStreamSummaryResponse.Builder, DescribeStreamSummaryResponse> {
    private static final SdkField<StreamDescriptionSummary> STREAM_DESCRIPTION_SUMMARY_FIELD = SdkField
            .<StreamDescriptionSummary> builder(MarshallingType.SDK_POJO).memberName("StreamDescriptionSummary")
            .getter(getter(DescribeStreamSummaryResponse::streamDescriptionSummary))
            .setter(setter(Builder::streamDescriptionSummary)).constructor(StreamDescriptionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamDescriptionSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAM_DESCRIPTION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamDescriptionSummary", STREAM_DESCRIPTION_SUMMARY_FIELD);
                }
            });

    private final StreamDescriptionSummary streamDescriptionSummary;

    private DescribeStreamSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.streamDescriptionSummary = builder.streamDescriptionSummary;
    }

    /**
     * <p>
     * A <a>StreamDescriptionSummary</a> containing information about the stream.
     * </p>
     * 
     * @return A <a>StreamDescriptionSummary</a> containing information about the stream.
     */
    public final StreamDescriptionSummary streamDescriptionSummary() {
        return streamDescriptionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamDescriptionSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamSummaryResponse)) {
            return false;
        }
        DescribeStreamSummaryResponse other = (DescribeStreamSummaryResponse) obj;
        return Objects.equals(streamDescriptionSummary(), other.streamDescriptionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStreamSummaryResponse").add("StreamDescriptionSummary", streamDescriptionSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamDescriptionSummary":
            return Optional.ofNullable(clazz.cast(streamDescriptionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamSummaryResponse, T> g) {
        return obj -> g.apply((DescribeStreamSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStreamSummaryResponse> {
        /**
         * <p>
         * A <a>StreamDescriptionSummary</a> containing information about the stream.
         * </p>
         * 
         * @param streamDescriptionSummary
         *        A <a>StreamDescriptionSummary</a> containing information about the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamDescriptionSummary(StreamDescriptionSummary streamDescriptionSummary);

        /**
         * <p>
         * A <a>StreamDescriptionSummary</a> containing information about the stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamDescriptionSummary.Builder}
         * avoiding the need to create one manually via {@link StreamDescriptionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamDescriptionSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #streamDescriptionSummary(StreamDescriptionSummary)}.
         * 
         * @param streamDescriptionSummary
         *        a consumer that will call methods on {@link StreamDescriptionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamDescriptionSummary(StreamDescriptionSummary)
         */
        default Builder streamDescriptionSummary(Consumer<StreamDescriptionSummary.Builder> streamDescriptionSummary) {
            return streamDescriptionSummary(StreamDescriptionSummary.builder().applyMutation(streamDescriptionSummary).build());
        }
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private StreamDescriptionSummary streamDescriptionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamSummaryResponse model) {
            super(model);
            streamDescriptionSummary(model.streamDescriptionSummary);
        }

        public final StreamDescriptionSummary.Builder getStreamDescriptionSummary() {
            return streamDescriptionSummary != null ? streamDescriptionSummary.toBuilder() : null;
        }

        public final void setStreamDescriptionSummary(StreamDescriptionSummary.BuilderImpl streamDescriptionSummary) {
            this.streamDescriptionSummary = streamDescriptionSummary != null ? streamDescriptionSummary.build() : null;
        }

        @Override
        public final Builder streamDescriptionSummary(StreamDescriptionSummary streamDescriptionSummary) {
            this.streamDescriptionSummary = streamDescriptionSummary;
            return this;
        }

        @Override
        public DescribeStreamSummaryResponse build() {
            return new DescribeStreamSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
