/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of a stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamSummary implements SdkPojo, Serializable, ToCopyableBuilder<StreamSummary.Builder, StreamSummary> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(StreamSummary::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(StreamSummary::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STREAM_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamStatus").getter(getter(StreamSummary::streamStatusAsString)).setter(setter(Builder::streamStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamStatus").build()).build();

    private static final SdkField<StreamModeDetails> STREAM_MODE_DETAILS_FIELD = SdkField
            .<StreamModeDetails> builder(MarshallingType.SDK_POJO).memberName("StreamModeDetails")
            .getter(getter(StreamSummary::streamModeDetails)).setter(setter(Builder::streamModeDetails))
            .constructor(StreamModeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamModeDetails").build()).build();

    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StreamCreationTimestamp").getter(getter(StreamSummary::streamCreationTimestamp))
            .setter(setter(Builder::streamCreationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, STREAM_STATUS_FIELD, STREAM_MODE_DETAILS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamName", STREAM_NAME_FIELD);
                    put("StreamARN", STREAM_ARN_FIELD);
                    put("StreamStatus", STREAM_STATUS_FIELD);
                    put("StreamModeDetails", STREAM_MODE_DETAILS_FIELD);
                    put("StreamCreationTimestamp", STREAM_CREATION_TIMESTAMP_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String streamName;

    private final String streamARN;

    private final String streamStatus;

    private final StreamModeDetails streamModeDetails;

    private final Instant streamCreationTimestamp;

    private StreamSummary(BuilderImpl builder) {
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.streamStatus = builder.streamStatus;
        this.streamModeDetails = builder.streamModeDetails;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
    }

    /**
     * <p>
     * The name of a stream.
     * </p>
     * 
     * @return The name of a stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The ARN of the stream.
     * </p>
     * 
     * @return The ARN of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The status of the stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The status of the stream.
     * @see StreamStatus
     */
    public final StreamStatus streamStatus() {
        return StreamStatus.fromValue(streamStatus);
    }

    /**
     * <p>
     * The status of the stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamStatus} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamStatusAsString}.
     * </p>
     * 
     * @return The status of the stream.
     * @see StreamStatus
     */
    public final String streamStatusAsString() {
        return streamStatus;
    }

    /**
     * Returns the value of the StreamModeDetails property for this object.
     * 
     * @return The value of the StreamModeDetails property for this object.
     */
    public final StreamModeDetails streamModeDetails() {
        return streamModeDetails;
    }

    /**
     * <p>
     * The timestamp at which the stream was created.
     * </p>
     * 
     * @return The timestamp at which the stream was created.
     */
    public final Instant streamCreationTimestamp() {
        return streamCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamModeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(streamCreationTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamSummary)) {
            return false;
        }
        StreamSummary other = (StreamSummary) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(streamStatusAsString(), other.streamStatusAsString())
                && Objects.equals(streamModeDetails(), other.streamModeDetails())
                && Objects.equals(streamCreationTimestamp(), other.streamCreationTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamSummary").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("StreamStatus", streamStatusAsString()).add("StreamModeDetails", streamModeDetails())
                .add("StreamCreationTimestamp", streamCreationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StreamStatus":
            return Optional.ofNullable(clazz.cast(streamStatusAsString()));
        case "StreamModeDetails":
            return Optional.ofNullable(clazz.cast(streamModeDetails()));
        case "StreamCreationTimestamp":
            return Optional.ofNullable(clazz.cast(streamCreationTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StreamSummary, T> g) {
        return obj -> g.apply((StreamSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamSummary> {
        /**
         * <p>
         * The name of a stream.
         * </p>
         * 
         * @param streamName
         *        The name of a stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The ARN of the stream.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The status of the stream.
         * </p>
         * 
         * @param streamStatus
         *        The status of the stream.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(String streamStatus);

        /**
         * <p>
         * The status of the stream.
         * </p>
         * 
         * @param streamStatus
         *        The status of the stream.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder streamStatus(StreamStatus streamStatus);

        /**
         * Sets the value of the StreamModeDetails property for this object.
         *
         * @param streamModeDetails
         *        The new value for the StreamModeDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamModeDetails(StreamModeDetails streamModeDetails);

        /**
         * Sets the value of the StreamModeDetails property for this object.
         *
         * This is a convenience method that creates an instance of the {@link StreamModeDetails.Builder} avoiding the
         * need to create one manually via {@link StreamModeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamModeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #streamModeDetails(StreamModeDetails)}.
         * 
         * @param streamModeDetails
         *        a consumer that will call methods on {@link StreamModeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamModeDetails(StreamModeDetails)
         */
        default Builder streamModeDetails(Consumer<StreamModeDetails.Builder> streamModeDetails) {
            return streamModeDetails(StreamModeDetails.builder().applyMutation(streamModeDetails).build());
        }

        /**
         * <p>
         * The timestamp at which the stream was created.
         * </p>
         * 
         * @param streamCreationTimestamp
         *        The timestamp at which the stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamCreationTimestamp(Instant streamCreationTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String streamStatus;

        private StreamModeDetails streamModeDetails;

        private Instant streamCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamSummary model) {
            streamName(model.streamName);
            streamARN(model.streamARN);
            streamStatus(model.streamStatus);
            streamModeDetails(model.streamModeDetails);
            streamCreationTimestamp(model.streamCreationTimestamp);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamStatus() {
            return streamStatus;
        }

        public final void setStreamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
        }

        @Override
        public final Builder streamStatus(String streamStatus) {
            this.streamStatus = streamStatus;
            return this;
        }

        @Override
        public final Builder streamStatus(StreamStatus streamStatus) {
            this.streamStatus(streamStatus == null ? null : streamStatus.toString());
            return this;
        }

        public final StreamModeDetails.Builder getStreamModeDetails() {
            return streamModeDetails != null ? streamModeDetails.toBuilder() : null;
        }

        public final void setStreamModeDetails(StreamModeDetails.BuilderImpl streamModeDetails) {
            this.streamModeDetails = streamModeDetails != null ? streamModeDetails.build() : null;
        }

        @Override
        public final Builder streamModeDetails(StreamModeDetails streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        public final Instant getStreamCreationTimestamp() {
            return streamCreationTimestamp;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        @Override
        public StreamSummary build() {
            return new StreamSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
