/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A uniquely identified group of data records in a Kinesis data stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Shard implements SdkPojo, Serializable, ToCopyableBuilder<Shard.Builder, Shard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Shard::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<String> PARENT_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Shard::parentShardId)).setter(setter(Builder::parentShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShardId").build()).build();

    private static final SdkField<String> ADJACENT_PARENT_SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Shard::adjacentParentShardId)).setter(setter(Builder::adjacentParentShardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjacentParentShardId").build())
            .build();

    private static final SdkField<HashKeyRange> HASH_KEY_RANGE_FIELD = SdkField.<HashKeyRange> builder(MarshallingType.SDK_POJO)
            .getter(getter(Shard::hashKeyRange)).setter(setter(Builder::hashKeyRange)).constructor(HashKeyRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashKeyRange").build()).build();

    private static final SdkField<SequenceNumberRange> SEQUENCE_NUMBER_RANGE_FIELD = SdkField
            .<SequenceNumberRange> builder(MarshallingType.SDK_POJO).getter(getter(Shard::sequenceNumberRange))
            .setter(setter(Builder::sequenceNumberRange)).constructor(SequenceNumberRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumberRange").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD,
            PARENT_SHARD_ID_FIELD, ADJACENT_PARENT_SHARD_ID_FIELD, HASH_KEY_RANGE_FIELD, SEQUENCE_NUMBER_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String shardId;

    private final String parentShardId;

    private final String adjacentParentShardId;

    private final HashKeyRange hashKeyRange;

    private final SequenceNumberRange sequenceNumberRange;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShardId = builder.parentShardId;
        this.adjacentParentShardId = builder.adjacentParentShardId;
        this.hashKeyRange = builder.hashKeyRange;
        this.sequenceNumberRange = builder.sequenceNumberRange;
    }

    /**
     * <p>
     * The unique identifier of the shard within the stream.
     * </p>
     * 
     * @return The unique identifier of the shard within the stream.
     */
    public String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The shard ID of the shard's parent.
     * </p>
     * 
     * @return The shard ID of the shard's parent.
     */
    public String parentShardId() {
        return parentShardId;
    }

    /**
     * <p>
     * The shard ID of the shard adjacent to the shard's parent.
     * </p>
     * 
     * @return The shard ID of the shard adjacent to the shard's parent.
     */
    public String adjacentParentShardId() {
        return adjacentParentShardId;
    }

    /**
     * <p>
     * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
     * </p>
     * 
     * @return The range of possible hash key values for the shard, which is a set of ordered contiguous positive
     *         integers.
     */
    public HashKeyRange hashKeyRange() {
        return hashKeyRange;
    }

    /**
     * <p>
     * The range of possible sequence numbers for the shard.
     * </p>
     * 
     * @return The range of possible sequence numbers for the shard.
     */
    public SequenceNumberRange sequenceNumberRange() {
        return sequenceNumberRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(parentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(adjacentParentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(hashKeyRange());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumberRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(parentShardId(), other.parentShardId())
                && Objects.equals(adjacentParentShardId(), other.adjacentParentShardId())
                && Objects.equals(hashKeyRange(), other.hashKeyRange())
                && Objects.equals(sequenceNumberRange(), other.sequenceNumberRange());
    }

    @Override
    public String toString() {
        return ToString.builder("Shard").add("ShardId", shardId()).add("ParentShardId", parentShardId())
                .add("AdjacentParentShardId", adjacentParentShardId()).add("HashKeyRange", hashKeyRange())
                .add("SequenceNumberRange", sequenceNumberRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "ParentShardId":
            return Optional.ofNullable(clazz.cast(parentShardId()));
        case "AdjacentParentShardId":
            return Optional.ofNullable(clazz.cast(adjacentParentShardId()));
        case "HashKeyRange":
            return Optional.ofNullable(clazz.cast(hashKeyRange()));
        case "SequenceNumberRange":
            return Optional.ofNullable(clazz.cast(sequenceNumberRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Shard, T> g) {
        return obj -> g.apply((Shard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Shard> {
        /**
         * <p>
         * The unique identifier of the shard within the stream.
         * </p>
         * 
         * @param shardId
         *        The unique identifier of the shard within the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The shard ID of the shard's parent.
         * </p>
         * 
         * @param parentShardId
         *        The shard ID of the shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentShardId(String parentShardId);

        /**
         * <p>
         * The shard ID of the shard adjacent to the shard's parent.
         * </p>
         * 
         * @param adjacentParentShardId
         *        The shard ID of the shard adjacent to the shard's parent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjacentParentShardId(String adjacentParentShardId);

        /**
         * <p>
         * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
         * </p>
         * 
         * @param hashKeyRange
         *        The range of possible hash key values for the shard, which is a set of ordered contiguous positive
         *        integers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hashKeyRange(HashKeyRange hashKeyRange);

        /**
         * <p>
         * The range of possible hash key values for the shard, which is a set of ordered contiguous positive integers.
         * </p>
         * This is a convenience that creates an instance of the {@link HashKeyRange.Builder} avoiding the need to
         * create one manually via {@link HashKeyRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link HashKeyRange.Builder#build()} is called immediately and its
         * result is passed to {@link #hashKeyRange(HashKeyRange)}.
         * 
         * @param hashKeyRange
         *        a consumer that will call methods on {@link HashKeyRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hashKeyRange(HashKeyRange)
         */
        default Builder hashKeyRange(Consumer<HashKeyRange.Builder> hashKeyRange) {
            return hashKeyRange(HashKeyRange.builder().applyMutation(hashKeyRange).build());
        }

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * 
         * @param sequenceNumberRange
         *        The range of possible sequence numbers for the shard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange);

        /**
         * <p>
         * The range of possible sequence numbers for the shard.
         * </p>
         * This is a convenience that creates an instance of the {@link SequenceNumberRange.Builder} avoiding the need
         * to create one manually via {@link SequenceNumberRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link SequenceNumberRange.Builder#build()} is called immediately and
         * its result is passed to {@link #sequenceNumberRange(SequenceNumberRange)}.
         * 
         * @param sequenceNumberRange
         *        a consumer that will call methods on {@link SequenceNumberRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sequenceNumberRange(SequenceNumberRange)
         */
        default Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return sequenceNumberRange(SequenceNumberRange.builder().applyMutation(sequenceNumberRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String shardId;

        private String parentShardId;

        private String adjacentParentShardId;

        private HashKeyRange hashKeyRange;

        private SequenceNumberRange sequenceNumberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            shardId(model.shardId);
            parentShardId(model.parentShardId);
            adjacentParentShardId(model.adjacentParentShardId);
            hashKeyRange(model.hashKeyRange);
            sequenceNumberRange(model.sequenceNumberRange);
        }

        public final String getShardId() {
            return shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public final String getParentShardId() {
            return parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        public final String getAdjacentParentShardId() {
            return adjacentParentShardId;
        }

        @Override
        public final Builder adjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
            return this;
        }

        public final void setAdjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return hashKeyRange != null ? hashKeyRange.toBuilder() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return sequenceNumberRange != null ? sequenceNumberRange.toBuilder() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
