/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateShardCountRequest extends KinesisRequest implements
        ToCopyableBuilder<UpdateShardCountRequest.Builder, UpdateShardCountRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateShardCountRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<Integer> TARGET_SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateShardCountRequest::targetShardCount)).setter(setter(Builder::targetShardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetShardCount").build()).build();

    private static final SdkField<String> SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateShardCountRequest::scalingTypeAsString)).setter(setter(Builder::scalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            TARGET_SHARD_COUNT_FIELD, SCALING_TYPE_FIELD));

    private final String streamName;

    private final Integer targetShardCount;

    private final String scalingType;

    private UpdateShardCountRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.targetShardCount = builder.targetShardCount;
        this.scalingType = builder.scalingType;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The new number of shards.
     * </p>
     * 
     * @return The new number of shards.
     */
    public Integer targetShardCount() {
        return targetShardCount;
    }

    /**
     * <p>
     * The scaling type. Uniform scaling creates shards of equal size.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link ScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling type. Uniform scaling creates shards of equal size.
     * @see ScalingType
     */
    public ScalingType scalingType() {
        return ScalingType.fromValue(scalingType);
    }

    /**
     * <p>
     * The scaling type. Uniform scaling creates shards of equal size.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalingType} will
     * return {@link ScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalingTypeAsString}.
     * </p>
     * 
     * @return The scaling type. Uniform scaling creates shards of equal size.
     * @see ScalingType
     */
    public String scalingTypeAsString() {
        return scalingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(targetShardCount());
        hashCode = 31 * hashCode + Objects.hashCode(scalingTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateShardCountRequest)) {
            return false;
        }
        UpdateShardCountRequest other = (UpdateShardCountRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(targetShardCount(), other.targetShardCount())
                && Objects.equals(scalingTypeAsString(), other.scalingTypeAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateShardCountRequest").add("StreamName", streamName())
                .add("TargetShardCount", targetShardCount()).add("ScalingType", scalingTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "TargetShardCount":
            return Optional.ofNullable(clazz.cast(targetShardCount()));
        case "ScalingType":
            return Optional.ofNullable(clazz.cast(scalingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateShardCountRequest, T> g) {
        return obj -> g.apply((UpdateShardCountRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateShardCountRequest> {
        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The new number of shards.
         * </p>
         * 
         * @param targetShardCount
         *        The new number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetShardCount(Integer targetShardCount);

        /**
         * <p>
         * The scaling type. Uniform scaling creates shards of equal size.
         * </p>
         * 
         * @param scalingType
         *        The scaling type. Uniform scaling creates shards of equal size.
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(String scalingType);

        /**
         * <p>
         * The scaling type. Uniform scaling creates shards of equal size.
         * </p>
         * 
         * @param scalingType
         *        The scaling type. Uniform scaling creates shards of equal size.
         * @see ScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalingType
         */
        Builder scalingType(ScalingType scalingType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private Integer targetShardCount;

        private String scalingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateShardCountRequest model) {
            super(model);
            streamName(model.streamName);
            targetShardCount(model.targetShardCount);
            scalingType(model.scalingType);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Integer getTargetShardCount() {
            return targetShardCount;
        }

        @Override
        public final Builder targetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
            return this;
        }

        public final void setTargetShardCount(Integer targetShardCount) {
            this.targetShardCount = targetShardCount;
        }

        public final String getScalingTypeAsString() {
            return scalingType;
        }

        @Override
        public final Builder scalingType(String scalingType) {
            this.scalingType = scalingType;
            return this;
        }

        @Override
        public final Builder scalingType(ScalingType scalingType) {
            this.scalingType(scalingType.toString());
            return this;
        }

        public final void setScalingType(String scalingType) {
            this.scalingType = scalingType;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateShardCountRequest build() {
            return new UpdateShardCountRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
