/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output for <code>PutRecord</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutRecordResponse extends KinesisResponse implements
        ToCopyableBuilder<PutRecordResponse.Builder, PutRecordResponse> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShardId").getter(getter(PutRecordResponse::shardId)).setter(setter(Builder::shardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();

    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SequenceNumber").getter(getter(PutRecordResponse::sequenceNumber))
            .setter(setter(Builder::sequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()).build();

    private static final SdkField<String> ENCRYPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionType").getter(getter(PutRecordResponse::encryptionTypeAsString))
            .setter(setter(Builder::encryptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD,
            SEQUENCE_NUMBER_FIELD, ENCRYPTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String shardId;

    private final String sequenceNumber;

    private final String encryptionType;

    private PutRecordResponse(BuilderImpl builder) {
        super(builder);
        this.shardId = builder.shardId;
        this.sequenceNumber = builder.sequenceNumber;
        this.encryptionType = builder.encryptionType;
    }

    /**
     * <p>
     * The shard ID of the shard where the data record was placed.
     * </p>
     * 
     * @return The shard ID of the shard where the data record was placed.
     */
    public final String shardId() {
        return shardId;
    }

    /**
     * <p>
     * The sequence number identifier that was assigned to the put data record. The sequence number for the record is
     * unique across all records in the stream. A sequence number is the identifier associated with every record put
     * into the stream.
     * </p>
     * 
     * @return The sequence number identifier that was assigned to the put data record. The sequence number for the
     *         record is unique across all records in the stream. A sequence number is the identifier associated with
     *         every record put into the stream.
     */
    public final String sequenceNumber() {
        return sequenceNumber;
    }

    /**
     * <p>
     * The encryption type to use on the record. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records in the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web
     * Services KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type to use on the record. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records in the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon
     *         Web Services KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public final EncryptionType encryptionType() {
        return EncryptionType.fromValue(encryptionType);
    }

    /**
     * <p>
     * The encryption type to use on the record. This parameter can be one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Do not encrypt the records in the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web
     * Services KMS key.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encryptionType}
     * will return {@link EncryptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encryptionTypeAsString}.
     * </p>
     * 
     * @return The encryption type to use on the record. This parameter can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Do not encrypt the records in the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon
     *         Web Services KMS key.
     *         </p>
     *         </li>
     * @see EncryptionType
     */
    public final String encryptionTypeAsString() {
        return encryptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardId());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRecordResponse)) {
            return false;
        }
        PutRecordResponse other = (PutRecordResponse) obj;
        return Objects.equals(shardId(), other.shardId()) && Objects.equals(sequenceNumber(), other.sequenceNumber())
                && Objects.equals(encryptionTypeAsString(), other.encryptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutRecordResponse").add("ShardId", shardId()).add("SequenceNumber", sequenceNumber())
                .add("EncryptionType", encryptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardId":
            return Optional.ofNullable(clazz.cast(shardId()));
        case "SequenceNumber":
            return Optional.ofNullable(clazz.cast(sequenceNumber()));
        case "EncryptionType":
            return Optional.ofNullable(clazz.cast(encryptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ShardId", SHARD_ID_FIELD);
        map.put("SequenceNumber", SEQUENCE_NUMBER_FIELD);
        map.put("EncryptionType", ENCRYPTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRecordResponse, T> g) {
        return obj -> g.apply((PutRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutRecordResponse> {
        /**
         * <p>
         * The shard ID of the shard where the data record was placed.
         * </p>
         * 
         * @param shardId
         *        The shard ID of the shard where the data record was placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardId(String shardId);

        /**
         * <p>
         * The sequence number identifier that was assigned to the put data record. The sequence number for the record
         * is unique across all records in the stream. A sequence number is the identifier associated with every record
         * put into the stream.
         * </p>
         * 
         * @param sequenceNumber
         *        The sequence number identifier that was assigned to the put data record. The sequence number for the
         *        record is unique across all records in the stream. A sequence number is the identifier associated with
         *        every record put into the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceNumber(String sequenceNumber);

        /**
         * <p>
         * The encryption type to use on the record. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records in the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web
         * Services KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type to use on the record. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records in the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed
         *        Amazon Web Services KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(String encryptionType);

        /**
         * <p>
         * The encryption type to use on the record. This parameter can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Do not encrypt the records in the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web
         * Services KMS key.
         * </p>
         * </li>
         * </ul>
         * 
         * @param encryptionType
         *        The encryption type to use on the record. This parameter can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Do not encrypt the records in the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed
         *        Amazon Web Services KMS key.
         *        </p>
         *        </li>
         * @see EncryptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionType
         */
        Builder encryptionType(EncryptionType encryptionType);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private String shardId;

        private String sequenceNumber;

        private String encryptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRecordResponse model) {
            super(model);
            shardId(model.shardId);
            sequenceNumber(model.sequenceNumber);
            encryptionType(model.encryptionType);
        }

        public final String getShardId() {
            return shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getSequenceNumber() {
            return sequenceNumber;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final String getEncryptionType() {
            return encryptionType;
        }

        public final void setEncryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
        }

        @Override
        public final Builder encryptionType(String encryptionType) {
            this.encryptionType = encryptionType;
            return this;
        }

        @Override
        public final Builder encryptionType(EncryptionType encryptionType) {
            this.encryptionType(encryptionType == null ? null : encryptionType.toString());
            return this;
        }

        @Override
        public PutRecordResponse build() {
            return new PutRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
