/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for <code>CreateStream</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamRequest extends KinesisRequest implements
        ToCopyableBuilder<CreateStreamRequest.Builder, CreateStreamRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(CreateStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShardCount").getter(getter(CreateStreamRequest::shardCount)).setter(setter(Builder::shardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardCount").build()).build();

    private static final SdkField<StreamModeDetails> STREAM_MODE_DETAILS_FIELD = SdkField
            .<StreamModeDetails> builder(MarshallingType.SDK_POJO).memberName("StreamModeDetails")
            .getter(getter(CreateStreamRequest::streamModeDetails)).setter(setter(Builder::streamModeDetails))
            .constructor(StreamModeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamModeDetails").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateStreamRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> WARM_THROUGHPUT_MI_BPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmThroughputMiBps").getter(getter(CreateStreamRequest::warmThroughputMiBps))
            .setter(setter(Builder::warmThroughputMiBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughputMiBps").build())
            .build();

    private static final SdkField<Integer> MAX_RECORD_SIZE_IN_KIB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecordSizeInKiB").getter(getter(CreateStreamRequest::maxRecordSizeInKiB))
            .setter(setter(Builder::maxRecordSizeInKiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordSizeInKiB").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, SHARD_COUNT_FIELD, STREAM_MODE_DETAILS_FIELD, TAGS_FIELD,
                    WARM_THROUGHPUT_MI_BPS_FIELD, MAX_RECORD_SIZE_IN_KIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final Integer shardCount;

    private final StreamModeDetails streamModeDetails;

    private final Map<String, String> tags;

    private final Integer warmThroughputMiBps;

    private final Integer maxRecordSizeInKiB;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.shardCount = builder.shardCount;
        this.streamModeDetails = builder.streamModeDetails;
        this.tags = builder.tags;
        this.warmThroughputMiBps = builder.warmThroughputMiBps;
        this.maxRecordSizeInKiB = builder.maxRecordSizeInKiB;
    }

    /**
     * <p>
     * A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by the
     * application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two streams in two
     * different Amazon Web Services accounts can have the same name. Two streams in the same Amazon Web Services
     * account but in two different Regions can also have the same name.
     * </p>
     * 
     * @return A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by the
     *         application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two
     *         streams in two different Amazon Web Services accounts can have the same name. Two streams in the same
     *         Amazon Web Services account but in two different Regions can also have the same name.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The number of shards that the stream will use. The throughput of the stream is a function of the number of
     * shards; more shards are required for greater provisioned throughput.
     * </p>
     * 
     * @return The number of shards that the stream will use. The throughput of the stream is a function of the number
     *         of shards; more shards are required for greater provisioned throughput.
     */
    public final Integer shardCount() {
        return shardCount;
    }

    /**
     * <p>
     * Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an
     * <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.
     * </p>
     * 
     * @return Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose
     *         between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.
     */
    public final StreamModeDetails streamModeDetails() {
        return streamModeDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of up to 50 key-value pairs to use to create the tags. A tag consists of a required key and an optional
     * value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A set of up to 50 key-value pairs to use to create the tags. A tag consists of a required key and an
     *         optional value.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The target warm throughput in MB/s that the stream should be scaled to handle. This represents the throughput
     * capacity that will be immediately available for write operations.
     * </p>
     * 
     * @return The target warm throughput in MB/s that the stream should be scaled to handle. This represents the
     *         throughput capacity that will be immediately available for write operations.
     */
    public final Integer warmThroughputMiBps() {
        return warmThroughputMiBps;
    }

    /**
     * <p>
     * The maximum record size of a single record in kibibyte (KiB) that you can write to, and read from a stream.
     * </p>
     * 
     * @return The maximum record size of a single record in kibibyte (KiB) that you can write to, and read from a
     *         stream.
     */
    public final Integer maxRecordSizeInKiB() {
        return maxRecordSizeInKiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(streamModeDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughputMiBps());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecordSizeInKiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(shardCount(), other.shardCount())
                && Objects.equals(streamModeDetails(), other.streamModeDetails()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(warmThroughputMiBps(), other.warmThroughputMiBps())
                && Objects.equals(maxRecordSizeInKiB(), other.maxRecordSizeInKiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamRequest").add("StreamName", streamName()).add("ShardCount", shardCount())
                .add("StreamModeDetails", streamModeDetails()).add("Tags", hasTags() ? tags() : null)
                .add("WarmThroughputMiBps", warmThroughputMiBps()).add("MaxRecordSizeInKiB", maxRecordSizeInKiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "ShardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        case "StreamModeDetails":
            return Optional.ofNullable(clazz.cast(streamModeDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WarmThroughputMiBps":
            return Optional.ofNullable(clazz.cast(warmThroughputMiBps()));
        case "MaxRecordSizeInKiB":
            return Optional.ofNullable(clazz.cast(maxRecordSizeInKiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("ShardCount", SHARD_COUNT_FIELD);
        map.put("StreamModeDetails", STREAM_MODE_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WarmThroughputMiBps", WARM_THROUGHPUT_MI_BPS_FIELD);
        map.put("MaxRecordSizeInKiB", MAX_RECORD_SIZE_IN_KIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamRequest, T> g) {
        return obj -> g.apply((CreateStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamRequest> {
        /**
         * <p>
         * A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by the
         * application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two streams in
         * two different Amazon Web Services accounts can have the same name. Two streams in the same Amazon Web
         * Services account but in two different Regions can also have the same name.
         * </p>
         * 
         * @param streamName
         *        A name to identify the stream. The stream name is scoped to the Amazon Web Services account used by
         *        the application that creates the stream. It is also scoped by Amazon Web Services Region. That is, two
         *        streams in two different Amazon Web Services accounts can have the same name. Two streams in the same
         *        Amazon Web Services account but in two different Regions can also have the same name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The number of shards that the stream will use. The throughput of the stream is a function of the number of
         * shards; more shards are required for greater provisioned throughput.
         * </p>
         * 
         * @param shardCount
         *        The number of shards that the stream will use. The throughput of the stream is a function of the
         *        number of shards; more shards are required for greater provisioned throughput.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        /**
         * <p>
         * Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an
         * <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.
         * </p>
         * 
         * @param streamModeDetails
         *        Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose
         *        between an <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data
         *        streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamModeDetails(StreamModeDetails streamModeDetails);

        /**
         * <p>
         * Indicates the capacity mode of the data stream. Currently, in Kinesis Data Streams, you can choose between an
         * <b>on-demand</b> capacity mode and a <b>provisioned</b> capacity mode for your data streams.
         * </p>
         * This is a convenience method that creates an instance of the {@link StreamModeDetails.Builder} avoiding the
         * need to create one manually via {@link StreamModeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StreamModeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #streamModeDetails(StreamModeDetails)}.
         * 
         * @param streamModeDetails
         *        a consumer that will call methods on {@link StreamModeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamModeDetails(StreamModeDetails)
         */
        default Builder streamModeDetails(Consumer<StreamModeDetails.Builder> streamModeDetails) {
            return streamModeDetails(StreamModeDetails.builder().applyMutation(streamModeDetails).build());
        }

        /**
         * <p>
         * A set of up to 50 key-value pairs to use to create the tags. A tag consists of a required key and an optional
         * value.
         * </p>
         * 
         * @param tags
         *        A set of up to 50 key-value pairs to use to create the tags. A tag consists of a required key and an
         *        optional value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The target warm throughput in MB/s that the stream should be scaled to handle. This represents the throughput
         * capacity that will be immediately available for write operations.
         * </p>
         * 
         * @param warmThroughputMiBps
         *        The target warm throughput in MB/s that the stream should be scaled to handle. This represents the
         *        throughput capacity that will be immediately available for write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughputMiBps(Integer warmThroughputMiBps);

        /**
         * <p>
         * The maximum record size of a single record in kibibyte (KiB) that you can write to, and read from a stream.
         * </p>
         * 
         * @param maxRecordSizeInKiB
         *        The maximum record size of a single record in kibibyte (KiB) that you can write to, and read from a
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamName;

        private Integer shardCount;

        private StreamModeDetails streamModeDetails;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer warmThroughputMiBps;

        private Integer maxRecordSizeInKiB;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            streamName(model.streamName);
            shardCount(model.shardCount);
            streamModeDetails(model.streamModeDetails);
            tags(model.tags);
            warmThroughputMiBps(model.warmThroughputMiBps);
            maxRecordSizeInKiB(model.maxRecordSizeInKiB);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final StreamModeDetails.Builder getStreamModeDetails() {
            return streamModeDetails != null ? streamModeDetails.toBuilder() : null;
        }

        public final void setStreamModeDetails(StreamModeDetails.BuilderImpl streamModeDetails) {
            this.streamModeDetails = streamModeDetails != null ? streamModeDetails.build() : null;
        }

        @Override
        public final Builder streamModeDetails(StreamModeDetails streamModeDetails) {
            this.streamModeDetails = streamModeDetails;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getWarmThroughputMiBps() {
            return warmThroughputMiBps;
        }

        public final void setWarmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
        }

        @Override
        public final Builder warmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
            return this;
        }

        public final Integer getMaxRecordSizeInKiB() {
            return maxRecordSizeInKiB;
        }

        public final void setMaxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
        }

        @Override
        public final Builder maxRecordSizeInKiB(Integer maxRecordSizeInKiB) {
            this.maxRecordSizeInKiB = maxRecordSizeInKiB;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
