/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the current status of minimum throughput billing commitment for an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MinimumThroughputBillingCommitmentOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<MinimumThroughputBillingCommitmentOutput.Builder, MinimumThroughputBillingCommitmentOutput> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MinimumThroughputBillingCommitmentOutput::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartedAt").getter(getter(MinimumThroughputBillingCommitmentOutput::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndedAt").getter(getter(MinimumThroughputBillingCommitmentOutput::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndedAt").build()).build();

    private static final SdkField<Instant> EARLIEST_ALLOWED_END_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EarliestAllowedEndAt").getter(getter(MinimumThroughputBillingCommitmentOutput::earliestAllowedEndAt))
            .setter(setter(Builder::earliestAllowedEndAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EarliestAllowedEndAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STARTED_AT_FIELD, ENDED_AT_FIELD, EARLIEST_ALLOWED_END_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant startedAt;

    private final Instant endedAt;

    private final Instant earliestAllowedEndAt;

    private MinimumThroughputBillingCommitmentOutput(BuilderImpl builder) {
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.earliestAllowedEndAt = builder.earliestAllowedEndAt;
    }

    /**
     * <p>
     * The current status of the minimum throughput billing commitment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MinimumThroughputBillingCommitmentOutputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the minimum throughput billing commitment.
     * @see MinimumThroughputBillingCommitmentOutputStatus
     */
    public final MinimumThroughputBillingCommitmentOutputStatus status() {
        return MinimumThroughputBillingCommitmentOutputStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the minimum throughput billing commitment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MinimumThroughputBillingCommitmentOutputStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the minimum throughput billing commitment.
     * @see MinimumThroughputBillingCommitmentOutputStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the commitment was started.
     * </p>
     * 
     * @return The timestamp when the commitment was started.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The timestamp when the commitment was ended.
     * </p>
     * 
     * @return The timestamp when the commitment was ended.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The earliest timestamp when the commitment can be ended.
     * </p>
     * 
     * @return The earliest timestamp when the commitment can be ended.
     */
    public final Instant earliestAllowedEndAt() {
        return earliestAllowedEndAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(earliestAllowedEndAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MinimumThroughputBillingCommitmentOutput)) {
            return false;
        }
        MinimumThroughputBillingCommitmentOutput other = (MinimumThroughputBillingCommitmentOutput) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(earliestAllowedEndAt(), other.earliestAllowedEndAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MinimumThroughputBillingCommitmentOutput").add("Status", statusAsString())
                .add("StartedAt", startedAt()).add("EndedAt", endedAt()).add("EarliestAllowedEndAt", earliestAllowedEndAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StartedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "EndedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "EarliestAllowedEndAt":
            return Optional.ofNullable(clazz.cast(earliestAllowedEndAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StartedAt", STARTED_AT_FIELD);
        map.put("EndedAt", ENDED_AT_FIELD);
        map.put("EarliestAllowedEndAt", EARLIEST_ALLOWED_END_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MinimumThroughputBillingCommitmentOutput, T> g) {
        return obj -> g.apply((MinimumThroughputBillingCommitmentOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MinimumThroughputBillingCommitmentOutput> {
        /**
         * <p>
         * The current status of the minimum throughput billing commitment.
         * </p>
         * 
         * @param status
         *        The current status of the minimum throughput billing commitment.
         * @see MinimumThroughputBillingCommitmentOutputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumThroughputBillingCommitmentOutputStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the minimum throughput billing commitment.
         * </p>
         * 
         * @param status
         *        The current status of the minimum throughput billing commitment.
         * @see MinimumThroughputBillingCommitmentOutputStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MinimumThroughputBillingCommitmentOutputStatus
         */
        Builder status(MinimumThroughputBillingCommitmentOutputStatus status);

        /**
         * <p>
         * The timestamp when the commitment was started.
         * </p>
         * 
         * @param startedAt
         *        The timestamp when the commitment was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The timestamp when the commitment was ended.
         * </p>
         * 
         * @param endedAt
         *        The timestamp when the commitment was ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The earliest timestamp when the commitment can be ended.
         * </p>
         * 
         * @param earliestAllowedEndAt
         *        The earliest timestamp when the commitment can be ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder earliestAllowedEndAt(Instant earliestAllowedEndAt);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant startedAt;

        private Instant endedAt;

        private Instant earliestAllowedEndAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MinimumThroughputBillingCommitmentOutput model) {
            status(model.status);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            earliestAllowedEndAt(model.earliestAllowedEndAt);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MinimumThroughputBillingCommitmentOutputStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getEarliestAllowedEndAt() {
            return earliestAllowedEndAt;
        }

        public final void setEarliestAllowedEndAt(Instant earliestAllowedEndAt) {
            this.earliestAllowedEndAt = earliestAllowedEndAt;
        }

        @Override
        public final Builder earliestAllowedEndAt(Instant earliestAllowedEndAt) {
            this.earliestAllowedEndAt = earliestAllowedEndAt;
            return this;
        }

        @Override
        public MinimumThroughputBillingCommitmentOutput build() {
            return new MinimumThroughputBillingCommitmentOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
