/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateStreamWarmThroughputRequest extends KinesisRequest implements
        ToCopyableBuilder<UpdateStreamWarmThroughputRequest.Builder, UpdateStreamWarmThroughputRequest> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(UpdateStreamWarmThroughputRequest::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(UpdateStreamWarmThroughputRequest::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<Integer> WARM_THROUGHPUT_MI_BPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WarmThroughputMiBps").getter(getter(UpdateStreamWarmThroughputRequest::warmThroughputMiBps))
            .setter(setter(Builder::warmThroughputMiBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmThroughputMiBps").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            STREAM_NAME_FIELD, WARM_THROUGHPUT_MI_BPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamARN;

    private final String streamName;

    private final Integer warmThroughputMiBps;

    private UpdateStreamWarmThroughputRequest(BuilderImpl builder) {
        super(builder);
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
        this.warmThroughputMiBps = builder.warmThroughputMiBps;
    }

    /**
     * <p>
     * The ARN of the stream to be updated.
     * </p>
     * 
     * @return The ARN of the stream to be updated.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream to be updated.
     * </p>
     * 
     * @return The name of the stream to be updated.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The target warm throughput in MB/s that the stream should be scaled to handle. This represents the throughput
     * capacity that will be immediately available for write operations.
     * </p>
     * 
     * @return The target warm throughput in MB/s that the stream should be scaled to handle. This represents the
     *         throughput capacity that will be immediately available for write operations.
     */
    public final Integer warmThroughputMiBps() {
        return warmThroughputMiBps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(warmThroughputMiBps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStreamWarmThroughputRequest)) {
            return false;
        }
        UpdateStreamWarmThroughputRequest other = (UpdateStreamWarmThroughputRequest) obj;
        return Objects.equals(streamARN(), other.streamARN()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(warmThroughputMiBps(), other.warmThroughputMiBps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateStreamWarmThroughputRequest").add("StreamARN", streamARN())
                .add("StreamName", streamName()).add("WarmThroughputMiBps", warmThroughputMiBps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "WarmThroughputMiBps":
            return Optional.ofNullable(clazz.cast(warmThroughputMiBps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("WarmThroughputMiBps", WARM_THROUGHPUT_MI_BPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStreamWarmThroughputRequest, T> g) {
        return obj -> g.apply((UpdateStreamWarmThroughputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateStreamWarmThroughputRequest> {
        /**
         * <p>
         * The ARN of the stream to be updated.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream to be updated.
         * </p>
         * 
         * @param streamName
         *        The name of the stream to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The target warm throughput in MB/s that the stream should be scaled to handle. This represents the throughput
         * capacity that will be immediately available for write operations.
         * </p>
         * 
         * @param warmThroughputMiBps
         *        The target warm throughput in MB/s that the stream should be scaled to handle. This represents the
         *        throughput capacity that will be immediately available for write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warmThroughputMiBps(Integer warmThroughputMiBps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisRequest.BuilderImpl implements Builder {
        private String streamARN;

        private String streamName;

        private Integer warmThroughputMiBps;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStreamWarmThroughputRequest model) {
            super(model);
            streamARN(model.streamARN);
            streamName(model.streamName);
            warmThroughputMiBps(model.warmThroughputMiBps);
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final Integer getWarmThroughputMiBps() {
            return warmThroughputMiBps;
        }

        public final void setWarmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
        }

        @Override
        public final Builder warmThroughputMiBps(Integer warmThroughputMiBps) {
            this.warmThroughputMiBps = warmThroughputMiBps;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStreamWarmThroughputRequest build() {
            return new UpdateStreamWarmThroughputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
