/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the warm throughput configuration on the stream. This is only present for On-Demand Kinesis Data Streams
 * in accounts that have <code>MinimumThroughputBillingCommitment</code> enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarmThroughputObject implements SdkPojo, Serializable,
        ToCopyableBuilder<WarmThroughputObject.Builder, WarmThroughputObject> {
    private static final SdkField<Integer> TARGET_MI_BPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetMiBps").getter(getter(WarmThroughputObject::targetMiBps)).setter(setter(Builder::targetMiBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMiBps").build()).build();

    private static final SdkField<Integer> CURRENT_MI_BPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentMiBps").getter(getter(WarmThroughputObject::currentMiBps)).setter(setter(Builder::currentMiBps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMiBps").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_MI_BPS_FIELD,
            CURRENT_MI_BPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetMiBps;

    private final Integer currentMiBps;

    private WarmThroughputObject(BuilderImpl builder) {
        this.targetMiBps = builder.targetMiBps;
        this.currentMiBps = builder.currentMiBps;
    }

    /**
     * <p>
     * The target warm throughput value on the stream. This indicates that the stream is currently scaling towards this
     * target value.
     * </p>
     * 
     * @return The target warm throughput value on the stream. This indicates that the stream is currently scaling
     *         towards this target value.
     */
    public final Integer targetMiBps() {
        return targetMiBps;
    }

    /**
     * <p>
     * The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is
     * currently scaled to handle.
     * </p>
     * 
     * @return The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is
     *         currently scaled to handle.
     */
    public final Integer currentMiBps() {
        return currentMiBps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetMiBps());
        hashCode = 31 * hashCode + Objects.hashCode(currentMiBps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmThroughputObject)) {
            return false;
        }
        WarmThroughputObject other = (WarmThroughputObject) obj;
        return Objects.equals(targetMiBps(), other.targetMiBps()) && Objects.equals(currentMiBps(), other.currentMiBps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarmThroughputObject").add("TargetMiBps", targetMiBps()).add("CurrentMiBps", currentMiBps())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetMiBps":
            return Optional.ofNullable(clazz.cast(targetMiBps()));
        case "CurrentMiBps":
            return Optional.ofNullable(clazz.cast(currentMiBps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetMiBps", TARGET_MI_BPS_FIELD);
        map.put("CurrentMiBps", CURRENT_MI_BPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarmThroughputObject, T> g) {
        return obj -> g.apply((WarmThroughputObject) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarmThroughputObject> {
        /**
         * <p>
         * The target warm throughput value on the stream. This indicates that the stream is currently scaling towards
         * this target value.
         * </p>
         * 
         * @param targetMiBps
         *        The target warm throughput value on the stream. This indicates that the stream is currently scaling
         *        towards this target value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMiBps(Integer targetMiBps);

        /**
         * <p>
         * The current warm throughput value on the stream. This is the write throughput in MiBps that the stream is
         * currently scaled to handle.
         * </p>
         * 
         * @param currentMiBps
         *        The current warm throughput value on the stream. This is the write throughput in MiBps that the stream
         *        is currently scaled to handle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMiBps(Integer currentMiBps);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetMiBps;

        private Integer currentMiBps;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmThroughputObject model) {
            targetMiBps(model.targetMiBps);
            currentMiBps(model.currentMiBps);
        }

        public final Integer getTargetMiBps() {
            return targetMiBps;
        }

        public final void setTargetMiBps(Integer targetMiBps) {
            this.targetMiBps = targetMiBps;
        }

        @Override
        public final Builder targetMiBps(Integer targetMiBps) {
            this.targetMiBps = targetMiBps;
            return this;
        }

        public final Integer getCurrentMiBps() {
            return currentMiBps;
        }

        public final void setCurrentMiBps(Integer currentMiBps) {
            this.currentMiBps = currentMiBps;
        }

        @Override
        public final Builder currentMiBps(Integer currentMiBps) {
            this.currentMiBps = currentMiBps;
            return this;
        }

        @Override
        public WarmThroughputObject build() {
            return new WarmThroughputObject(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
