/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLimitsResponse extends KinesisResponse implements
        ToCopyableBuilder<DescribeLimitsResponse.Builder, DescribeLimitsResponse> {
    private static final SdkField<Integer> SHARD_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeLimitsResponse::shardLimit)).setter(setter(Builder::shardLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardLimit").build()).build();

    private static final SdkField<Integer> OPEN_SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeLimitsResponse::openShardCount)).setter(setter(Builder::openShardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenShardCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_LIMIT_FIELD,
            OPEN_SHARD_COUNT_FIELD));

    private final Integer shardLimit;

    private final Integer openShardCount;

    private DescribeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.shardLimit = builder.shardLimit;
        this.openShardCount = builder.openShardCount;
    }

    /**
     * <p>
     * The maximum number of shards.
     * </p>
     * 
     * @return The maximum number of shards.
     */
    public Integer shardLimit() {
        return shardLimit;
    }

    /**
     * <p>
     * The number of open shards.
     * </p>
     * 
     * @return The number of open shards.
     */
    public Integer openShardCount() {
        return openShardCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(openShardCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse) obj;
        return Objects.equals(shardLimit(), other.shardLimit()) && Objects.equals(openShardCount(), other.openShardCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLimitsResponse").add("ShardLimit", shardLimit()).add("OpenShardCount", openShardCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ShardLimit":
            return Optional.ofNullable(clazz.cast(shardLimit()));
        case "OpenShardCount":
            return Optional.ofNullable(clazz.cast(openShardCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLimitsResponse> {
        /**
         * <p>
         * The maximum number of shards.
         * </p>
         * 
         * @param shardLimit
         *        The maximum number of shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardLimit(Integer shardLimit);

        /**
         * <p>
         * The number of open shards.
         * </p>
         * 
         * @param openShardCount
         *        The number of open shards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openShardCount(Integer openShardCount);
    }

    static final class BuilderImpl extends KinesisResponse.BuilderImpl implements Builder {
        private Integer shardLimit;

        private Integer openShardCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            super(model);
            shardLimit(model.shardLimit);
            openShardCount(model.openShardCount);
        }

        public final Integer getShardLimit() {
            return shardLimit;
        }

        @Override
        public final Builder shardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
            return this;
        }

        public final void setShardLimit(Integer shardLimit) {
            this.shardLimit = shardLimit;
        }

        public final Integer getOpenShardCount() {
            return openShardCount;
        }

        @Override
        public final Builder openShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
            return this;
        }

        public final void setOpenShardCount(Integer openShardCount) {
            this.openShardCount = openShardCount;
        }

        @Override
        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
