/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This documentation is for version 1 of the Amazon Kinesis Data Analytics API, which only supports SQL applications.
 * Version 2 of the API supports SQL and Java applications. For more information about version 2, see <a
 * href="/kinesisanalytics/latest/apiv2/Welcome.html">Amazon Kinesis Data Analytics API V2 Documentation</a>.
 * </p>
 * </note>
 * <p>
 * Provides application summary information, including the application Amazon Resource Name (ARN), name, and status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(ApplicationSummary::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationARN").getter(getter(ApplicationSummary::applicationARN))
            .setter(setter(Builder::applicationARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()).build();

    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationStatus").getter(getter(ApplicationSummary::applicationStatusAsString))
            .setter(setter(Builder::applicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            APPLICATION_ARN_FIELD, APPLICATION_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationName;

    private final String applicationARN;

    private final String applicationStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * ARN of the application.
     * </p>
     * 
     * @return ARN of the application.
     */
    public final String applicationARN() {
        return applicationARN;
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see ApplicationStatus
     */
    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(applicationStatus);
    }

    /**
     * <p>
     * Status of the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationStatus}
     * will return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStatusAsString}.
     * </p>
     * 
     * @return Status of the application.
     * @see ApplicationStatus
     */
    public final String applicationStatusAsString() {
        return applicationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationARN(), other.applicationARN())
                && Objects.equals(applicationStatusAsString(), other.applicationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationName", applicationName())
                .add("ApplicationARN", applicationARN()).add("ApplicationStatus", applicationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationARN":
            return Optional.ofNullable(clazz.cast(applicationARN()));
        case "ApplicationStatus":
            return Optional.ofNullable(clazz.cast(applicationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * ARN of the application.
         * </p>
         * 
         * @param applicationARN
         *        ARN of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationARN(String applicationARN);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(String applicationStatus);

        /**
         * <p>
         * Status of the application.
         * </p>
         * 
         * @param applicationStatus
         *        Status of the application.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder applicationStatus(ApplicationStatus applicationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String applicationName;

        private String applicationARN;

        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationName(model.applicationName);
            applicationARN(model.applicationARN);
            applicationStatus(model.applicationStatus);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationARN() {
            return applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        public final String getApplicationStatus() {
            return applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
