/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationResponse extends KinesisAnalyticsResponse implements
        ToCopyableBuilder<CreateApplicationResponse.Builder, CreateApplicationResponse> {
    private static final SdkField<ApplicationSummary> APPLICATION_SUMMARY_FIELD = SdkField
            .<ApplicationSummary> builder(MarshallingType.SDK_POJO).memberName("ApplicationSummary")
            .getter(getter(CreateApplicationResponse::applicationSummary)).setter(setter(Builder::applicationSummary))
            .constructor(ApplicationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARY_FIELD));

    private final ApplicationSummary applicationSummary;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummary = builder.applicationSummary;
    }

    /**
     * <p>
     * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with a
     * summary of the application it created, including the application Amazon Resource Name (ARN), name, and status.
     * </p>
     * 
     * @return In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response
     *         with a summary of the application it created, including the application Amazon Resource Name (ARN), name,
     *         and status.
     */
    public final ApplicationSummary applicationSummary() {
        return applicationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse) obj;
        return Objects.equals(applicationSummary(), other.applicationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationResponse").add("ApplicationSummary", applicationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummary":
            return Optional.ofNullable(clazz.cast(applicationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationResponse, T> g) {
        return obj -> g.apply((CreateApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationResponse> {
        /**
         * <p>
         * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with
         * a summary of the application it created, including the application Amazon Resource Name (ARN), name, and
         * status.
         * </p>
         * 
         * @param applicationSummary
         *        In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a
         *        response with a summary of the application it created, including the application Amazon Resource Name
         *        (ARN), name, and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummary(ApplicationSummary applicationSummary);

        /**
         * <p>
         * In response to your <code>CreateApplication</code> request, Amazon Kinesis Analytics returns a response with
         * a summary of the application it created, including the application Amazon Resource Name (ARN), name, and
         * status.
         * </p>
         * This is a convenience that creates an instance of the {@link ApplicationSummary.Builder} avoiding the need to
         * create one manually via {@link ApplicationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ApplicationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #applicationSummary(ApplicationSummary)}.
         * 
         * @param applicationSummary
         *        a consumer that will call methods on {@link ApplicationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSummary(ApplicationSummary)
         */
        default Builder applicationSummary(Consumer<ApplicationSummary.Builder> applicationSummary) {
            return applicationSummary(ApplicationSummary.builder().applyMutation(applicationSummary).build());
        }
    }

    static final class BuilderImpl extends KinesisAnalyticsResponse.BuilderImpl implements Builder {
        private ApplicationSummary applicationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            applicationSummary(model.applicationSummary);
        }

        public final ApplicationSummary.Builder getApplicationSummary() {
            return applicationSummary != null ? applicationSummary.toBuilder() : null;
        }

        @Override
        public final Builder applicationSummary(ApplicationSummary applicationSummary) {
            this.applicationSummary = applicationSummary;
            return this;
        }

        public final void setApplicationSummary(ApplicationSummary.BuilderImpl applicationSummary) {
            this.applicationSummary = applicationSummary != null ? applicationSummary.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
