/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides configuration information about an input processor. Currently, the only input processor available is <a
 * href="https://docs.aws.amazon.com/lambda/">AWS Lambda</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputProcessingConfigurationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<InputProcessingConfigurationDescription.Builder, InputProcessingConfigurationDescription> {
    private static final SdkField<InputLambdaProcessorDescription> INPUT_LAMBDA_PROCESSOR_DESCRIPTION_FIELD = SdkField
            .<InputLambdaProcessorDescription> builder(MarshallingType.SDK_POJO)
            .memberName("InputLambdaProcessorDescription")
            .getter(getter(InputProcessingConfigurationDescription::inputLambdaProcessorDescription))
            .setter(setter(Builder::inputLambdaProcessorDescription))
            .constructor(InputLambdaProcessorDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputLambdaProcessorDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INPUT_LAMBDA_PROCESSOR_DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final InputLambdaProcessorDescription inputLambdaProcessorDescription;

    private InputProcessingConfigurationDescription(BuilderImpl builder) {
        this.inputLambdaProcessorDescription = builder.inputLambdaProcessorDescription;
    }

    /**
     * <p>
     * Provides configuration information about the associated <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html"
     * >InputLambdaProcessorDescription</a>.
     * </p>
     * 
     * @return Provides configuration information about the associated <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html"
     *         >InputLambdaProcessorDescription</a>.
     */
    public final InputLambdaProcessorDescription inputLambdaProcessorDescription() {
        return inputLambdaProcessorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputLambdaProcessorDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputProcessingConfigurationDescription)) {
            return false;
        }
        InputProcessingConfigurationDescription other = (InputProcessingConfigurationDescription) obj;
        return Objects.equals(inputLambdaProcessorDescription(), other.inputLambdaProcessorDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputProcessingConfigurationDescription")
                .add("InputLambdaProcessorDescription", inputLambdaProcessorDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputLambdaProcessorDescription":
            return Optional.ofNullable(clazz.cast(inputLambdaProcessorDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputProcessingConfigurationDescription, T> g) {
        return obj -> g.apply((InputProcessingConfigurationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputProcessingConfigurationDescription> {
        /**
         * <p>
         * Provides configuration information about the associated <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html"
         * >InputLambdaProcessorDescription</a>.
         * </p>
         * 
         * @param inputLambdaProcessorDescription
         *        Provides configuration information about the associated <a href=
         *        "https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html"
         *        >InputLambdaProcessorDescription</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputLambdaProcessorDescription(InputLambdaProcessorDescription inputLambdaProcessorDescription);

        /**
         * <p>
         * Provides configuration information about the associated <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputLambdaProcessorDescription.html"
         * >InputLambdaProcessorDescription</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link InputLambdaProcessorDescription.Builder}
         * avoiding the need to create one manually via {@link InputLambdaProcessorDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputLambdaProcessorDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #inputLambdaProcessorDescription(InputLambdaProcessorDescription)}.
         * 
         * @param inputLambdaProcessorDescription
         *        a consumer that will call methods on {@link InputLambdaProcessorDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputLambdaProcessorDescription(InputLambdaProcessorDescription)
         */
        default Builder inputLambdaProcessorDescription(
                Consumer<InputLambdaProcessorDescription.Builder> inputLambdaProcessorDescription) {
            return inputLambdaProcessorDescription(InputLambdaProcessorDescription.builder()
                    .applyMutation(inputLambdaProcessorDescription).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InputLambdaProcessorDescription inputLambdaProcessorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(InputProcessingConfigurationDescription model) {
            inputLambdaProcessorDescription(model.inputLambdaProcessorDescription);
        }

        public final InputLambdaProcessorDescription.Builder getInputLambdaProcessorDescription() {
            return inputLambdaProcessorDescription != null ? inputLambdaProcessorDescription.toBuilder() : null;
        }

        @Override
        public final Builder inputLambdaProcessorDescription(InputLambdaProcessorDescription inputLambdaProcessorDescription) {
            this.inputLambdaProcessorDescription = inputLambdaProcessorDescription;
            return this;
        }

        public final void setInputLambdaProcessorDescription(
                InputLambdaProcessorDescription.BuilderImpl inputLambdaProcessorDescription) {
            this.inputLambdaProcessorDescription = inputLambdaProcessorDescription != null ? inputLambdaProcessorDescription
                    .build() : null;
        }

        @Override
        public InputProcessingConfigurationDescription build() {
            return new InputProcessingConfigurationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
