/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When updating an output configuration using the <a
 * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_UpdateApplication.html">UpdateApplication</a>
 * operation, provides information about an Amazon Kinesis Firehose delivery stream configured as the destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisFirehoseOutputUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisFirehoseOutputUpdate.Builder, KinesisFirehoseOutputUpdate> {
    private static final SdkField<String> RESOURCE_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceARNUpdate").getter(getter(KinesisFirehoseOutputUpdate::resourceARNUpdate))
            .setter(setter(Builder::resourceARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARNUpdate").build()).build();

    private static final SdkField<String> ROLE_ARN_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARNUpdate").getter(getter(KinesisFirehoseOutputUpdate::roleARNUpdate))
            .setter(setter(Builder::roleARNUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARNUpdate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_UPDATE_FIELD,
            ROLE_ARN_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceARNUpdate;

    private final String roleARNUpdate;

    private KinesisFirehoseOutputUpdate(BuilderImpl builder) {
        this.resourceARNUpdate = builder.resourceARNUpdate;
        this.roleARNUpdate = builder.roleARNUpdate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.
     */
    public final String resourceARNUpdate() {
        return resourceARNUpdate;
    }

    /**
     * <p>
     * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
     * grant the necessary permissions to this role.
     * </p>
     * 
     * @return ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
     *         need to grant the necessary permissions to this role.
     */
    public final String roleARNUpdate() {
        return roleARNUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(roleARNUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisFirehoseOutputUpdate)) {
            return false;
        }
        KinesisFirehoseOutputUpdate other = (KinesisFirehoseOutputUpdate) obj;
        return Objects.equals(resourceARNUpdate(), other.resourceARNUpdate())
                && Objects.equals(roleARNUpdate(), other.roleARNUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisFirehoseOutputUpdate").add("ResourceARNUpdate", resourceARNUpdate())
                .add("RoleARNUpdate", roleARNUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceARNUpdate":
            return Optional.ofNullable(clazz.cast(resourceARNUpdate()));
        case "RoleARNUpdate":
            return Optional.ofNullable(clazz.cast(roleARNUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisFirehoseOutputUpdate, T> g) {
        return obj -> g.apply((KinesisFirehoseOutputUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisFirehoseOutputUpdate> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.
         * </p>
         * 
         * @param resourceARNUpdate
         *        Amazon Resource Name (ARN) of the Amazon Kinesis Firehose delivery stream to write to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceARNUpdate(String resourceARNUpdate);

        /**
         * <p>
         * ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You need to
         * grant the necessary permissions to this role.
         * </p>
         * 
         * @param roleARNUpdate
         *        ARN of the IAM role that Amazon Kinesis Analytics can assume to access the stream on your behalf. You
         *        need to grant the necessary permissions to this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARNUpdate(String roleARNUpdate);
    }

    static final class BuilderImpl implements Builder {
        private String resourceARNUpdate;

        private String roleARNUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisFirehoseOutputUpdate model) {
            resourceARNUpdate(model.resourceARNUpdate);
            roleARNUpdate(model.roleARNUpdate);
        }

        public final String getResourceARNUpdate() {
            return resourceARNUpdate;
        }

        @Override
        public final Builder resourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
            return this;
        }

        public final void setResourceARNUpdate(String resourceARNUpdate) {
            this.resourceARNUpdate = resourceARNUpdate;
        }

        public final String getRoleARNUpdate() {
            return roleARNUpdate;
        }

        @Override
        public final Builder roleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
            return this;
        }

        public final void setRoleARNUpdate(String roleARNUpdate) {
            this.roleARNUpdate = roleARNUpdate;
        }

        @Override
        public KinesisFirehoseOutputUpdate build() {
            return new KinesisFirehoseOutputUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
