/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationCloudWatchLoggingOptionRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<AddApplicationCloudWatchLoggingOptionRequest.Builder, AddApplicationCloudWatchLoggingOptionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(AddApplicationCloudWatchLoggingOptionRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(AddApplicationCloudWatchLoggingOptionRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<CloudWatchLoggingOption> CLOUD_WATCH_LOGGING_OPTION_FIELD = SdkField
            .<CloudWatchLoggingOption> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLoggingOption")
            .getter(getter(AddApplicationCloudWatchLoggingOptionRequest::cloudWatchLoggingOption))
            .setter(setter(Builder::cloudWatchLoggingOption)).constructor(CloudWatchLoggingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_FIELD));

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final CloudWatchLoggingOption cloudWatchLoggingOption;

    private AddApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOption = builder.cloudWatchLoggingOption;
    }

    /**
     * <p>
     * The Kinesis Analytics application name.
     * </p>
     * 
     * @return The Kinesis Analytics application name.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Kinesis Analytics application.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write application
     * messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy action enabled.
     * </p>
     * 
     * @return Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
     *         application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code>
     *         policy action enabled.
     */
    public final CloudWatchLoggingOption cloudWatchLoggingOption() {
        return cloudWatchLoggingOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        AddApplicationCloudWatchLoggingOptionRequest other = (AddApplicationCloudWatchLoggingOptionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(cloudWatchLoggingOption(), other.cloudWatchLoggingOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationCloudWatchLoggingOptionRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("CloudWatchLoggingOption", cloudWatchLoggingOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "CloudWatchLoggingOption":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationCloudWatchLoggingOptionRequest, T> g) {
        return obj -> g.apply((AddApplicationCloudWatchLoggingOptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationCloudWatchLoggingOptionRequest> {
        /**
         * <p>
         * The Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         * application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy
         * action enabled.
         * </p>
         * 
         * @param cloudWatchLoggingOption
         *        Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         *        application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code>
         *        policy action enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption);

        /**
         * <p>
         * Provides the CloudWatch log stream Amazon Resource Name (ARN) and the IAM role ARN. Note: To write
         * application messages to CloudWatch, the IAM role that is used must have the <code>PutLogEvents</code> policy
         * action enabled.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLoggingOption.Builder} avoiding the
         * need to create one manually via {@link CloudWatchLoggingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLoggingOption.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudWatchLoggingOption(CloudWatchLoggingOption)}.
         * 
         * @param cloudWatchLoggingOption
         *        a consumer that will call methods on {@link CloudWatchLoggingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOption(CloudWatchLoggingOption)
         */
        default Builder cloudWatchLoggingOption(Consumer<CloudWatchLoggingOption.Builder> cloudWatchLoggingOption) {
            return cloudWatchLoggingOption(CloudWatchLoggingOption.builder().applyMutation(cloudWatchLoggingOption).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private CloudWatchLoggingOption cloudWatchLoggingOption;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationCloudWatchLoggingOptionRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            cloudWatchLoggingOption(model.cloudWatchLoggingOption);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        @Transient
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final CloudWatchLoggingOption.Builder getCloudWatchLoggingOption() {
            return cloudWatchLoggingOption != null ? cloudWatchLoggingOption.toBuilder() : null;
        }

        public final void setCloudWatchLoggingOption(CloudWatchLoggingOption.BuilderImpl cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption != null ? cloudWatchLoggingOption.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOption(CloudWatchLoggingOption cloudWatchLoggingOption) {
            this.cloudWatchLoggingOption = cloudWatchLoggingOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationCloudWatchLoggingOptionRequest build() {
            return new AddApplicationCloudWatchLoggingOptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
