/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to apply to an existing Amazon Kinesis Analytics application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationUpdate.Builder, ApplicationUpdate> {
    private static final SdkField<List<InputUpdate>> INPUT_UPDATES_FIELD = SdkField
            .<List<InputUpdate>> builder(MarshallingType.LIST)
            .memberName("InputUpdates")
            .getter(getter(ApplicationUpdate::inputUpdates))
            .setter(setter(Builder::inputUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_CODE_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationCodeUpdate").getter(getter(ApplicationUpdate::applicationCodeUpdate))
            .setter(setter(Builder::applicationCodeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCodeUpdate").build())
            .build();

    private static final SdkField<List<OutputUpdate>> OUTPUT_UPDATES_FIELD = SdkField
            .<List<OutputUpdate>> builder(MarshallingType.LIST)
            .memberName("OutputUpdates")
            .getter(getter(ApplicationUpdate::outputUpdates))
            .setter(setter(Builder::outputUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ReferenceDataSourceUpdate>> REFERENCE_DATA_SOURCE_UPDATES_FIELD = SdkField
            .<List<ReferenceDataSourceUpdate>> builder(MarshallingType.LIST)
            .memberName("ReferenceDataSourceUpdates")
            .getter(getter(ApplicationUpdate::referenceDataSourceUpdates))
            .setter(setter(Builder::referenceDataSourceUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceDataSourceUpdates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReferenceDataSourceUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceDataSourceUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CloudWatchLoggingOptionUpdate>> CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD = SdkField
            .<List<CloudWatchLoggingOptionUpdate>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptionUpdates")
            .getter(getter(ApplicationUpdate::cloudWatchLoggingOptionUpdates))
            .setter(setter(Builder::cloudWatchLoggingOptionUpdates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionUpdates")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOptionUpdate> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOptionUpdate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_UPDATES_FIELD,
            APPLICATION_CODE_UPDATE_FIELD, OUTPUT_UPDATES_FIELD, REFERENCE_DATA_SOURCE_UPDATES_FIELD,
            CLOUD_WATCH_LOGGING_OPTION_UPDATES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InputUpdate> inputUpdates;

    private final String applicationCodeUpdate;

    private final List<OutputUpdate> outputUpdates;

    private final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates;

    private final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates;

    private ApplicationUpdate(BuilderImpl builder) {
        this.inputUpdates = builder.inputUpdates;
        this.applicationCodeUpdate = builder.applicationCodeUpdate;
        this.outputUpdates = builder.outputUpdates;
        this.referenceDataSourceUpdates = builder.referenceDataSourceUpdates;
        this.cloudWatchLoggingOptionUpdates = builder.cloudWatchLoggingOptionUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputUpdates() {
        return inputUpdates != null && !(inputUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes application input configuration updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputUpdates} method.
     * </p>
     * 
     * @return Describes application input configuration updates.
     */
    public final List<InputUpdate> inputUpdates() {
        return inputUpdates;
    }

    /**
     * <p>
     * Describes application code updates.
     * </p>
     * 
     * @return Describes application code updates.
     */
    public final String applicationCodeUpdate() {
        return applicationCodeUpdate;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputUpdates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputUpdates() {
        return outputUpdates != null && !(outputUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes application output configuration updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputUpdates} method.
     * </p>
     * 
     * @return Describes application output configuration updates.
     */
    public final List<OutputUpdate> outputUpdates() {
        return outputUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceDataSourceUpdates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReferenceDataSourceUpdates() {
        return referenceDataSourceUpdates != null && !(referenceDataSourceUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes application reference data source updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceDataSourceUpdates} method.
     * </p>
     * 
     * @return Describes application reference data source updates.
     */
    public final List<ReferenceDataSourceUpdate> referenceDataSourceUpdates() {
        return referenceDataSourceUpdates;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchLoggingOptionUpdates property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudWatchLoggingOptionUpdates() {
        return cloudWatchLoggingOptionUpdates != null && !(cloudWatchLoggingOptionUpdates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes application CloudWatch logging option updates.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchLoggingOptionUpdates} method.
     * </p>
     * 
     * @return Describes application CloudWatch logging option updates.
     */
    public final List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates() {
        return cloudWatchLoggingOptionUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInputUpdates() ? inputUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationCodeUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputUpdates() ? outputUpdates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceDataSourceUpdates() ? referenceDataSourceUpdates() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCloudWatchLoggingOptionUpdates() ? cloudWatchLoggingOptionUpdates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationUpdate)) {
            return false;
        }
        ApplicationUpdate other = (ApplicationUpdate) obj;
        return hasInputUpdates() == other.hasInputUpdates() && Objects.equals(inputUpdates(), other.inputUpdates())
                && Objects.equals(applicationCodeUpdate(), other.applicationCodeUpdate())
                && hasOutputUpdates() == other.hasOutputUpdates() && Objects.equals(outputUpdates(), other.outputUpdates())
                && hasReferenceDataSourceUpdates() == other.hasReferenceDataSourceUpdates()
                && Objects.equals(referenceDataSourceUpdates(), other.referenceDataSourceUpdates())
                && hasCloudWatchLoggingOptionUpdates() == other.hasCloudWatchLoggingOptionUpdates()
                && Objects.equals(cloudWatchLoggingOptionUpdates(), other.cloudWatchLoggingOptionUpdates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ApplicationUpdate")
                .add("InputUpdates", hasInputUpdates() ? inputUpdates() : null)
                .add("ApplicationCodeUpdate", applicationCodeUpdate())
                .add("OutputUpdates", hasOutputUpdates() ? outputUpdates() : null)
                .add("ReferenceDataSourceUpdates", hasReferenceDataSourceUpdates() ? referenceDataSourceUpdates() : null)
                .add("CloudWatchLoggingOptionUpdates",
                        hasCloudWatchLoggingOptionUpdates() ? cloudWatchLoggingOptionUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InputUpdates":
            return Optional.ofNullable(clazz.cast(inputUpdates()));
        case "ApplicationCodeUpdate":
            return Optional.ofNullable(clazz.cast(applicationCodeUpdate()));
        case "OutputUpdates":
            return Optional.ofNullable(clazz.cast(outputUpdates()));
        case "ReferenceDataSourceUpdates":
            return Optional.ofNullable(clazz.cast(referenceDataSourceUpdates()));
        case "CloudWatchLoggingOptionUpdates":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionUpdates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationUpdate, T> g) {
        return obj -> g.apply((ApplicationUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationUpdate> {
        /**
         * <p>
         * Describes application input configuration updates.
         * </p>
         * 
         * @param inputUpdates
         *        Describes application input configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputUpdates(Collection<InputUpdate> inputUpdates);

        /**
         * <p>
         * Describes application input configuration updates.
         * </p>
         * 
         * @param inputUpdates
         *        Describes application input configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputUpdates(InputUpdate... inputUpdates);

        /**
         * <p>
         * Describes application input configuration updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InputUpdate>.Builder} avoiding the need to
         * create one manually via {@link List<InputUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputUpdate>.Builder#build()} is called immediately and its
         * result is passed to {@link #inputUpdates(List<InputUpdate>)}.
         * 
         * @param inputUpdates
         *        a consumer that will call methods on {@link List<InputUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputUpdates(List<InputUpdate>)
         */
        Builder inputUpdates(Consumer<InputUpdate.Builder>... inputUpdates);

        /**
         * <p>
         * Describes application code updates.
         * </p>
         * 
         * @param applicationCodeUpdate
         *        Describes application code updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCodeUpdate(String applicationCodeUpdate);

        /**
         * <p>
         * Describes application output configuration updates.
         * </p>
         * 
         * @param outputUpdates
         *        Describes application output configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUpdates(Collection<OutputUpdate> outputUpdates);

        /**
         * <p>
         * Describes application output configuration updates.
         * </p>
         * 
         * @param outputUpdates
         *        Describes application output configuration updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUpdates(OutputUpdate... outputUpdates);

        /**
         * <p>
         * Describes application output configuration updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OutputUpdate>.Builder} avoiding the need to
         * create one manually via {@link List<OutputUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OutputUpdate>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputUpdates(List<OutputUpdate>)}.
         * 
         * @param outputUpdates
         *        a consumer that will call methods on {@link List<OutputUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputUpdates(List<OutputUpdate>)
         */
        Builder outputUpdates(Consumer<OutputUpdate.Builder>... outputUpdates);

        /**
         * <p>
         * Describes application reference data source updates.
         * </p>
         * 
         * @param referenceDataSourceUpdates
         *        Describes application reference data source updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates);

        /**
         * <p>
         * Describes application reference data source updates.
         * </p>
         * 
         * @param referenceDataSourceUpdates
         *        Describes application reference data source updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate... referenceDataSourceUpdates);

        /**
         * <p>
         * Describes application reference data source updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReferenceDataSourceUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<ReferenceDataSourceUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReferenceDataSourceUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link #referenceDataSourceUpdates(List<ReferenceDataSourceUpdate>)}.
         * 
         * @param referenceDataSourceUpdates
         *        a consumer that will call methods on {@link List<ReferenceDataSourceUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceDataSourceUpdates(List<ReferenceDataSourceUpdate>)
         */
        Builder referenceDataSourceUpdates(Consumer<ReferenceDataSourceUpdate.Builder>... referenceDataSourceUpdates);

        /**
         * <p>
         * Describes application CloudWatch logging option updates.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application CloudWatch logging option updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * Describes application CloudWatch logging option updates.
         * </p>
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        Describes application CloudWatch logging option updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates);

        /**
         * <p>
         * Describes application CloudWatch logging option updates.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchLoggingOptionUpdate>.Builder}
         * avoiding the need to create one manually via {@link List<CloudWatchLoggingOptionUpdate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOptionUpdate>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #cloudWatchLoggingOptionUpdates(List<CloudWatchLoggingOptionUpdate>)}.
         * 
         * @param cloudWatchLoggingOptionUpdates
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOptionUpdate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptionUpdates(List<CloudWatchLoggingOptionUpdate>)
         */
        Builder cloudWatchLoggingOptionUpdates(Consumer<CloudWatchLoggingOptionUpdate.Builder>... cloudWatchLoggingOptionUpdates);
    }

    static final class BuilderImpl implements Builder {
        private List<InputUpdate> inputUpdates = DefaultSdkAutoConstructList.getInstance();

        private String applicationCodeUpdate;

        private List<OutputUpdate> outputUpdates = DefaultSdkAutoConstructList.getInstance();

        private List<ReferenceDataSourceUpdate> referenceDataSourceUpdates = DefaultSdkAutoConstructList.getInstance();

        private List<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationUpdate model) {
            inputUpdates(model.inputUpdates);
            applicationCodeUpdate(model.applicationCodeUpdate);
            outputUpdates(model.outputUpdates);
            referenceDataSourceUpdates(model.referenceDataSourceUpdates);
            cloudWatchLoggingOptionUpdates(model.cloudWatchLoggingOptionUpdates);
        }

        public final List<InputUpdate.Builder> getInputUpdates() {
            List<InputUpdate.Builder> result = InputUpdatesCopier.copyToBuilder(this.inputUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputUpdates(Collection<InputUpdate.BuilderImpl> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copyFromBuilder(inputUpdates);
        }

        @Override
        @Transient
        public final Builder inputUpdates(Collection<InputUpdate> inputUpdates) {
            this.inputUpdates = InputUpdatesCopier.copy(inputUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputUpdates(InputUpdate... inputUpdates) {
            inputUpdates(Arrays.asList(inputUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputUpdates(Consumer<InputUpdate.Builder>... inputUpdates) {
            inputUpdates(Stream.of(inputUpdates).map(c -> InputUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationCodeUpdate() {
            return applicationCodeUpdate;
        }

        public final void setApplicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
        }

        @Override
        @Transient
        public final Builder applicationCodeUpdate(String applicationCodeUpdate) {
            this.applicationCodeUpdate = applicationCodeUpdate;
            return this;
        }

        public final List<OutputUpdate.Builder> getOutputUpdates() {
            List<OutputUpdate.Builder> result = OutputUpdatesCopier.copyToBuilder(this.outputUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputUpdates(Collection<OutputUpdate.BuilderImpl> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copyFromBuilder(outputUpdates);
        }

        @Override
        @Transient
        public final Builder outputUpdates(Collection<OutputUpdate> outputUpdates) {
            this.outputUpdates = OutputUpdatesCopier.copy(outputUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputUpdates(OutputUpdate... outputUpdates) {
            outputUpdates(Arrays.asList(outputUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputUpdates(Consumer<OutputUpdate.Builder>... outputUpdates) {
            outputUpdates(Stream.of(outputUpdates).map(c -> OutputUpdate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceDataSourceUpdate.Builder> getReferenceDataSourceUpdates() {
            List<ReferenceDataSourceUpdate.Builder> result = ReferenceDataSourceUpdatesCopier
                    .copyToBuilder(this.referenceDataSourceUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceDataSourceUpdates(
                Collection<ReferenceDataSourceUpdate.BuilderImpl> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copyFromBuilder(referenceDataSourceUpdates);
        }

        @Override
        @Transient
        public final Builder referenceDataSourceUpdates(Collection<ReferenceDataSourceUpdate> referenceDataSourceUpdates) {
            this.referenceDataSourceUpdates = ReferenceDataSourceUpdatesCopier.copy(referenceDataSourceUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(ReferenceDataSourceUpdate... referenceDataSourceUpdates) {
            referenceDataSourceUpdates(Arrays.asList(referenceDataSourceUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder referenceDataSourceUpdates(Consumer<ReferenceDataSourceUpdate.Builder>... referenceDataSourceUpdates) {
            referenceDataSourceUpdates(Stream.of(referenceDataSourceUpdates)
                    .map(c -> ReferenceDataSourceUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CloudWatchLoggingOptionUpdate.Builder> getCloudWatchLoggingOptionUpdates() {
            List<CloudWatchLoggingOptionUpdate.Builder> result = CloudWatchLoggingOptionUpdatesCopier
                    .copyToBuilder(this.cloudWatchLoggingOptionUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate.BuilderImpl> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier
                    .copyFromBuilder(cloudWatchLoggingOptionUpdates);
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptionUpdates(
                Collection<CloudWatchLoggingOptionUpdate> cloudWatchLoggingOptionUpdates) {
            this.cloudWatchLoggingOptionUpdates = CloudWatchLoggingOptionUpdatesCopier.copy(cloudWatchLoggingOptionUpdates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(CloudWatchLoggingOptionUpdate... cloudWatchLoggingOptionUpdates) {
            cloudWatchLoggingOptionUpdates(Arrays.asList(cloudWatchLoggingOptionUpdates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptionUpdates(
                Consumer<CloudWatchLoggingOptionUpdate.Builder>... cloudWatchLoggingOptionUpdates) {
            cloudWatchLoggingOptionUpdates(Stream.of(cloudWatchLoggingOptionUpdates)
                    .map(c -> CloudWatchLoggingOptionUpdate.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ApplicationUpdate build() {
            return new ApplicationUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
