/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TBD
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(CreateApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationDescription").getter(getter(CreateApplicationRequest::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationDescription").build())
            .build();

    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField
            .<List<Input>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(CreateApplicationRequest::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Input> builder(MarshallingType.SDK_POJO)
                                            .constructor(Input::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Output>> OUTPUTS_FIELD = SdkField
            .<List<Output>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(CreateApplicationRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Output> builder(MarshallingType.SDK_POJO)
                                            .constructor(Output::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CloudWatchLoggingOption>> CLOUD_WATCH_LOGGING_OPTIONS_FIELD = SdkField
            .<List<CloudWatchLoggingOption>> builder(MarshallingType.LIST)
            .memberName("CloudWatchLoggingOptions")
            .getter(getter(CreateApplicationRequest::cloudWatchLoggingOptions))
            .setter(setter(Builder::cloudWatchLoggingOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLoggingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLoggingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLICATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationCode").getter(getter(CreateApplicationRequest::applicationCode))
            .setter(setter(Builder::applicationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCode").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            APPLICATION_DESCRIPTION_FIELD, INPUTS_FIELD, OUTPUTS_FIELD, CLOUD_WATCH_LOGGING_OPTIONS_FIELD,
            APPLICATION_CODE_FIELD, TAGS_FIELD));

    private final String applicationName;

    private final String applicationDescription;

    private final List<Input> inputs;

    private final List<Output> outputs;

    private final List<CloudWatchLoggingOption> cloudWatchLoggingOptions;

    private final String applicationCode;

    private final List<Tag> tags;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.cloudWatchLoggingOptions = builder.cloudWatchLoggingOptions;
        this.applicationCode = builder.applicationCode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     * </p>
     * 
     * @return Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Summary description of the application.
     * </p>
     * 
     * @return Summary description of the application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to configure the application input.
     * </p>
     * <p>
     * You can configure your application to receive input from a single streaming source. In this configuration, you
     * map this streaming source to an in-application stream that is created. Your application code can then query the
     * in-application stream like a table (you can think of it as a constantly updating table).
     * </p>
     * <p>
     * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
     * example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
     * this stream on your behalf.
     * </p>
     * <p>
     * To create the in-application stream, you need to specify a schema to transform your data into a schematized
     * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
     * source to record columns in the in-app stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return Use this parameter to configure the application input.</p>
     *         <p>
     *         You can configure your application to receive input from a single streaming source. In this
     *         configuration, you map this streaming source to an in-application stream that is created. Your
     *         application code can then query the in-application stream like a table (you can think of it as a
     *         constantly updating table).
     *         </p>
     *         <p>
     *         For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
     *         (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can
     *         assume to read this stream on your behalf.
     *         </p>
     *         <p>
     *         To create the in-application stream, you need to specify a schema to transform your data into a
     *         schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements in
     *         the streaming source to record columns in the in-app stream.
     */
    public final List<Input> inputs() {
        return inputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can configure application output to write data from any of the in-application streams to up to three
     * destinations.
     * </p>
     * <p>
     * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
     * destinations, or any combination of the three.
     * </p>
     * <p>
     * In the configuration, you specify the in-application stream name, the destination stream or Lambda function
     * Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
     * Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.
     * </p>
     * <p>
     * In the output configuration, you also provide the output stream or Lambda function ARN. For stream destinations,
     * you provide the format of data in the stream (for example, JSON, CSV). You also must provide an IAM role that
     * Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return You can configure application output to write data from any of the in-application streams to up to three
     *         destinations.</p>
     *         <p>
     *         These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
     *         destinations, or any combination of the three.
     *         </p>
     *         <p>
     *         In the configuration, you specify the in-application stream name, the destination stream or Lambda
     *         function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an
     *         IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function
     *         on your behalf.
     *         </p>
     *         <p>
     *         In the output configuration, you also provide the output stream or Lambda function ARN. For stream
     *         destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must
     *         provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on
     *         your behalf.
     */
    public final List<Output> outputs() {
        return outputs;
    }

    /**
     * For responses, this returns true if the service returned a value for the CloudWatchLoggingOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions != null && !(cloudWatchLoggingOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
     * information, see <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working
     * with Amazon CloudWatch Logs</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCloudWatchLoggingOptions} method.
     * </p>
     * 
     * @return Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
     *         CloudWatch Logs</a>.
     */
    public final List<CloudWatchLoggingOption> cloudWatchLoggingOptions() {
        return cloudWatchLoggingOptions;
    }

    /**
     * <p>
     * One or more SQL statements that read input data, transform it, and generate output. For example, you can write a
     * SQL statement that reads data from one in-application stream, generates a running average of the number of
     * advertisement clicks by vendor, and insert resulting rows in another in-application stream using pumps. For more
     * information about the typical pattern, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application Code</a>.
     * </p>
     * <p>
     * You can provide such series of SQL statements, where output of one statement can be used as the input for the
     * next statement. You store intermediate results by creating in-application streams and pumps.
     * </p>
     * <p>
     * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
     * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
     * <code>ExampleOutputStream2</code>, then your application code must create these streams.
     * </p>
     * 
     * @return One or more SQL statements that read input data, transform it, and generate output. For example, you can
     *         write a SQL statement that reads data from one in-application stream, generates a running average of the
     *         number of advertisement clicks by vendor, and insert resulting rows in another in-application stream
     *         using pumps. For more information about the typical pattern, see <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
     *         Code</a>. </p>
     *         <p>
     *         You can provide such series of SQL statements, where output of one statement can be used as the input for
     *         the next statement. You store intermediate results by creating in-application streams and pumps.
     *         </p>
     *         <p>
     *         Note that the application code must create the streams with names specified in the <code>Outputs</code>.
     *         For example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code>
     *         and <code>ExampleOutputStream2</code>, then your application code must create these streams.
     */
    public final String applicationCode() {
        return applicationCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
     * application. Note that the maximum number of application tags includes system tags. The maximum number of
     * user-defined application tags is 50. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
     *         application. Note that the maximum number of application tags includes system tags. The maximum number of
     *         user-defined application tags is 50. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCloudWatchLoggingOptions() ? cloudWatchLoggingOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applicationCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationDescription(), other.applicationDescription()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs())
                && hasCloudWatchLoggingOptions() == other.hasCloudWatchLoggingOptions()
                && Objects.equals(cloudWatchLoggingOptions(), other.cloudWatchLoggingOptions())
                && Objects.equals(applicationCode(), other.applicationCode()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ApplicationName", applicationName())
                .add("ApplicationDescription", applicationDescription()).add("Inputs", hasInputs() ? inputs() : null)
                .add("Outputs", hasOutputs() ? outputs() : null)
                .add("CloudWatchLoggingOptions", hasCloudWatchLoggingOptions() ? cloudWatchLoggingOptions() : null)
                .add("ApplicationCode", applicationCode()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "ApplicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "CloudWatchLoggingOptions":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptions()));
        case "ApplicationCode":
            return Optional.ofNullable(clazz.cast(applicationCode()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * </p>
         * 
         * @param applicationName
         *        Name of your Amazon Kinesis Analytics application (for example, <code>sample-app</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Summary description of the application.
         * </p>
         * 
         * @param applicationDescription
         *        Summary description of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<Input> inputs);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * 
         * @param inputs
         *        Use this parameter to configure the application input.</p>
         *        <p>
         *        You can configure your application to receive input from a single streaming source. In this
         *        configuration, you map this streaming source to an in-application stream that is created. Your
         *        application code can then query the in-application stream like a table (you can think of it as a
         *        constantly updating table).
         *        </p>
         *        <p>
         *        For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream
         *        (for example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can
         *        assume to read this stream on your behalf.
         *        </p>
         *        <p>
         *        To create the in-application stream, you need to specify a schema to transform your data into a
         *        schematized version used in SQL. In the schema, you provide the necessary mapping of the data elements
         *        in the streaming source to record columns in the in-app stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Input... inputs);

        /**
         * <p>
         * Use this parameter to configure the application input.
         * </p>
         * <p>
         * You can configure your application to receive input from a single streaming source. In this configuration,
         * you map this streaming source to an in-application stream that is created. Your application code can then
         * query the in-application stream like a table (you can think of it as a constantly updating table).
         * </p>
         * <p>
         * For the streaming source, you provide its Amazon Resource Name (ARN) and format of data on the stream (for
         * example, JSON, CSV, etc.). You also must provide an IAM role that Amazon Kinesis Analytics can assume to read
         * this stream on your behalf.
         * </p>
         * <p>
         * To create the in-application stream, you need to specify a schema to transform your data into a schematized
         * version used in SQL. In the schema, you provide the necessary mapping of the data elements in the streaming
         * source to record columns in the in-app stream.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Input>.Builder} avoiding the need to create
         * one manually via {@link List<Input>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Input>.Builder#build()} is called immediately and its result
         * is passed to {@link #inputs(List<Input>)}.
         * 
         * @param inputs
         *        a consumer that will call methods on {@link List<Input>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputs(List<Input>)
         */
        Builder inputs(Consumer<Input.Builder>... inputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to three
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
         * destinations, or any combination of the three.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream or Lambda function
         * Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         * Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream or Lambda function ARN. For stream
         * destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an
         * IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        three destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
         *        destinations, or any combination of the three.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream or Lambda
         *        function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an
         *        IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda
         *        function on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream or Lambda function ARN. For stream
         *        destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must
         *        provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function
         *        on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<Output> outputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to three
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
         * destinations, or any combination of the three.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream or Lambda function
         * Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         * Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream or Lambda function ARN. For stream
         * destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an
         * IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.
         * </p>
         * 
         * @param outputs
         *        You can configure application output to write data from any of the in-application streams to up to
         *        three destinations.</p>
         *        <p>
         *        These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
         *        destinations, or any combination of the three.
         *        </p>
         *        <p>
         *        In the configuration, you specify the in-application stream name, the destination stream or Lambda
         *        function Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an
         *        IAM role that Amazon Kinesis Analytics can assume to write to the destination stream or Lambda
         *        function on your behalf.
         *        </p>
         *        <p>
         *        In the output configuration, you also provide the output stream or Lambda function ARN. For stream
         *        destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must
         *        provide an IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function
         *        on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Output... outputs);

        /**
         * <p>
         * You can configure application output to write data from any of the in-application streams to up to three
         * destinations.
         * </p>
         * <p>
         * These destinations can be Amazon Kinesis streams, Amazon Kinesis Firehose delivery streams, AWS Lambda
         * destinations, or any combination of the three.
         * </p>
         * <p>
         * In the configuration, you specify the in-application stream name, the destination stream or Lambda function
         * Amazon Resource Name (ARN), and the format to use when writing data. You must also provide an IAM role that
         * Amazon Kinesis Analytics can assume to write to the destination stream or Lambda function on your behalf.
         * </p>
         * <p>
         * In the output configuration, you also provide the output stream or Lambda function ARN. For stream
         * destinations, you provide the format of data in the stream (for example, JSON, CSV). You also must provide an
         * IAM role that Amazon Kinesis Analytics can assume to write to the stream or Lambda function on your behalf.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Output>.Builder} avoiding the need to
         * create one manually via {@link List<Output>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Output>.Builder#build()} is called immediately and its
         * result is passed to {@link #outputs(List<Output>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<Output>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<Output>)
         */
        Builder outputs(Consumer<Output.Builder>... outputs);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         * CloudWatch Logs</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with
         *        Amazon CloudWatch Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         * CloudWatch Logs</a>.
         * </p>
         * 
         * @param cloudWatchLoggingOptions
         *        Use this parameter to configure a CloudWatch log stream to monitor application configuration errors.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with
         *        Amazon CloudWatch Logs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions);

        /**
         * <p>
         * Use this parameter to configure a CloudWatch log stream to monitor application configuration errors. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html">Working with Amazon
         * CloudWatch Logs</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchLoggingOption>.Builder} avoiding
         * the need to create one manually via {@link List<CloudWatchLoggingOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLoggingOption>.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLoggingOptions(List<CloudWatchLoggingOption>)}.
         * 
         * @param cloudWatchLoggingOptions
         *        a consumer that will call methods on {@link List<CloudWatchLoggingOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLoggingOptions(List<CloudWatchLoggingOption>)
         */
        Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder>... cloudWatchLoggingOptions);

        /**
         * <p>
         * One or more SQL statements that read input data, transform it, and generate output. For example, you can
         * write a SQL statement that reads data from one in-application stream, generates a running average of the
         * number of advertisement clicks by vendor, and insert resulting rows in another in-application stream using
         * pumps. For more information about the typical pattern, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         * Code</a>.
         * </p>
         * <p>
         * You can provide such series of SQL statements, where output of one statement can be used as the input for the
         * next statement. You store intermediate results by creating in-application streams and pumps.
         * </p>
         * <p>
         * Note that the application code must create the streams with names specified in the <code>Outputs</code>. For
         * example, if your <code>Outputs</code> defines output streams named <code>ExampleOutputStream1</code> and
         * <code>ExampleOutputStream2</code>, then your application code must create these streams.
         * </p>
         * 
         * @param applicationCode
         *        One or more SQL statements that read input data, transform it, and generate output. For example, you
         *        can write a SQL statement that reads data from one in-application stream, generates a running average
         *        of the number of advertisement clicks by vendor, and insert resulting rows in another in-application
         *        stream using pumps. For more information about the typical pattern, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-app-code.html">Application
         *        Code</a>. </p>
         *        <p>
         *        You can provide such series of SQL statements, where output of one statement can be used as the input
         *        for the next statement. You store intermediate results by creating in-application streams and pumps.
         *        </p>
         *        <p>
         *        Note that the application code must create the streams with names specified in the
         *        <code>Outputs</code>. For example, if your <code>Outputs</code> defines output streams named
         *        <code>ExampleOutputStream1</code> and <code>ExampleOutputStream2</code>, then your application code
         *        must create these streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCode(String applicationCode);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
         * </p>
         * 
         * @param tags
         *        A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         *        application. Note that the maximum number of application tags includes system tags. The maximum number
         *        of user-defined application tags is 50. For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
         * </p>
         * 
         * @param tags
         *        A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         *        application. Note that the maximum number of application tags includes system tags. The maximum number
         *        of user-defined application tags is 50. For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of one or more tags to assign to the application. A tag is a key-value pair that identifies an
         * application. Note that the maximum number of application tags includes system tags. The maximum number of
         * user-defined application tags is 50. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-tagging.html">Using Tagging</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private String applicationDescription;

        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();

        private List<Output> outputs = DefaultSdkAutoConstructList.getInstance();

        private List<CloudWatchLoggingOption> cloudWatchLoggingOptions = DefaultSdkAutoConstructList.getInstance();

        private String applicationCode;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            applicationDescription(model.applicationDescription);
            inputs(model.inputs);
            outputs(model.outputs);
            cloudWatchLoggingOptions(model.cloudWatchLoggingOptions);
            applicationCode(model.applicationCode);
            tags(model.tags);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        @Transient
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        @Transient
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final List<Input.Builder> getInputs() {
            List<Input.Builder> result = InputsCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = InputsCopier.copyFromBuilder(inputs);
        }

        @Override
        @Transient
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = InputsCopier.copy(inputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputs(Input... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder>... inputs) {
            inputs(Stream.of(inputs).map(c -> Input.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Output.Builder> getOutputs() {
            List<Output.Builder> result = OutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<Output.BuilderImpl> outputs) {
            this.outputs = OutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Output... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outputs(Consumer<Output.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> Output.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CloudWatchLoggingOption.Builder> getCloudWatchLoggingOptions() {
            List<CloudWatchLoggingOption.Builder> result = CloudWatchLoggingOptionsCopier
                    .copyToBuilder(this.cloudWatchLoggingOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCloudWatchLoggingOptions(Collection<CloudWatchLoggingOption.BuilderImpl> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copyFromBuilder(cloudWatchLoggingOptions);
        }

        @Override
        @Transient
        public final Builder cloudWatchLoggingOptions(Collection<CloudWatchLoggingOption> cloudWatchLoggingOptions) {
            this.cloudWatchLoggingOptions = CloudWatchLoggingOptionsCopier.copy(cloudWatchLoggingOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(CloudWatchLoggingOption... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Arrays.asList(cloudWatchLoggingOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder cloudWatchLoggingOptions(Consumer<CloudWatchLoggingOption.Builder>... cloudWatchLoggingOptions) {
            cloudWatchLoggingOptions(Stream.of(cloudWatchLoggingOptions)
                    .map(c -> CloudWatchLoggingOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationCode() {
            return applicationCode;
        }

        public final void setApplicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
        }

        @Override
        @Transient
        public final Builder applicationCode(String applicationCode) {
            this.applicationCode = applicationCode;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
