/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApplicationsResponse extends KinesisAnalyticsResponse implements
        ToCopyableBuilder<ListApplicationsResponse.Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationSummary>> APPLICATION_SUMMARIES_FIELD = SdkField
            .<List<ApplicationSummary>> builder(MarshallingType.LIST)
            .memberName("ApplicationSummaries")
            .getter(getter(ListApplicationsResponse::applicationSummaries))
            .setter(setter(Builder::applicationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApplicationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApplicationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> HAS_MORE_APPLICATIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasMoreApplications").getter(getter(ListApplicationsResponse::hasMoreApplications))
            .setter(setter(Builder::hasMoreApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasMoreApplications").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARIES_FIELD,
            HAS_MORE_APPLICATIONS_FIELD));

    private final List<ApplicationSummary> applicationSummaries;

    private final Boolean hasMoreApplications;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaries = builder.applicationSummaries;
        this.hasMoreApplications = builder.hasMoreApplications;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationSummaries() {
        return applicationSummaries != null && !(applicationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of <code>ApplicationSummary</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationSummaries} method.
     * </p>
     * 
     * @return List of <code>ApplicationSummary</code> objects.
     */
    public final List<ApplicationSummary> applicationSummaries() {
        return applicationSummaries;
    }

    /**
     * <p>
     * Returns true if there are more applications to retrieve.
     * </p>
     * 
     * @return Returns true if there are more applications to retrieve.
     */
    public final Boolean hasMoreApplications() {
        return hasMoreApplications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationSummaries() ? applicationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMoreApplications());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse) obj;
        return hasApplicationSummaries() == other.hasApplicationSummaries()
                && Objects.equals(applicationSummaries(), other.applicationSummaries())
                && Objects.equals(hasMoreApplications(), other.hasMoreApplications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApplicationsResponse")
                .add("ApplicationSummaries", hasApplicationSummaries() ? applicationSummaries() : null)
                .add("HasMoreApplications", hasMoreApplications()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationSummaries":
            return Optional.ofNullable(clazz.cast(applicationSummaries()));
        case "HasMoreApplications":
            return Optional.ofNullable(clazz.cast(hasMoreApplications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListApplicationsResponse> {
        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries);

        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * 
         * @param applicationSummaries
         *        List of <code>ApplicationSummary</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationSummaries(ApplicationSummary... applicationSummaries);

        /**
         * <p>
         * List of <code>ApplicationSummary</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ApplicationSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ApplicationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApplicationSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #applicationSummaries(List<ApplicationSummary>)}.
         * 
         * @param applicationSummaries
         *        a consumer that will call methods on {@link List<ApplicationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #applicationSummaries(List<ApplicationSummary>)
         */
        Builder applicationSummaries(Consumer<ApplicationSummary.Builder>... applicationSummaries);

        /**
         * <p>
         * Returns true if there are more applications to retrieve.
         * </p>
         * 
         * @param hasMoreApplications
         *        Returns true if there are more applications to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasMoreApplications(Boolean hasMoreApplications);
    }

    static final class BuilderImpl extends KinesisAnalyticsResponse.BuilderImpl implements Builder {
        private List<ApplicationSummary> applicationSummaries = DefaultSdkAutoConstructList.getInstance();

        private Boolean hasMoreApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            applicationSummaries(model.applicationSummaries);
            hasMoreApplications(model.hasMoreApplications);
        }

        public final List<ApplicationSummary.Builder> getApplicationSummaries() {
            List<ApplicationSummary.Builder> result = ApplicationSummariesCopier.copyToBuilder(this.applicationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary.BuilderImpl> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copyFromBuilder(applicationSummaries);
        }

        @Override
        @Transient
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary... applicationSummaries) {
            applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder applicationSummaries(Consumer<ApplicationSummary.Builder>... applicationSummaries) {
            applicationSummaries(Stream.of(applicationSummaries).map(c -> ApplicationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getHasMoreApplications() {
            return hasMoreApplications;
        }

        public final void setHasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
        }

        @Override
        @Transient
        public final Builder hasMoreApplications(Boolean hasMoreApplications) {
            this.hasMoreApplications = hasMoreApplications;
            return this;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
