/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the application output configuration, which includes the in-application stream name and the destination
 * where the stream data is written. The destination can be an Amazon Kinesis stream or an Amazon Kinesis Firehose
 * delivery stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<OutputDescription.Builder, OutputDescription> {
    private static final SdkField<String> OUTPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputId").getter(getter(OutputDescription::outputId)).setter(setter(Builder::outputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(OutputDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<KinesisStreamsOutputDescription> KINESIS_STREAMS_OUTPUT_DESCRIPTION_FIELD = SdkField
            .<KinesisStreamsOutputDescription> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamsOutputDescription")
            .getter(getter(OutputDescription::kinesisStreamsOutputDescription))
            .setter(setter(Builder::kinesisStreamsOutputDescription))
            .constructor(KinesisStreamsOutputDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutputDescription")
                    .build()).build();

    private static final SdkField<KinesisFirehoseOutputDescription> KINESIS_FIREHOSE_OUTPUT_DESCRIPTION_FIELD = SdkField
            .<KinesisFirehoseOutputDescription> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisFirehoseOutputDescription")
            .getter(getter(OutputDescription::kinesisFirehoseOutputDescription))
            .setter(setter(Builder::kinesisFirehoseOutputDescription))
            .constructor(KinesisFirehoseOutputDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutputDescription")
                    .build()).build();

    private static final SdkField<LambdaOutputDescription> LAMBDA_OUTPUT_DESCRIPTION_FIELD = SdkField
            .<LambdaOutputDescription> builder(MarshallingType.SDK_POJO).memberName("LambdaOutputDescription")
            .getter(getter(OutputDescription::lambdaOutputDescription)).setter(setter(Builder::lambdaOutputDescription))
            .constructor(LambdaOutputDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutputDescription").build())
            .build();

    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_FIELD = SdkField
            .<DestinationSchema> builder(MarshallingType.SDK_POJO).memberName("DestinationSchema")
            .getter(getter(OutputDescription::destinationSchema)).setter(setter(Builder::destinationSchema))
            .constructor(DestinationSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ID_FIELD, NAME_FIELD,
            KINESIS_STREAMS_OUTPUT_DESCRIPTION_FIELD, KINESIS_FIREHOSE_OUTPUT_DESCRIPTION_FIELD, LAMBDA_OUTPUT_DESCRIPTION_FIELD,
            DESTINATION_SCHEMA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputId;

    private final String name;

    private final KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

    private final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

    private final LambdaOutputDescription lambdaOutputDescription;

    private final DestinationSchema destinationSchema;

    private OutputDescription(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.name = builder.name;
        this.kinesisStreamsOutputDescription = builder.kinesisStreamsOutputDescription;
        this.kinesisFirehoseOutputDescription = builder.kinesisFirehoseOutputDescription;
        this.lambdaOutputDescription = builder.lambdaOutputDescription;
        this.destinationSchema = builder.destinationSchema;
    }

    /**
     * <p>
     * A unique identifier for the output configuration.
     * </p>
     * 
     * @return A unique identifier for the output configuration.
     */
    public final String outputId() {
        return outputId;
    }

    /**
     * <p>
     * Name of the in-application stream configured as output.
     * </p>
     * 
     * @return Name of the in-application stream configured as output.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Describes Amazon Kinesis stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes Amazon Kinesis stream configured as the destination where output is written.
     */
    public final KinesisStreamsOutputDescription kinesisStreamsOutputDescription() {
        return kinesisStreamsOutputDescription;
    }

    /**
     * <p>
     * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
     * </p>
     * 
     * @return Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
     *         written.
     */
    public final KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription() {
        return kinesisFirehoseOutputDescription;
    }

    /**
     * <p>
     * Describes the AWS Lambda function configured as the destination where output is written.
     * </p>
     * 
     * @return Describes the AWS Lambda function configured as the destination where output is written.
     */
    public final LambdaOutputDescription lambdaOutputDescription() {
        return lambdaOutputDescription;
    }

    /**
     * <p>
     * Data format used for writing data to the destination.
     * </p>
     * 
     * @return Data format used for writing data to the destination.
     */
    public final DestinationSchema destinationSchema() {
        return destinationSchema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaOutputDescription());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputDescription)) {
            return false;
        }
        OutputDescription other = (OutputDescription) obj;
        return Objects.equals(outputId(), other.outputId()) && Objects.equals(name(), other.name())
                && Objects.equals(kinesisStreamsOutputDescription(), other.kinesisStreamsOutputDescription())
                && Objects.equals(kinesisFirehoseOutputDescription(), other.kinesisFirehoseOutputDescription())
                && Objects.equals(lambdaOutputDescription(), other.lambdaOutputDescription())
                && Objects.equals(destinationSchema(), other.destinationSchema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputDescription").add("OutputId", outputId()).add("Name", name())
                .add("KinesisStreamsOutputDescription", kinesisStreamsOutputDescription())
                .add("KinesisFirehoseOutputDescription", kinesisFirehoseOutputDescription())
                .add("LambdaOutputDescription", lambdaOutputDescription()).add("DestinationSchema", destinationSchema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputId":
            return Optional.ofNullable(clazz.cast(outputId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KinesisStreamsOutputDescription":
            return Optional.ofNullable(clazz.cast(kinesisStreamsOutputDescription()));
        case "KinesisFirehoseOutputDescription":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseOutputDescription()));
        case "LambdaOutputDescription":
            return Optional.ofNullable(clazz.cast(lambdaOutputDescription()));
        case "DestinationSchema":
            return Optional.ofNullable(clazz.cast(destinationSchema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputDescription, T> g) {
        return obj -> g.apply((OutputDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputDescription> {
        /**
         * <p>
         * A unique identifier for the output configuration.
         * </p>
         * 
         * @param outputId
         *        A unique identifier for the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        /**
         * <p>
         * Name of the in-application stream configured as output.
         * </p>
         * 
         * @param name
         *        Name of the in-application stream configured as output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Describes Amazon Kinesis stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisStreamsOutputDescription
         *        Describes Amazon Kinesis stream configured as the destination where output is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription);

        /**
         * <p>
         * Describes Amazon Kinesis stream configured as the destination where output is written.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisStreamsOutputDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamsOutputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisStreamsOutputDescription(KinesisStreamsOutputDescription)}.
         * 
         * @param kinesisStreamsOutputDescription
         *        a consumer that will call methods on {@link KinesisStreamsOutputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutputDescription(KinesisStreamsOutputDescription)
         */
        default Builder kinesisStreamsOutputDescription(
                Consumer<KinesisStreamsOutputDescription.Builder> kinesisStreamsOutputDescription) {
            return kinesisStreamsOutputDescription(KinesisStreamsOutputDescription.builder()
                    .applyMutation(kinesisStreamsOutputDescription).build());
        }

        /**
         * <p>
         * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
         * </p>
         * 
         * @param kinesisFirehoseOutputDescription
         *        Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is
         *        written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription);

        /**
         * <p>
         * Describes the Amazon Kinesis Firehose delivery stream configured as the destination where output is written.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisFirehoseOutputDescription.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseOutputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutputDescription.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription)}.
         * 
         * @param kinesisFirehoseOutputDescription
         *        a consumer that will call methods on {@link KinesisFirehoseOutputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription)
         */
        default Builder kinesisFirehoseOutputDescription(
                Consumer<KinesisFirehoseOutputDescription.Builder> kinesisFirehoseOutputDescription) {
            return kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription.builder()
                    .applyMutation(kinesisFirehoseOutputDescription).build());
        }

        /**
         * <p>
         * Describes the AWS Lambda function configured as the destination where output is written.
         * </p>
         * 
         * @param lambdaOutputDescription
         *        Describes the AWS Lambda function configured as the destination where output is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaOutputDescription(LambdaOutputDescription lambdaOutputDescription);

        /**
         * <p>
         * Describes the AWS Lambda function configured as the destination where output is written.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaOutputDescription.Builder} avoiding the
         * need to create one manually via {@link LambdaOutputDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaOutputDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #lambdaOutputDescription(LambdaOutputDescription)}.
         * 
         * @param lambdaOutputDescription
         *        a consumer that will call methods on {@link LambdaOutputDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaOutputDescription(LambdaOutputDescription)
         */
        default Builder lambdaOutputDescription(Consumer<LambdaOutputDescription.Builder> lambdaOutputDescription) {
            return lambdaOutputDescription(LambdaOutputDescription.builder().applyMutation(lambdaOutputDescription).build());
        }

        /**
         * <p>
         * Data format used for writing data to the destination.
         * </p>
         * 
         * @param destinationSchema
         *        Data format used for writing data to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchema(DestinationSchema destinationSchema);

        /**
         * <p>
         * Data format used for writing data to the destination.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationSchema.Builder} avoiding the need to
         * create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchema(DestinationSchema)}.
         * 
         * @param destinationSchema
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchema(DestinationSchema)
         */
        default Builder destinationSchema(Consumer<DestinationSchema.Builder> destinationSchema) {
            return destinationSchema(DestinationSchema.builder().applyMutation(destinationSchema).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputId;

        private String name;

        private KinesisStreamsOutputDescription kinesisStreamsOutputDescription;

        private KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription;

        private LambdaOutputDescription lambdaOutputDescription;

        private DestinationSchema destinationSchema;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputDescription model) {
            outputId(model.outputId);
            name(model.name);
            kinesisStreamsOutputDescription(model.kinesisStreamsOutputDescription);
            kinesisFirehoseOutputDescription(model.kinesisFirehoseOutputDescription);
            lambdaOutputDescription(model.lambdaOutputDescription);
            destinationSchema(model.destinationSchema);
        }

        public final String getOutputId() {
            return outputId;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        @Transient
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final KinesisStreamsOutputDescription.Builder getKinesisStreamsOutputDescription() {
            return kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription.toBuilder() : null;
        }

        public final void setKinesisStreamsOutputDescription(
                KinesisStreamsOutputDescription.BuilderImpl kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription != null ? kinesisStreamsOutputDescription
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisStreamsOutputDescription(KinesisStreamsOutputDescription kinesisStreamsOutputDescription) {
            this.kinesisStreamsOutputDescription = kinesisStreamsOutputDescription;
            return this;
        }

        public final KinesisFirehoseOutputDescription.Builder getKinesisFirehoseOutputDescription() {
            return kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription.toBuilder() : null;
        }

        public final void setKinesisFirehoseOutputDescription(
                KinesisFirehoseOutputDescription.BuilderImpl kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription != null ? kinesisFirehoseOutputDescription
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder kinesisFirehoseOutputDescription(KinesisFirehoseOutputDescription kinesisFirehoseOutputDescription) {
            this.kinesisFirehoseOutputDescription = kinesisFirehoseOutputDescription;
            return this;
        }

        public final LambdaOutputDescription.Builder getLambdaOutputDescription() {
            return lambdaOutputDescription != null ? lambdaOutputDescription.toBuilder() : null;
        }

        public final void setLambdaOutputDescription(LambdaOutputDescription.BuilderImpl lambdaOutputDescription) {
            this.lambdaOutputDescription = lambdaOutputDescription != null ? lambdaOutputDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaOutputDescription(LambdaOutputDescription lambdaOutputDescription) {
            this.lambdaOutputDescription = lambdaOutputDescription;
            return this;
        }

        public final DestinationSchema.Builder getDestinationSchema() {
            return destinationSchema != null ? destinationSchema.toBuilder() : null;
        }

        public final void setDestinationSchema(DestinationSchema.BuilderImpl destinationSchema) {
            this.destinationSchema = destinationSchema != null ? destinationSchema.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationSchema(DestinationSchema destinationSchema) {
            this.destinationSchema = destinationSchema;
            return this;
        }

        @Override
        public OutputDescription build() {
            return new OutputDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
