/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes updates to the output configuration identified by the <code>OutputId</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputUpdate implements SdkPojo, Serializable, ToCopyableBuilder<OutputUpdate.Builder, OutputUpdate> {
    private static final SdkField<String> OUTPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputId").getter(getter(OutputUpdate::outputId)).setter(setter(Builder::outputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputId").build()).build();

    private static final SdkField<String> NAME_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameUpdate").getter(getter(OutputUpdate::nameUpdate)).setter(setter(Builder::nameUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameUpdate").build()).build();

    private static final SdkField<KinesisStreamsOutputUpdate> KINESIS_STREAMS_OUTPUT_UPDATE_FIELD = SdkField
            .<KinesisStreamsOutputUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisStreamsOutputUpdate")
            .getter(getter(OutputUpdate::kinesisStreamsOutputUpdate))
            .setter(setter(Builder::kinesisStreamsOutputUpdate))
            .constructor(KinesisStreamsOutputUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamsOutputUpdate").build())
            .build();

    private static final SdkField<KinesisFirehoseOutputUpdate> KINESIS_FIREHOSE_OUTPUT_UPDATE_FIELD = SdkField
            .<KinesisFirehoseOutputUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("KinesisFirehoseOutputUpdate")
            .getter(getter(OutputUpdate::kinesisFirehoseOutputUpdate))
            .setter(setter(Builder::kinesisFirehoseOutputUpdate))
            .constructor(KinesisFirehoseOutputUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseOutputUpdate")
                    .build()).build();

    private static final SdkField<LambdaOutputUpdate> LAMBDA_OUTPUT_UPDATE_FIELD = SdkField
            .<LambdaOutputUpdate> builder(MarshallingType.SDK_POJO).memberName("LambdaOutputUpdate")
            .getter(getter(OutputUpdate::lambdaOutputUpdate)).setter(setter(Builder::lambdaOutputUpdate))
            .constructor(LambdaOutputUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaOutputUpdate").build())
            .build();

    private static final SdkField<DestinationSchema> DESTINATION_SCHEMA_UPDATE_FIELD = SdkField
            .<DestinationSchema> builder(MarshallingType.SDK_POJO).memberName("DestinationSchemaUpdate")
            .getter(getter(OutputUpdate::destinationSchemaUpdate)).setter(setter(Builder::destinationSchemaUpdate))
            .constructor(DestinationSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSchemaUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_ID_FIELD,
            NAME_UPDATE_FIELD, KINESIS_STREAMS_OUTPUT_UPDATE_FIELD, KINESIS_FIREHOSE_OUTPUT_UPDATE_FIELD,
            LAMBDA_OUTPUT_UPDATE_FIELD, DESTINATION_SCHEMA_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String outputId;

    private final String nameUpdate;

    private final KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;

    private final KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;

    private final LambdaOutputUpdate lambdaOutputUpdate;

    private final DestinationSchema destinationSchemaUpdate;

    private OutputUpdate(BuilderImpl builder) {
        this.outputId = builder.outputId;
        this.nameUpdate = builder.nameUpdate;
        this.kinesisStreamsOutputUpdate = builder.kinesisStreamsOutputUpdate;
        this.kinesisFirehoseOutputUpdate = builder.kinesisFirehoseOutputUpdate;
        this.lambdaOutputUpdate = builder.lambdaOutputUpdate;
        this.destinationSchemaUpdate = builder.destinationSchemaUpdate;
    }

    /**
     * <p>
     * Identifies the specific output configuration that you want to update.
     * </p>
     * 
     * @return Identifies the specific output configuration that you want to update.
     */
    public final String outputId() {
        return outputId;
    }

    /**
     * <p>
     * If you want to specify a different in-application stream for this output configuration, use this field to specify
     * the new in-application stream name.
     * </p>
     * 
     * @return If you want to specify a different in-application stream for this output configuration, use this field to
     *         specify the new in-application stream name.
     */
    public final String nameUpdate() {
        return nameUpdate;
    }

    /**
     * <p>
     * Describes an Amazon Kinesis stream as the destination for the output.
     * </p>
     * 
     * @return Describes an Amazon Kinesis stream as the destination for the output.
     */
    public final KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate() {
        return kinesisStreamsOutputUpdate;
    }

    /**
     * <p>
     * Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
     * </p>
     * 
     * @return Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
     */
    public final KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate() {
        return kinesisFirehoseOutputUpdate;
    }

    /**
     * <p>
     * Describes an AWS Lambda function as the destination for the output.
     * </p>
     * 
     * @return Describes an AWS Lambda function as the destination for the output.
     */
    public final LambdaOutputUpdate lambdaOutputUpdate() {
        return lambdaOutputUpdate;
    }

    /**
     * <p>
     * Describes the data format when records are written to the destination. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring Application
     * Output</a>.
     * </p>
     * 
     * @return Describes the data format when records are written to the destination. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
     *         Application Output</a>.
     */
    public final DestinationSchema destinationSchemaUpdate() {
        return destinationSchemaUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputId());
        hashCode = 31 * hashCode + Objects.hashCode(nameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamsOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaOutputUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSchemaUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputUpdate)) {
            return false;
        }
        OutputUpdate other = (OutputUpdate) obj;
        return Objects.equals(outputId(), other.outputId()) && Objects.equals(nameUpdate(), other.nameUpdate())
                && Objects.equals(kinesisStreamsOutputUpdate(), other.kinesisStreamsOutputUpdate())
                && Objects.equals(kinesisFirehoseOutputUpdate(), other.kinesisFirehoseOutputUpdate())
                && Objects.equals(lambdaOutputUpdate(), other.lambdaOutputUpdate())
                && Objects.equals(destinationSchemaUpdate(), other.destinationSchemaUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputUpdate").add("OutputId", outputId()).add("NameUpdate", nameUpdate())
                .add("KinesisStreamsOutputUpdate", kinesisStreamsOutputUpdate())
                .add("KinesisFirehoseOutputUpdate", kinesisFirehoseOutputUpdate())
                .add("LambdaOutputUpdate", lambdaOutputUpdate()).add("DestinationSchemaUpdate", destinationSchemaUpdate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OutputId":
            return Optional.ofNullable(clazz.cast(outputId()));
        case "NameUpdate":
            return Optional.ofNullable(clazz.cast(nameUpdate()));
        case "KinesisStreamsOutputUpdate":
            return Optional.ofNullable(clazz.cast(kinesisStreamsOutputUpdate()));
        case "KinesisFirehoseOutputUpdate":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseOutputUpdate()));
        case "LambdaOutputUpdate":
            return Optional.ofNullable(clazz.cast(lambdaOutputUpdate()));
        case "DestinationSchemaUpdate":
            return Optional.ofNullable(clazz.cast(destinationSchemaUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputUpdate, T> g) {
        return obj -> g.apply((OutputUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputUpdate> {
        /**
         * <p>
         * Identifies the specific output configuration that you want to update.
         * </p>
         * 
         * @param outputId
         *        Identifies the specific output configuration that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputId(String outputId);

        /**
         * <p>
         * If you want to specify a different in-application stream for this output configuration, use this field to
         * specify the new in-application stream name.
         * </p>
         * 
         * @param nameUpdate
         *        If you want to specify a different in-application stream for this output configuration, use this field
         *        to specify the new in-application stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameUpdate(String nameUpdate);

        /**
         * <p>
         * Describes an Amazon Kinesis stream as the destination for the output.
         * </p>
         * 
         * @param kinesisStreamsOutputUpdate
         *        Describes an Amazon Kinesis stream as the destination for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate);

        /**
         * <p>
         * Describes an Amazon Kinesis stream as the destination for the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamsOutputUpdate.Builder}
         * avoiding the need to create one manually via {@link KinesisStreamsOutputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisStreamsOutputUpdate.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate)}.
         * 
         * @param kinesisStreamsOutputUpdate
         *        a consumer that will call methods on {@link KinesisStreamsOutputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate)
         */
        default Builder kinesisStreamsOutputUpdate(Consumer<KinesisStreamsOutputUpdate.Builder> kinesisStreamsOutputUpdate) {
            return kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.builder().applyMutation(kinesisStreamsOutputUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
         * </p>
         * 
         * @param kinesisFirehoseOutputUpdate
         *        Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate);

        /**
         * <p>
         * Describes an Amazon Kinesis Firehose delivery stream as the destination for the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisFirehoseOutputUpdate.Builder}
         * avoiding the need to create one manually via {@link KinesisFirehoseOutputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisFirehoseOutputUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate)}.
         * 
         * @param kinesisFirehoseOutputUpdate
         *        a consumer that will call methods on {@link KinesisFirehoseOutputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate)
         */
        default Builder kinesisFirehoseOutputUpdate(Consumer<KinesisFirehoseOutputUpdate.Builder> kinesisFirehoseOutputUpdate) {
            return kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.builder().applyMutation(kinesisFirehoseOutputUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes an AWS Lambda function as the destination for the output.
         * </p>
         * 
         * @param lambdaOutputUpdate
         *        Describes an AWS Lambda function as the destination for the output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaOutputUpdate(LambdaOutputUpdate lambdaOutputUpdate);

        /**
         * <p>
         * Describes an AWS Lambda function as the destination for the output.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaOutputUpdate.Builder} avoiding the
         * need to create one manually via {@link LambdaOutputUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaOutputUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaOutputUpdate(LambdaOutputUpdate)}.
         * 
         * @param lambdaOutputUpdate
         *        a consumer that will call methods on {@link LambdaOutputUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaOutputUpdate(LambdaOutputUpdate)
         */
        default Builder lambdaOutputUpdate(Consumer<LambdaOutputUpdate.Builder> lambdaOutputUpdate) {
            return lambdaOutputUpdate(LambdaOutputUpdate.builder().applyMutation(lambdaOutputUpdate).build());
        }

        /**
         * <p>
         * Describes the data format when records are written to the destination. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         * Application Output</a>.
         * </p>
         * 
         * @param destinationSchemaUpdate
         *        Describes the data format when records are written to the destination. For more information, see <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         *        Application Output</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate);

        /**
         * <p>
         * Describes the data format when records are written to the destination. For more information, see <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/how-it-works-output.html">Configuring
         * Application Output</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationSchema.Builder} avoiding the
         * need to create one manually via {@link DestinationSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSchemaUpdate(DestinationSchema)}.
         * 
         * @param destinationSchemaUpdate
         *        a consumer that will call methods on {@link DestinationSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSchemaUpdate(DestinationSchema)
         */
        default Builder destinationSchemaUpdate(Consumer<DestinationSchema.Builder> destinationSchemaUpdate) {
            return destinationSchemaUpdate(DestinationSchema.builder().applyMutation(destinationSchemaUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String outputId;

        private String nameUpdate;

        private KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate;

        private KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate;

        private LambdaOutputUpdate lambdaOutputUpdate;

        private DestinationSchema destinationSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputUpdate model) {
            outputId(model.outputId);
            nameUpdate(model.nameUpdate);
            kinesisStreamsOutputUpdate(model.kinesisStreamsOutputUpdate);
            kinesisFirehoseOutputUpdate(model.kinesisFirehoseOutputUpdate);
            lambdaOutputUpdate(model.lambdaOutputUpdate);
            destinationSchemaUpdate(model.destinationSchemaUpdate);
        }

        public final String getOutputId() {
            return outputId;
        }

        public final void setOutputId(String outputId) {
            this.outputId = outputId;
        }

        @Override
        public final Builder outputId(String outputId) {
            this.outputId = outputId;
            return this;
        }

        public final String getNameUpdate() {
            return nameUpdate;
        }

        public final void setNameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
        }

        @Override
        public final Builder nameUpdate(String nameUpdate) {
            this.nameUpdate = nameUpdate;
            return this;
        }

        public final KinesisStreamsOutputUpdate.Builder getKinesisStreamsOutputUpdate() {
            return kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.toBuilder() : null;
        }

        public final void setKinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate.BuilderImpl kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate != null ? kinesisStreamsOutputUpdate.build() : null;
        }

        @Override
        public final Builder kinesisStreamsOutputUpdate(KinesisStreamsOutputUpdate kinesisStreamsOutputUpdate) {
            this.kinesisStreamsOutputUpdate = kinesisStreamsOutputUpdate;
            return this;
        }

        public final KinesisFirehoseOutputUpdate.Builder getKinesisFirehoseOutputUpdate() {
            return kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.toBuilder() : null;
        }

        public final void setKinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate.BuilderImpl kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate != null ? kinesisFirehoseOutputUpdate.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseOutputUpdate(KinesisFirehoseOutputUpdate kinesisFirehoseOutputUpdate) {
            this.kinesisFirehoseOutputUpdate = kinesisFirehoseOutputUpdate;
            return this;
        }

        public final LambdaOutputUpdate.Builder getLambdaOutputUpdate() {
            return lambdaOutputUpdate != null ? lambdaOutputUpdate.toBuilder() : null;
        }

        public final void setLambdaOutputUpdate(LambdaOutputUpdate.BuilderImpl lambdaOutputUpdate) {
            this.lambdaOutputUpdate = lambdaOutputUpdate != null ? lambdaOutputUpdate.build() : null;
        }

        @Override
        public final Builder lambdaOutputUpdate(LambdaOutputUpdate lambdaOutputUpdate) {
            this.lambdaOutputUpdate = lambdaOutputUpdate;
            return this;
        }

        public final DestinationSchema.Builder getDestinationSchemaUpdate() {
            return destinationSchemaUpdate != null ? destinationSchemaUpdate.toBuilder() : null;
        }

        public final void setDestinationSchemaUpdate(DestinationSchema.BuilderImpl destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate != null ? destinationSchemaUpdate.build() : null;
        }

        @Override
        public final Builder destinationSchemaUpdate(DestinationSchema destinationSchemaUpdate) {
            this.destinationSchemaUpdate = destinationSchemaUpdate;
            return this;
        }

        @Override
        public OutputUpdate build() {
            return new OutputUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
