/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartApplicationRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<StartApplicationRequest.Builder, StartApplicationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(StartApplicationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<List<InputConfiguration>> INPUT_CONFIGURATIONS_FIELD = SdkField
            .<List<InputConfiguration>> builder(MarshallingType.LIST)
            .memberName("InputConfigurations")
            .getter(getter(StartApplicationRequest::inputConfigurations))
            .setter(setter(Builder::inputConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            INPUT_CONFIGURATIONS_FIELD));

    private final String applicationName;

    private final List<InputConfiguration> inputConfigurations;

    private StartApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.inputConfigurations = builder.inputConfigurations;
    }

    /**
     * <p>
     * Name of the application.
     * </p>
     * 
     * @return Name of the application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputConfigurations() {
        return inputConfigurations != null && !(inputConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
     * reading the streaming source associated with the input. You can also specify where in the streaming source you
     * want Amazon Kinesis Analytics to start reading.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputConfigurations} method.
     * </p>
     * 
     * @return Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
     *         starts reading the streaming source associated with the input. You can also specify where in the
     *         streaming source you want Amazon Kinesis Analytics to start reading.
     */
    public final List<InputConfiguration> inputConfigurations() {
        return inputConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputConfigurations() ? inputConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartApplicationRequest)) {
            return false;
        }
        StartApplicationRequest other = (StartApplicationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && hasInputConfigurations() == other.hasInputConfigurations()
                && Objects.equals(inputConfigurations(), other.inputConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartApplicationRequest").add("ApplicationName", applicationName())
                .add("InputConfigurations", hasInputConfigurations() ? inputConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "InputConfigurations":
            return Optional.ofNullable(clazz.cast(inputConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartApplicationRequest, T> g) {
        return obj -> g.apply((StartApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartApplicationRequest> {
        /**
         * <p>
         * Name of the application.
         * </p>
         * 
         * @param applicationName
         *        Name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * 
         * @param inputConfigurations
         *        Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics
         *        starts reading the streaming source associated with the input. You can also specify where in the
         *        streaming source you want Amazon Kinesis Analytics to start reading.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfigurations(InputConfiguration... inputConfigurations);

        /**
         * <p>
         * Identifies the specific input, by ID, that the application starts consuming. Amazon Kinesis Analytics starts
         * reading the streaming source associated with the input. You can also specify where in the streaming source
         * you want Amazon Kinesis Analytics to start reading.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InputConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<InputConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InputConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #inputConfigurations(List<InputConfiguration>)}.
         * 
         * @param inputConfigurations
         *        a consumer that will call methods on {@link List<InputConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfigurations(List<InputConfiguration>)
         */
        Builder inputConfigurations(Consumer<InputConfiguration.Builder>... inputConfigurations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private List<InputConfiguration> inputConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartApplicationRequest model) {
            super(model);
            applicationName(model.applicationName);
            inputConfigurations(model.inputConfigurations);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final List<InputConfiguration.Builder> getInputConfigurations() {
            List<InputConfiguration.Builder> result = InputConfigurationsCopier.copyToBuilder(this.inputConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputConfigurations(Collection<InputConfiguration.BuilderImpl> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copyFromBuilder(inputConfigurations);
        }

        @Override
        public final Builder inputConfigurations(Collection<InputConfiguration> inputConfigurations) {
            this.inputConfigurations = InputConfigurationsCopier.copy(inputConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(InputConfiguration... inputConfigurations) {
            inputConfigurations(Arrays.asList(inputConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputConfigurations(Consumer<InputConfiguration.Builder>... inputConfigurations) {
            inputConfigurations(Stream.of(inputConfigurations).map(c -> InputConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartApplicationRequest build() {
            return new StartApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
