/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides additional mapping information when JSON is the record format on the streaming source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JSONMappingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<JSONMappingParameters.Builder, JSONMappingParameters> {
    private static final SdkField<String> RECORD_ROW_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecordRowPath").getter(getter(JSONMappingParameters::recordRowPath))
            .setter(setter(Builder::recordRowPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordRowPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ROW_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recordRowPath;

    private JSONMappingParameters(BuilderImpl builder) {
        this.recordRowPath = builder.recordRowPath;
    }

    /**
     * <p>
     * Path to the top-level parent that contains the records.
     * </p>
     * 
     * @return Path to the top-level parent that contains the records.
     */
    public final String recordRowPath() {
        return recordRowPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordRowPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONMappingParameters)) {
            return false;
        }
        JSONMappingParameters other = (JSONMappingParameters) obj;
        return Objects.equals(recordRowPath(), other.recordRowPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JSONMappingParameters").add("RecordRowPath", recordRowPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordRowPath":
            return Optional.ofNullable(clazz.cast(recordRowPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JSONMappingParameters, T> g) {
        return obj -> g.apply((JSONMappingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JSONMappingParameters> {
        /**
         * <p>
         * Path to the top-level parent that contains the records.
         * </p>
         * 
         * @param recordRowPath
         *        Path to the top-level parent that contains the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordRowPath(String recordRowPath);
    }

    static final class BuilderImpl implements Builder {
        private String recordRowPath;

        private BuilderImpl() {
        }

        private BuilderImpl(JSONMappingParameters model) {
            recordRowPath(model.recordRowPath);
        }

        public final String getRecordRowPath() {
            return recordRowPath;
        }

        public final void setRecordRowPath(String recordRowPath) {
            this.recordRowPath = recordRowPath;
        }

        @Override
        @Transient
        public final Builder recordRowPath(String recordRowPath) {
            this.recordRowPath = recordRowPath;
            return this;
        }

        @Override
        public JSONMappingParameters build() {
            return new JSONMappingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
