/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When you update a reference data source configuration for an application, this object provides all the updated values
 * (such as the source bucket name and object key name), the in-application table name that is created, and updated
 * mapping information that maps the data in the Amazon S3 object to the in-application reference table that is created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceDataSourceUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceDataSourceUpdate.Builder, ReferenceDataSourceUpdate> {
    private static final SdkField<String> REFERENCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReferenceId").getter(getter(ReferenceDataSourceUpdate::referenceId))
            .setter(setter(Builder::referenceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceId").build()).build();

    private static final SdkField<String> TABLE_NAME_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableNameUpdate").getter(getter(ReferenceDataSourceUpdate::tableNameUpdate))
            .setter(setter(Builder::tableNameUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNameUpdate").build()).build();

    private static final SdkField<S3ReferenceDataSourceUpdate> S3_REFERENCE_DATA_SOURCE_UPDATE_FIELD = SdkField
            .<S3ReferenceDataSourceUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("S3ReferenceDataSourceUpdate")
            .getter(getter(ReferenceDataSourceUpdate::s3ReferenceDataSourceUpdate))
            .setter(setter(Builder::s3ReferenceDataSourceUpdate))
            .constructor(S3ReferenceDataSourceUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReferenceDataSourceUpdate")
                    .build()).build();

    private static final SdkField<SourceSchema> REFERENCE_SCHEMA_UPDATE_FIELD = SdkField
            .<SourceSchema> builder(MarshallingType.SDK_POJO).memberName("ReferenceSchemaUpdate")
            .getter(getter(ReferenceDataSourceUpdate::referenceSchemaUpdate)).setter(setter(Builder::referenceSchemaUpdate))
            .constructor(SourceSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceSchemaUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_ID_FIELD,
            TABLE_NAME_UPDATE_FIELD, S3_REFERENCE_DATA_SOURCE_UPDATE_FIELD, REFERENCE_SCHEMA_UPDATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String referenceId;

    private final String tableNameUpdate;

    private final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

    private final SourceSchema referenceSchemaUpdate;

    private ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.referenceId = builder.referenceId;
        this.tableNameUpdate = builder.tableNameUpdate;
        this.s3ReferenceDataSourceUpdate = builder.s3ReferenceDataSourceUpdate;
        this.referenceSchemaUpdate = builder.referenceSchemaUpdate;
    }

    /**
     * <p>
     * ID of the reference data source being updated. You can use the <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     * >DescribeApplication</a> operation to get this value.
     * </p>
     * 
     * @return ID of the reference data source being updated. You can use the <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     *         >DescribeApplication</a> operation to get this value.
     */
    public final String referenceId() {
        return referenceId;
    }

    /**
     * <p>
     * In-application table name that is created by this update.
     * </p>
     * 
     * @return In-application table name that is created by this update.
     */
    public final String tableNameUpdate() {
        return tableNameUpdate;
    }

    /**
     * <p>
     * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read the
     * Amazon S3 object on your behalf and populate the in-application reference table.
     * </p>
     * 
     * @return Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to
     *         read the Amazon S3 object on your behalf and populate the in-application reference table.
     */
    public final S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate() {
        return s3ReferenceDataSourceUpdate;
    }

    /**
     * <p>
     * Describes the format of the data in the streaming source, and how each data element maps to corresponding columns
     * created in the in-application stream.
     * </p>
     * 
     * @return Describes the format of the data in the streaming source, and how each data element maps to corresponding
     *         columns created in the in-application stream.
     */
    public final SourceSchema referenceSchemaUpdate() {
        return referenceSchemaUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(referenceId());
        hashCode = 31 * hashCode + Objects.hashCode(tableNameUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(s3ReferenceDataSourceUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(referenceSchemaUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceDataSourceUpdate)) {
            return false;
        }
        ReferenceDataSourceUpdate other = (ReferenceDataSourceUpdate) obj;
        return Objects.equals(referenceId(), other.referenceId()) && Objects.equals(tableNameUpdate(), other.tableNameUpdate())
                && Objects.equals(s3ReferenceDataSourceUpdate(), other.s3ReferenceDataSourceUpdate())
                && Objects.equals(referenceSchemaUpdate(), other.referenceSchemaUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceDataSourceUpdate").add("ReferenceId", referenceId())
                .add("TableNameUpdate", tableNameUpdate()).add("S3ReferenceDataSourceUpdate", s3ReferenceDataSourceUpdate())
                .add("ReferenceSchemaUpdate", referenceSchemaUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReferenceId":
            return Optional.ofNullable(clazz.cast(referenceId()));
        case "TableNameUpdate":
            return Optional.ofNullable(clazz.cast(tableNameUpdate()));
        case "S3ReferenceDataSourceUpdate":
            return Optional.ofNullable(clazz.cast(s3ReferenceDataSourceUpdate()));
        case "ReferenceSchemaUpdate":
            return Optional.ofNullable(clazz.cast(referenceSchemaUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceDataSourceUpdate, T> g) {
        return obj -> g.apply((ReferenceDataSourceUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceDataSourceUpdate> {
        /**
         * <p>
         * ID of the reference data source being updated. You can use the <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         * >DescribeApplication</a> operation to get this value.
         * </p>
         * 
         * @param referenceId
         *        ID of the reference data source being updated. You can use the <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         *        >DescribeApplication</a> operation to get this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceId(String referenceId);

        /**
         * <p>
         * In-application table name that is created by this update.
         * </p>
         * 
         * @param tableNameUpdate
         *        In-application table name that is created by this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableNameUpdate(String tableNameUpdate);

        /**
         * <p>
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read
         * the Amazon S3 object on your behalf and populate the in-application reference table.
         * </p>
         * 
         * @param s3ReferenceDataSourceUpdate
         *        Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume
         *        to read the Amazon S3 object on your behalf and populate the in-application reference table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate);

        /**
         * <p>
         * Describes the S3 bucket name, object key name, and IAM role that Amazon Kinesis Analytics can assume to read
         * the Amazon S3 object on your behalf and populate the in-application reference table.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ReferenceDataSourceUpdate.Builder} avoiding
         * the need to create one manually via {@link S3ReferenceDataSourceUpdate#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ReferenceDataSourceUpdate.Builder#build()} is called
         * immediately and its result is passed to {@link #s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate)}.
         * 
         * @param s3ReferenceDataSourceUpdate
         *        a consumer that will call methods on {@link S3ReferenceDataSourceUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate)
         */
        default Builder s3ReferenceDataSourceUpdate(Consumer<S3ReferenceDataSourceUpdate.Builder> s3ReferenceDataSourceUpdate) {
            return s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.builder().applyMutation(s3ReferenceDataSourceUpdate)
                    .build());
        }

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns created in the in-application stream.
         * </p>
         * 
         * @param referenceSchemaUpdate
         *        Describes the format of the data in the streaming source, and how each data element maps to
         *        corresponding columns created in the in-application stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate);

        /**
         * <p>
         * Describes the format of the data in the streaming source, and how each data element maps to corresponding
         * columns created in the in-application stream.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceSchema.Builder} avoiding the need to
         * create one manually via {@link SourceSchema#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #referenceSchemaUpdate(SourceSchema)}.
         * 
         * @param referenceSchemaUpdate
         *        a consumer that will call methods on {@link SourceSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceSchemaUpdate(SourceSchema)
         */
        default Builder referenceSchemaUpdate(Consumer<SourceSchema.Builder> referenceSchemaUpdate) {
            return referenceSchemaUpdate(SourceSchema.builder().applyMutation(referenceSchemaUpdate).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String referenceId;

        private String tableNameUpdate;

        private S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate;

        private SourceSchema referenceSchemaUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceDataSourceUpdate model) {
            referenceId(model.referenceId);
            tableNameUpdate(model.tableNameUpdate);
            s3ReferenceDataSourceUpdate(model.s3ReferenceDataSourceUpdate);
            referenceSchemaUpdate(model.referenceSchemaUpdate);
        }

        public final String getReferenceId() {
            return referenceId;
        }

        public final void setReferenceId(String referenceId) {
            this.referenceId = referenceId;
        }

        @Override
        @Transient
        public final Builder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        public final String getTableNameUpdate() {
            return tableNameUpdate;
        }

        public final void setTableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
        }

        @Override
        @Transient
        public final Builder tableNameUpdate(String tableNameUpdate) {
            this.tableNameUpdate = tableNameUpdate;
            return this;
        }

        public final S3ReferenceDataSourceUpdate.Builder getS3ReferenceDataSourceUpdate() {
            return s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.toBuilder() : null;
        }

        public final void setS3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate.BuilderImpl s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate != null ? s3ReferenceDataSourceUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder s3ReferenceDataSourceUpdate(S3ReferenceDataSourceUpdate s3ReferenceDataSourceUpdate) {
            this.s3ReferenceDataSourceUpdate = s3ReferenceDataSourceUpdate;
            return this;
        }

        public final SourceSchema.Builder getReferenceSchemaUpdate() {
            return referenceSchemaUpdate != null ? referenceSchemaUpdate.toBuilder() : null;
        }

        public final void setReferenceSchemaUpdate(SourceSchema.BuilderImpl referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate != null ? referenceSchemaUpdate.build() : null;
        }

        @Override
        @Transient
        public final Builder referenceSchemaUpdate(SourceSchema referenceSchemaUpdate) {
            this.referenceSchemaUpdate = referenceSchemaUpdate;
            return this;
        }

        @Override
        public ReferenceDataSourceUpdate build() {
            return new ReferenceDataSourceUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
