/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsAsyncClient;
import software.amazon.awssdk.services.kinesisanalytics.KinesisAnalyticsServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisanalytics.internal.KinesisAnalyticsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.CodeValidationException;
import software.amazon.awssdk.services.kinesisanalytics.model.ConcurrentModificationException;
import software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.InvalidApplicationConfigurationException;
import software.amazon.awssdk.services.kinesisanalytics.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisanalytics.model.KinesisAnalyticsException;
import software.amazon.awssdk.services.kinesisanalytics.model.LimitExceededException;
import software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisanalytics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisanalytics.model.ResourceProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesisanalytics.model.ServiceUnavailableException;
import software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.TooManyTagsException;
import software.amazon.awssdk.services.kinesisanalytics.model.UnableToDetectSchemaException;
import software.amazon.awssdk.services.kinesisanalytics.model.UnsupportedOperationException;
import software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.kinesisanalytics.transform.AddApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.AddApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.AddApplicationInputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.AddApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.AddApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DeleteApplicationCloudWatchLoggingOptionRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DeleteApplicationInputProcessingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DeleteApplicationOutputRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DeleteApplicationReferenceDataSourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DescribeApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.DiscoverInputSchemaRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.StartApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.StopApplicationRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisanalytics.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKinesisAnalyticsAsyncClient
implements KinesisAnalyticsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisAnalyticsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisAnalyticsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AddApplicationCloudWatchLoggingOptionResponse> addApplicationCloudWatchLoggingOption(AddApplicationCloudWatchLoggingOptionRequest addApplicationCloudWatchLoggingOptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationCloudWatchLoggingOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationCloudWatchLoggingOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationCloudWatchLoggingOptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationCloudWatchLoggingOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationCloudWatchLoggingOptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationCloudWatchLoggingOption$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationCloudWatchLoggingOption$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationInputResponse> addApplicationInput(AddApplicationInputRequest addApplicationInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationInput$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationInput$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationInputProcessingConfigurationResponse> addApplicationInputProcessingConfiguration(AddApplicationInputProcessingConfigurationRequest addApplicationInputProcessingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationInputProcessingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationInputProcessingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationInputProcessingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationInputProcessingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationInputProcessingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationInputProcessingConfiguration$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationInputProcessingConfiguration$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationOutputResponse> addApplicationOutput(AddApplicationOutputRequest addApplicationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationOutputResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationOutput$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationOutput$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddApplicationReferenceDataSourceResponse> addApplicationReferenceDataSource(AddApplicationReferenceDataSourceRequest addApplicationReferenceDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addApplicationReferenceDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, addApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddApplicationReferenceDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddApplicationReferenceDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddApplicationReferenceDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addApplicationReferenceDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationReferenceDataSource$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$addApplicationReferenceDataSource$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$createApplication$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$createApplication$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplication$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplication$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationCloudWatchLoggingOptionResponse> deleteApplicationCloudWatchLoggingOption(DeleteApplicationCloudWatchLoggingOptionRequest deleteApplicationCloudWatchLoggingOptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationCloudWatchLoggingOptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationCloudWatchLoggingOption");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationCloudWatchLoggingOptionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationCloudWatchLoggingOption").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationCloudWatchLoggingOptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationCloudWatchLoggingOptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationCloudWatchLoggingOption$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationCloudWatchLoggingOption$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationInputProcessingConfigurationResponse> deleteApplicationInputProcessingConfiguration(DeleteApplicationInputProcessingConfigurationRequest deleteApplicationInputProcessingConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationInputProcessingConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationInputProcessingConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationInputProcessingConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationInputProcessingConfigurationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationInputProcessingConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationInputProcessingConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationInputProcessingConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationInputProcessingConfiguration$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationInputProcessingConfiguration$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationOutputResponse> deleteApplicationOutput(DeleteApplicationOutputRequest deleteApplicationOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationOutputResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationOutput$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationOutput$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteApplicationReferenceDataSourceResponse> deleteApplicationReferenceDataSource(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteApplicationReferenceDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteApplicationReferenceDataSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplicationReferenceDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationReferenceDataSourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationReferenceDataSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteApplicationReferenceDataSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteApplicationReferenceDataSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationReferenceDataSource$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$deleteApplicationReferenceDataSource$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeApplicationResponse> describeApplication(DescribeApplicationRequest describeApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, describeApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$describeApplication$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$describeApplication$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DiscoverInputSchemaResponse> discoverInputSchema(DiscoverInputSchemaRequest discoverInputSchemaRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)discoverInputSchemaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, discoverInputSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DiscoverInputSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DiscoverInputSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DiscoverInputSchema").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DiscoverInputSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)discoverInputSchemaRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$discoverInputSchema$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$discoverInputSchema$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplications");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listApplicationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$listApplications$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$listApplications$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$listTagsForResource$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$listTagsForResource$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartApplicationResponse> startApplication(StartApplicationRequest startApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, startApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$startApplication$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$startApplication$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopApplicationResponse> stopApplication(StopApplicationRequest stopApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, stopApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$stopApplication$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$stopApplication$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$tagResource$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$tagResource$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$untagResource$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$untagResource$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisAnalyticsAsyncClient.resolveMetricPublishers(clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Analytics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateApplicationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisAnalyticsAsyncClient.lambda$updateApplication$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisAnalyticsAsyncClient.lambda$updateApplication$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final KinesisAnalyticsServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisAnalyticsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "kinesisanalytics";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisAnalyticsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnableToDetectSchemaException").exceptionBuilderSupplier(UnableToDetectSchemaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceProvisionedThroughputExceededException").exceptionBuilderSupplier(ResourceProvisionedThroughputExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidApplicationConfigurationException").exceptionBuilderSupplier(InvalidApplicationConfigurationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTagsException").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CodeValidationException").exceptionBuilderSupplier(CodeValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisAnalyticsServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisAnalyticsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateApplication$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplication$58(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$55(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$52(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopApplication$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopApplication$49(List metricPublishers, MetricCollector apiCallMetricCollector, StopApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startApplication$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startApplication$46(List metricPublishers, MetricCollector apiCallMetricCollector, StartApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$43(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listApplications$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplications$40(List metricPublishers, MetricCollector apiCallMetricCollector, ListApplicationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$discoverInputSchema$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$discoverInputSchema$37(List metricPublishers, MetricCollector apiCallMetricCollector, DiscoverInputSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeApplication$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeApplication$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationReferenceDataSource$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationReferenceDataSource$31(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationReferenceDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationOutput$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationOutput$28(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationInputProcessingConfiguration$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationInputProcessingConfiguration$25(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationInputProcessingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplicationCloudWatchLoggingOption$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplicationCloudWatchLoggingOption$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationCloudWatchLoggingOptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteApplication$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplication$19(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createApplication$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$16(List metricPublishers, MetricCollector apiCallMetricCollector, CreateApplicationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationReferenceDataSource$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationReferenceDataSource$13(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationReferenceDataSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationOutput$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationOutput$10(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationInputProcessingConfiguration$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInputProcessingConfiguration$7(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationInputProcessingConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationInput$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationInput$4(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addApplicationCloudWatchLoggingOption$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addApplicationCloudWatchLoggingOption$1(List metricPublishers, MetricCollector apiCallMetricCollector, AddApplicationCloudWatchLoggingOptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

