/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationInputProcessingConfigurationRequest extends KinesisAnalyticsRequest
        implements
        ToCopyableBuilder<AddApplicationInputProcessingConfigurationRequest.Builder, AddApplicationInputProcessingConfigurationRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(AddApplicationInputProcessingConfigurationRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(AddApplicationInputProcessingConfigurationRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(AddApplicationInputProcessingConfigurationRequest::inputId))
            .setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputId").build()).build();

    private static final SdkField<InputProcessingConfiguration> INPUT_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<InputProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("InputProcessingConfiguration")
            .getter(getter(AddApplicationInputProcessingConfigurationRequest::inputProcessingConfiguration))
            .setter(setter(Builder::inputProcessingConfiguration))
            .constructor(InputProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputProcessingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, INPUT_ID_FIELD, INPUT_PROCESSING_CONFIGURATION_FIELD));

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String inputId;

    private final InputProcessingConfiguration inputProcessingConfiguration;

    private AddApplicationInputProcessingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.inputId = builder.inputId;
        this.inputProcessingConfiguration = builder.inputProcessingConfiguration;
    }

    /**
     * <p>
     * Name of the application to which you want to add the input processing configuration.
     * </p>
     * 
     * @return Name of the application to which you want to add the input processing configuration.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application to which you want to add the input processing configuration. You can use the <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     * >DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Version of the application to which you want to add the input processing configuration. You can use the
     *         <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">
     *         DescribeApplication</a> operation to get the current application version. If the version specified is not
     *         the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The ID of the input configuration to add the input processing configuration to. You can get a list of the input
     * IDs for an application using the <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     * >DescribeApplication</a> operation.
     * </p>
     * 
     * @return The ID of the input configuration to add the input processing configuration to. You can get a list of the
     *         input IDs for an application using the <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     *         >DescribeApplication</a> operation.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">
     * InputProcessingConfiguration</a> to add to the application.
     * </p>
     * 
     * @return The <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html"
     *         >InputProcessingConfiguration</a> to add to the application.
     */
    public final InputProcessingConfiguration inputProcessingConfiguration() {
        return inputProcessingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(inputProcessingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationInputProcessingConfigurationRequest)) {
            return false;
        }
        AddApplicationInputProcessingConfigurationRequest other = (AddApplicationInputProcessingConfigurationRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(inputId(), other.inputId())
                && Objects.equals(inputProcessingConfiguration(), other.inputProcessingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationInputProcessingConfigurationRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId()).add("InputId", inputId())
                .add("InputProcessingConfiguration", inputProcessingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(inputProcessingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationInputProcessingConfigurationRequest, T> g) {
        return obj -> g.apply((AddApplicationInputProcessingConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationInputProcessingConfigurationRequest> {
        /**
         * <p>
         * Name of the application to which you want to add the input processing configuration.
         * </p>
         * 
         * @param applicationName
         *        Name of the application to which you want to add the input processing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application to which you want to add the input processing configuration. You can use the <a
         * href
         * ="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">DescribeApplication
         * </a> operation to get the current application version. If the version specified is not the current version,
         * the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application to which you want to add the input processing configuration. You can use
         *        the <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html">
         *        DescribeApplication</a> operation to get the current application version. If the version specified is
         *        not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The ID of the input configuration to add the input processing configuration to. You can get a list of the
         * input IDs for an application using the <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         * >DescribeApplication</a> operation.
         * </p>
         * 
         * @param inputId
         *        The ID of the input configuration to add the input processing configuration to. You can get a list of
         *        the input IDs for an application using the <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         *        >DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">
         * InputProcessingConfiguration</a> to add to the application.
         * </p>
         * 
         * @param inputProcessingConfiguration
         *        The <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html"
         *        >InputProcessingConfiguration</a> to add to the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_InputProcessingConfiguration.html">
         * InputProcessingConfiguration</a> to add to the application.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link InputProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #inputProcessingConfiguration(InputProcessingConfiguration)}.
         * 
         * @param inputProcessingConfiguration
         *        a consumer that will call methods on {@link InputProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputProcessingConfiguration(InputProcessingConfiguration)
         */
        default Builder inputProcessingConfiguration(Consumer<InputProcessingConfiguration.Builder> inputProcessingConfiguration) {
            return inputProcessingConfiguration(InputProcessingConfiguration.builder()
                    .applyMutation(inputProcessingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String inputId;

        private InputProcessingConfiguration inputProcessingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationInputProcessingConfigurationRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            inputId(model.inputId);
            inputProcessingConfiguration(model.inputProcessingConfiguration);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getInputId() {
            return inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final InputProcessingConfiguration.Builder getInputProcessingConfiguration() {
            return inputProcessingConfiguration != null ? inputProcessingConfiguration.toBuilder() : null;
        }

        public final void setInputProcessingConfiguration(InputProcessingConfiguration.BuilderImpl inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration != null ? inputProcessingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder inputProcessingConfiguration(InputProcessingConfiguration inputProcessingConfiguration) {
            this.inputProcessingConfiguration = inputProcessingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationInputProcessingConfigurationRequest build() {
            return new AddApplicationInputProcessingConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
