/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApplicationCloudWatchLoggingOptionRequest extends KinesisAnalyticsRequest
        implements
        ToCopyableBuilder<DeleteApplicationCloudWatchLoggingOptionRequest.Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(DeleteApplicationCloudWatchLoggingOptionRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(DeleteApplicationCloudWatchLoggingOptionRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOGGING_OPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLoggingOptionId")
            .getter(getter(DeleteApplicationCloudWatchLoggingOptionRequest::cloudWatchLoggingOptionId))
            .setter(setter(Builder::cloudWatchLoggingOptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLoggingOptionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, CLOUD_WATCH_LOGGING_OPTION_ID_FIELD));

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final String cloudWatchLoggingOptionId;

    private DeleteApplicationCloudWatchLoggingOptionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.cloudWatchLoggingOptionId = builder.cloudWatchLoggingOptionId;
    }

    /**
     * <p>
     * The Kinesis Analytics application name.
     * </p>
     * 
     * @return The Kinesis Analytics application name.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The version ID of the Kinesis Analytics application.
     * </p>
     * 
     * @return The version ID of the Kinesis Analytics application.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the
     * <code>CloudWatchLoggingOptionId</code> by using the <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     * >DescribeApplication</a> operation.
     * </p>
     * 
     * @return The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the
     *         <code>CloudWatchLoggingOptionId</code> by using the <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     *         >DescribeApplication</a> operation.
     */
    public final String cloudWatchLoggingOptionId() {
        return cloudWatchLoggingOptionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLoggingOptionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApplicationCloudWatchLoggingOptionRequest)) {
            return false;
        }
        DeleteApplicationCloudWatchLoggingOptionRequest other = (DeleteApplicationCloudWatchLoggingOptionRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(cloudWatchLoggingOptionId(), other.cloudWatchLoggingOptionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteApplicationCloudWatchLoggingOptionRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId())
                .add("CloudWatchLoggingOptionId", cloudWatchLoggingOptionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "CloudWatchLoggingOptionId":
            return Optional.ofNullable(clazz.cast(cloudWatchLoggingOptionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApplicationCloudWatchLoggingOptionRequest, T> g) {
        return obj -> g.apply((DeleteApplicationCloudWatchLoggingOptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteApplicationCloudWatchLoggingOptionRequest> {
        /**
         * <p>
         * The Kinesis Analytics application name.
         * </p>
         * 
         * @param applicationName
         *        The Kinesis Analytics application name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The version ID of the Kinesis Analytics application.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        The version ID of the Kinesis Analytics application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the
         * <code>CloudWatchLoggingOptionId</code> by using the <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         * >DescribeApplication</a> operation.
         * </p>
         * 
         * @param cloudWatchLoggingOptionId
         *        The <code>CloudWatchLoggingOptionId</code> of the CloudWatch logging option to delete. You can get the
         *        <code>CloudWatchLoggingOptionId</code> by using the <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         *        >DescribeApplication</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private String cloudWatchLoggingOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApplicationCloudWatchLoggingOptionRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            cloudWatchLoggingOptionId(model.cloudWatchLoggingOptionId);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final String getCloudWatchLoggingOptionId() {
            return cloudWatchLoggingOptionId;
        }

        public final void setCloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
        }

        @Override
        public final Builder cloudWatchLoggingOptionId(String cloudWatchLoggingOptionId) {
            this.cloudWatchLoggingOptionId = cloudWatchLoggingOptionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteApplicationCloudWatchLoggingOptionRequest build() {
            return new DeleteApplicationCloudWatchLoggingOptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
