/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalytics.model.ApplicationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(ApplicationSummary.getter(ApplicationSummary::applicationName)).setter(ApplicationSummary.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(ApplicationSummary.getter(ApplicationSummary::applicationARN)).setter(ApplicationSummary.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<String> APPLICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationStatus").getter(ApplicationSummary.getter(ApplicationSummary::applicationStatusAsString)).setter(ApplicationSummary.setter(Builder::applicationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, APPLICATION_ARN_FIELD, APPLICATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ApplicationName", APPLICATION_NAME_FIELD);
            this.put("ApplicationARN", APPLICATION_ARN_FIELD);
            this.put("ApplicationStatus", APPLICATION_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String applicationARN;
    private final String applicationStatus;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.applicationARN = builder.applicationARN;
        this.applicationStatus = builder.applicationStatus;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public final String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary)obj;
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationSummary").add("ApplicationName", (Object)this.applicationName()).add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationStatus", (Object)this.applicationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String applicationARN;
        private String applicationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            this.applicationName(model.applicationName);
            this.applicationARN(model.applicationARN);
            this.applicationStatus(model.applicationStatus);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus == null ? null : applicationStatus.toString());
            return this;
        }

        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationSummary> {
        public Builder applicationName(String var1);

        public Builder applicationARN(String var1);

        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);
    }
}

