/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddApplicationOutputRequest extends KinesisAnalyticsRequest implements
        ToCopyableBuilder<AddApplicationOutputRequest.Builder, AddApplicationOutputRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationName").getter(getter(AddApplicationOutputRequest::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()).build();

    private static final SdkField<Long> CURRENT_APPLICATION_VERSION_ID_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("CurrentApplicationVersionId")
            .getter(getter(AddApplicationOutputRequest::currentApplicationVersionId))
            .setter(setter(Builder::currentApplicationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentApplicationVersionId")
                    .build()).build();

    private static final SdkField<Output> OUTPUT_FIELD = SdkField.<Output> builder(MarshallingType.SDK_POJO).memberName("Output")
            .getter(getter(AddApplicationOutputRequest::output)).setter(setter(Builder::output)).constructor(Output::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Output").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD,
            CURRENT_APPLICATION_VERSION_ID_FIELD, OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String applicationName;

    private final Long currentApplicationVersionId;

    private final Output output;

    private AddApplicationOutputRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentApplicationVersionId = builder.currentApplicationVersionId;
        this.output = builder.output;
    }

    /**
     * <p>
     * Name of the application to which you want to add the output configuration.
     * </p>
     * 
     * @return Name of the application to which you want to add the output configuration.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * Version of the application to which you want to add the output configuration. You can use the <a
     * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     * >DescribeApplication</a> operation to get the current application version. If the version specified is not the
     * current version, the <code>ConcurrentModificationException</code> is returned.
     * </p>
     * 
     * @return Version of the application to which you want to add the output configuration. You can use the <a
     *         href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
     *         >DescribeApplication</a> operation to get the current application version. If the version specified is
     *         not the current version, the <code>ConcurrentModificationException</code> is returned.
     */
    public final Long currentApplicationVersionId() {
        return currentApplicationVersionId;
    }

    /**
     * <p>
     * An array of objects, each describing one output configuration. In the output configuration, you specify the name
     * of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis Firehose
     * delivery stream, or an AWS Lambda function), and record the formation to use when writing to the destination.
     * </p>
     * 
     * @return An array of objects, each describing one output configuration. In the output configuration, you specify
     *         the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis
     *         Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the
     *         destination.
     */
    public final Output output() {
        return output;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(currentApplicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(output());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationOutputRequest)) {
            return false;
        }
        AddApplicationOutputRequest other = (AddApplicationOutputRequest) obj;
        return Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(currentApplicationVersionId(), other.currentApplicationVersionId())
                && Objects.equals(output(), other.output());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddApplicationOutputRequest").add("ApplicationName", applicationName())
                .add("CurrentApplicationVersionId", currentApplicationVersionId()).add("Output", output()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "CurrentApplicationVersionId":
            return Optional.ofNullable(clazz.cast(currentApplicationVersionId()));
        case "Output":
            return Optional.ofNullable(clazz.cast(output()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationName", APPLICATION_NAME_FIELD);
        map.put("CurrentApplicationVersionId", CURRENT_APPLICATION_VERSION_ID_FIELD);
        map.put("Output", OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationOutputRequest, T> g) {
        return obj -> g.apply((AddApplicationOutputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisAnalyticsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AddApplicationOutputRequest> {
        /**
         * <p>
         * Name of the application to which you want to add the output configuration.
         * </p>
         * 
         * @param applicationName
         *        Name of the application to which you want to add the output configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * Version of the application to which you want to add the output configuration. You can use the <a
         * href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         * >DescribeApplication</a> operation to get the current application version. If the version specified is not
         * the current version, the <code>ConcurrentModificationException</code> is returned.
         * </p>
         * 
         * @param currentApplicationVersionId
         *        Version of the application to which you want to add the output configuration. You can use the <a
         *        href="https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html"
         *        >DescribeApplication</a> operation to get the current application version. If the version specified is
         *        not the current version, the <code>ConcurrentModificationException</code> is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentApplicationVersionId(Long currentApplicationVersionId);

        /**
         * <p>
         * An array of objects, each describing one output configuration. In the output configuration, you specify the
         * name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis
         * Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the
         * destination.
         * </p>
         * 
         * @param output
         *        An array of objects, each describing one output configuration. In the output configuration, you
         *        specify the name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an
         *        Amazon Kinesis Firehose delivery stream, or an AWS Lambda function), and record the formation to use
         *        when writing to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(Output output);

        /**
         * <p>
         * An array of objects, each describing one output configuration. In the output configuration, you specify the
         * name of an in-application stream, a destination (that is, an Amazon Kinesis stream, an Amazon Kinesis
         * Firehose delivery stream, or an AWS Lambda function), and record the formation to use when writing to the
         * destination.
         * </p>
         * This is a convenience method that creates an instance of the {@link Output.Builder} avoiding the need to
         * create one manually via {@link Output#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Output.Builder#build()} is called immediately and its result is
         * passed to {@link #output(Output)}.
         * 
         * @param output
         *        a consumer that will call methods on {@link Output.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #output(Output)
         */
        default Builder output(Consumer<Output.Builder> output) {
            return output(Output.builder().applyMutation(output).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisAnalyticsRequest.BuilderImpl implements Builder {
        private String applicationName;

        private Long currentApplicationVersionId;

        private Output output;

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationOutputRequest model) {
            super(model);
            applicationName(model.applicationName);
            currentApplicationVersionId(model.currentApplicationVersionId);
            output(model.output);
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final Long getCurrentApplicationVersionId() {
            return currentApplicationVersionId;
        }

        public final void setCurrentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
        }

        @Override
        public final Builder currentApplicationVersionId(Long currentApplicationVersionId) {
            this.currentApplicationVersionId = currentApplicationVersionId;
            return this;
        }

        public final Output.Builder getOutput() {
            return output != null ? output.toBuilder() : null;
        }

        public final void setOutput(Output.BuilderImpl output) {
            this.output = output != null ? output.build() : null;
        }

        @Override
        public final Builder output(Output output) {
            this.output = output;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddApplicationOutputRequest build() {
            return new AddApplicationOutputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
